/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.system;

import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.host.SystemResourceInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.h5.host.system.SystemResourceReservation;
import java.util.ArrayList;
import java.util.List;

public class SystemResourcePropertyProvider
implements PropertyProviderBean {
    private QueryExecutor queryExecutor;

    public SystemResourcePropertyProvider(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @type(value="HostSystem")
    public SystemResourceReservation getSystemResourceReservations(ManagedObjectReference hostRef) throws Exception {
        SystemResourceInfo[] resourceInfo = (SystemResourceInfo[])this.queryExecutor.getProperty((Object)hostRef, "systemResources.child");
        String[] properties = new String[]{"host/system", "host/vim", "host/iofilters"};
        List<ResourceConfigSpec> targetConfigs = this.getConfigForKey(properties, resourceInfo);
        String cpuAllocationFormatted = null;
        String memoryAllocationFormatted = null;
        Long cpuAllocation = 0L;
        Long memoryAllocation = 0L;
        for (ResourceConfigSpec targetConfig : targetConfigs) {
            if (targetConfig.cpuAllocation != null && targetConfig.cpuAllocation.reservation != null) {
                cpuAllocation = cpuAllocation + targetConfig.cpuAllocation.reservation;
            }
            if (targetConfig.memoryAllocation == null || targetConfig.memoryAllocation.reservation == null) continue;
            memoryAllocation = memoryAllocation + targetConfig.memoryAllocation.reservation;
        }
        if (cpuAllocation != 0L) {
            cpuAllocationFormatted = FormatUtil.getFrequencyFormatted((Number)cpuAllocation, (int)2, (long)1000000L, (long)-1L, (boolean)true);
        }
        if (memoryAllocation != 0L) {
            memoryAllocationFormatted = FormatUtil.getDataSizeFormatted((Number)memoryAllocation, (int)2, (long)0x100000L, (long)-1L, (boolean)true);
        }
        return new SystemResourceReservation(cpuAllocationFormatted, memoryAllocationFormatted);
    }

    private List<ResourceConfigSpec> getConfigForKey(String[] keys, SystemResourceInfo[] resourceInfo) {
        ArrayList<ResourceConfigSpec> configSpec = new ArrayList<ResourceConfigSpec>();
        for (String key : keys) {
            for (SystemResourceInfo info : resourceInfo) {
                if (info.key == null || !info.key.equals(key)) continue;
                configSpec.add(info.config);
            }
        }
        return configSpec;
    }
}

