/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.util;

import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.Ruleset;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vise.util.Pair;
import com.vmware.vsphere.client.h5.host.model.FirewallConnection;
import com.vmware.vsphere.client.h5.host.model.FirewallConnectionDirectionInfo;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class FirewallInfoConverter {
    private static final String PORT_RANGE_KEY = "firewallConnection.portRange";
    private static final String PORTS_WITH_PROTOCOL_KEY = "firewallConnection.portsWithProtocol";
    private static final String NETWORK_WITH_MASK_KEY = "firewallConnection.networkWithMask";
    private static final String DELIMITER_KEY = "firewallConnection.delimiter";

    private FirewallInfoConverter() {
    }

    public static FirewallConnection[] toFirewallConnections(FirewallInfo firewallInfo, ServiceInfo serviceInfo) {
        if (firewallInfo == null || ArrayUtils.isEmpty((Object[])firewallInfo.ruleset)) {
            return new FirewallConnection[0];
        }
        Ruleset[] ruleset = firewallInfo.ruleset;
        FirewallConnection[] result = new FirewallConnection[ruleset.length];
        Map<String, Pair<Boolean, Boolean>> rulesetServiceInfos = FirewallInfoConverter.getRulesetServiceInfo(serviceInfo);
        for (int i = 0; i < ruleset.length; ++i) {
            result[i] = FirewallInfoConverter.getServiceConnections(ruleset[i], rulesetServiceInfos.get(ruleset[i].service));
        }
        return result;
    }

    private static Map<String, Pair<Boolean, Boolean>> getRulesetServiceInfo(ServiceInfo serviceInfo) {
        HashMap<String, Pair<Boolean, Boolean>> daemonsStatuses = new HashMap<String, Pair<Boolean, Boolean>>();
        if (serviceInfo != null) {
            for (Service service : serviceInfo.getService()) {
                daemonsStatuses.put(service.getKey(), (Pair<Boolean, Boolean>)new Pair((Object)service.isRunning(), (Object)service.isRequired()));
            }
        }
        return daemonsStatuses;
    }

    private static FirewallConnection getServiceConnections(Ruleset ruleset, Pair<Boolean, Boolean> rulesetServiceInfo) {
        FirewallConnection connection = new FirewallConnection();
        connection.serviceName = ruleset.label;
        connection.serviceKey = ruleset.key;
        connection.enabled = ruleset.enabled;
        connection.ipList = FirewallInfoConverter.getFormattedIpAddresses(ruleset.getAllowedHosts());
        connection.rawIpList = ruleset.getAllowedHosts();
        Boolean daemonStatus = rulesetServiceInfo == null ? null : (Boolean)rulesetServiceInfo.first;
        Boolean rulesetServiceIsRequired = rulesetServiceInfo == null ? false : (Boolean)rulesetServiceInfo.second;
        connection.daemonStatus = daemonStatus;
        connection.group = FirewallInfoConverter.getGroup(ruleset.getKey(), rulesetServiceIsRequired);
        EnumMap<Ruleset.Rule.Protocol, Set<Pair<Integer, Integer>>> inPorts = new EnumMap<Ruleset.Rule.Protocol, Set<Pair<Integer, Integer>>>(Ruleset.Rule.Protocol.class);
        EnumMap<Ruleset.Rule.Protocol, Set<Pair<Integer, Integer>>> outPorts = new EnumMap<Ruleset.Rule.Protocol, Set<Pair<Integer, Integer>>>(Ruleset.Rule.Protocol.class);
        inPorts.put(Ruleset.Rule.Protocol.tcp, new HashSet());
        inPorts.put(Ruleset.Rule.Protocol.udp, new HashSet());
        outPorts.put(Ruleset.Rule.Protocol.tcp, new HashSet());
        outPorts.put(Ruleset.Rule.Protocol.udp, new HashSet());
        if (ruleset.rule != null) {
            block4: for (Ruleset.Rule rule : ruleset.rule) {
                switch (rule.direction) {
                    case inbound: {
                        ((Set)inPorts.get(Ruleset.Rule.Protocol.valueOf((String)rule.protocol))).add(FirewallInfoConverter.getPortRange(rule));
                        continue block4;
                    }
                    case outbound: {
                        ((Set)outPorts.get(Ruleset.Rule.Protocol.valueOf((String)rule.protocol))).add(FirewallInfoConverter.getPortRange(rule));
                    }
                }
            }
        }
        connection.inboundDirectionInfo = FirewallInfoConverter.createDirectionInfo(inPorts, Ruleset.Rule.Direction.inbound);
        connection.outboundDirectionInfo = FirewallInfoConverter.createDirectionInfo(outPorts, Ruleset.Rule.Direction.outbound);
        return connection;
    }

    private static String getGroup(String rulesetKey, Boolean isRequired) {
        String group = HostStringUtil.getString("firewallConnection.edit.groups.ungrouped", new String[0]);
        if ("sshServer".equals(rulesetKey) || "sshClient".equals(rulesetKey)) {
            group = HostStringUtil.getString("firewallConnection.edit.groups.ssh", new String[0]);
        } else if ("snmp".equals(rulesetKey)) {
            group = HostStringUtil.getString("firewallConnection.edit.groups.snmp", new String[0]);
        } else if (isRequired.booleanValue()) {
            group = HostStringUtil.getString("firewallConnection.edit.groups.required", new String[0]);
        }
        return group;
    }

    private static Pair<Integer, Integer> getPortRange(Ruleset.Rule rule) {
        return new Pair((Object)rule.port, (Object)(rule.endPort == null ? rule.port : rule.endPort));
    }

    private static String getFormattedIpAddresses(Ruleset.IpList ipList) {
        if (ipList == null) {
            return "";
        }
        if (ipList.allIp) {
            return HostStringUtil.getString("firewallConnection.allIp", new String[0]);
        }
        ArrayList<String> ipAddresses = new ArrayList<String>();
        if (!ArrayUtils.isEmpty((Object[])ipList.ipAddress)) {
            ipAddresses.addAll(Arrays.asList(ipList.ipAddress));
        }
        if (!ArrayUtils.isEmpty((Object[])ipList.ipNetwork)) {
            for (Ruleset.IpNetwork netRule : ipList.ipNetwork) {
                String subnet = HostStringUtil.getString(NETWORK_WITH_MASK_KEY, netRule.network, String.valueOf(netRule.prefixLength));
                ipAddresses.add(subnet);
            }
        }
        return StringUtils.join(ipAddresses, (String)HostStringUtil.getString(DELIMITER_KEY, new String[0]));
    }

    private static FirewallConnectionDirectionInfo createDirectionInfo(Map<Ruleset.Rule.Protocol, Set<Pair<Integer, Integer>>> ports, Ruleset.Rule.Direction direction) {
        FirewallConnectionDirectionInfo directionInfo = new FirewallConnectionDirectionInfo();
        directionInfo.direction = FirewallInfoConverter.localizeDirection(direction);
        directionInfo.rawTcpPorts = FirewallInfoConverter.getSortedPorts(ports.get(Ruleset.Rule.Protocol.tcp));
        directionInfo.rawUdpPorts = FirewallInfoConverter.getSortedPorts(ports.get(Ruleset.Rule.Protocol.udp));
        directionInfo.tcpPorts = FirewallInfoConverter.getFormattedPorts(directionInfo.rawTcpPorts);
        directionInfo.udpPorts = FirewallInfoConverter.getFormattedPorts(directionInfo.rawUdpPorts);
        directionInfo.combinedPorts = FirewallInfoConverter.getCombinedFormattedPorts(directionInfo.tcpPorts, directionInfo.udpPorts);
        return directionInfo;
    }

    private static String getCombinedFormattedPorts(String formattedTcpPorts, String formattedUdpPorts) {
        ArrayList<String> formattedPortsList = new ArrayList<String>(2);
        if (formattedTcpPorts.length() > 0) {
            formattedPortsList.add(HostStringUtil.getString(PORTS_WITH_PROTOCOL_KEY, formattedTcpPorts, FirewallInfoConverter.localizeProtocol(Ruleset.Rule.Protocol.tcp)));
        }
        if (formattedUdpPorts.length() > 0) {
            formattedPortsList.add(HostStringUtil.getString(PORTS_WITH_PROTOCOL_KEY, formattedUdpPorts, FirewallInfoConverter.localizeProtocol(Ruleset.Rule.Protocol.udp)));
        }
        return StringUtils.join(formattedPortsList, (String)HostStringUtil.getString(DELIMITER_KEY, new String[0]));
    }

    private static String getFormattedPorts(List<Pair<Integer, Integer>> ports) {
        ArrayList<String> formattedPortsList = new ArrayList<String>(ports.size());
        for (Pair<Integer, Integer> portRange : ports) {
            if (((Integer)portRange.first).equals(portRange.second)) {
                formattedPortsList.add(((Integer)portRange.first).toString());
                continue;
            }
            formattedPortsList.add(HostStringUtil.getString(PORT_RANGE_KEY, ((Integer)portRange.first).toString(), ((Integer)portRange.second).toString()));
        }
        return StringUtils.join(formattedPortsList, (String)HostStringUtil.getString(DELIMITER_KEY, new String[0]));
    }

    private static List<Pair<Integer, Integer>> getSortedPorts(Set<Pair<Integer, Integer>> ports) {
        ArrayList<Pair<Integer, Integer>> sortedPorts = new ArrayList<Pair<Integer, Integer>>(ports);
        Collections.sort(sortedPorts, new Comparator<Pair<Integer, Integer>>(){

            @Override
            public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                if ((Integer)o1.first < (Integer)o2.first) {
                    return -1;
                }
                if ((Integer)o2.first < (Integer)o1.first) {
                    return 1;
                }
                return Integer.compare((Integer)o1.second, (Integer)o2.second);
            }
        });
        return sortedPorts;
    }

    private static String localizeProtocol(Ruleset.Rule.Protocol protocol) {
        switch (protocol) {
            case tcp: {
                return HostStringUtil.getString("firewallConnection.tcp", new String[0]);
            }
            case udp: {
                return HostStringUtil.getString("firewallConnection.udp", new String[0]);
            }
        }
        return "";
    }

    private static String localizeDirection(Ruleset.Rule.Direction direction) {
        switch (direction) {
            case inbound: {
                return HostStringUtil.getString("firewallConnection.incoming", new String[0]);
            }
            case outbound: {
                return HostStringUtil.getString("firewallConnection.outgoing", new String[0]);
            }
        }
        return "";
    }
}

