/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.vmdp;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.PciPassthruSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.host.vmdp.spec.HostVmdpRefreshSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostVmdpMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(HostVmdpMutationProvider.class);

    public OperationResult apply(ManagedObjectReference hostRef, HostVmdpRefreshSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            ConfigManager configMgr = host.getConfigManager();
            PciPassthruSystem system = (PciPassthruSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configMgr.pciPassthruSystem);
            system.refresh();
        }
        catch (Exception e) {
            _logger.error((Object)"Exception when trying to refresh the PciConfiguration.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }
}

