/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.config;

import com.vmware.vim.binding.rbd.ExtensionInfo;
import com.vmware.vim.binding.rbd.PXEBinary;
import com.vmware.vim.binding.rbd.ProxyServer;
import com.vmware.vim.binding.rbd.ProxyServerList;
import com.vmware.vim.binding.sca.configuration.Configuration;
import com.vmware.vim.binding.sca.configuration.ConfigurationDefinition;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.vcaddons.data.AutoDeployConfiguration;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.config.ProxyServerData;
import com.vmware.vsphere.client.h5.autodeploy.config.ProxyServerListData;
import com.vmware.vsphere.client.h5.autodeploy.config.ServiceSettingsData;
import com.vmware.vsphere.client.h5.autodeploy.config.legacy.LegacyAutoDeployConfigurationProvider;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoDeployConfigurationPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(AutoDeployConfigurationPropertyProvider.class);
    private static final String IS_STARTABLE_PROP = "isStartable";
    private static final String STATUS_PROP = "status";
    private static final String CONFIGURATIONS_PROP = "configurations";
    private static final String DEFINITIONS_PROP = "definitions";
    private static final String CM_SERVICE_TYPE = "cm:Service";
    private final AutoDeployServiceFactory _autoDeployServiceFactory;
    private final LegacyAutoDeployConfigurationProvider _legacyAutoDeployConfigurationProvider;
    private final ThreadPoolExecutor _threadPoolExecutor;
    private final QueryExecutor _queryExecutor;

    public AutoDeployConfigurationPropertyProvider(AutoDeployServiceFactory autoDeployServiceFactory, LegacyAutoDeployConfigurationProvider legacyAutoDeployConfigurationProvider, ThreadPoolExecutor threadPoolExecutor, QueryExecutor queryExecutor) {
        this._autoDeployServiceFactory = autoDeployServiceFactory;
        this._legacyAutoDeployConfigurationProvider = legacyAutoDeployConfigurationProvider;
        this._threadPoolExecutor = threadPoolExecutor;
        this._queryExecutor = queryExecutor;
    }

    @type(value="Folder")
    public AutoDeployConfiguration getAutoDeployConfiguration(ManagedObjectReference objRef) {
        if (VcServiceUtil.is66VcOrLaterByServerGuid((String)objRef.getServerGuid())) {
            AutoDeployService adService = this._autoDeployServiceFactory.getService(objRef.getServerGuid());
            ExtensionInfo extensionInfo = adService.getServiceInstance().retrieveExtensionInfo();
            return AutoDeployConfigurationPropertyProvider.extensionInfoToAutoDeployConfiguration(extensionInfo);
        }
        return this._legacyAutoDeployConfigurationProvider.getAutoDeployConfiguration(objRef);
    }

    @type(value="Folder")
    public ProxyServerListData getAutoDeployProxyServers(ManagedObjectReference objRef) {
        ProxyServerListData result = new ProxyServerListData();
        AutoDeployService ad = this._autoDeployServiceFactory.getService(objRef.getServerGuid());
        ManagedObjectReference moRef = ad.getServiceContent().getProxyServerList();
        ProxyServerList proxyServerList = (ProxyServerList)ad.getManagedObject(moRef);
        ArrayList<1> requests = new ArrayList<1>();
        ManagedObjectReference[] refs = proxyServerList.retrieveProxyServerList();
        if (refs == null) {
            refs = new ManagedObjectReference[]{};
        }
        ProxyServerData[] proxies = new ProxyServerData[refs.length];
        for (int i = 0; i < refs.length; ++i) {
            final ProxyServer proxyServer = (ProxyServer)ad.getManagedObject(refs[i]);
            final ProxyServerData proxyData = new ProxyServerData();
            requests.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        proxyData.address = proxyServer.getAddress();
                    }
                    catch (Exception e) {
                        _logger.error((Object)"Failed to retrieve address for proxy server.", (Throwable)e);
                    }
                    return null;
                }
            });
            proxies[i] = proxyData;
        }
        result.proxyServers = proxies;
        try {
            this._threadPoolExecutor.invokeAll(requests);
        }
        catch (Exception e) {
            _logger.error((Object)"Unable to retrieve AutoDeploy proxy servers information.", (Throwable)e);
        }
        return result;
    }

    @type(value="Folder")
    public ServiceSettingsData getAutodeployServiceSettingsData(ManagedObjectReference vcRef, String serviceId) {
        VcService vcService = VimSessionUtil.getService((String)vcRef.getServerGuid());
        ServiceEndpointEx[] endpointExes = vcService.getServiceEndPoints();
        String serverName = null;
        if (endpointExes != null) {
            for (ServiceEndpointEx endpointEx : endpointExes) {
                if (!vcRef.getServerGuid().equals(endpointEx.instanceUuid)) continue;
                serverName = endpointEx.getHost();
                break;
            }
        }
        if (serverName != null) {
            String base64EncodedServerName = Base64.encodeBase64URLSafeString((byte[])serverName.getBytes());
            URI serviceUri = DefaultUriSchemeUtil.createUri((String)CM_SERVICE_TYPE, (String[])new String[]{serviceId, base64EncodedServerName});
            try {
                PropertyValue[] propertyValues = this._queryExecutor.getProperties(new Object[]{serviceUri}, new String[]{IS_STARTABLE_PROP, STATUS_PROP, CONFIGURATIONS_PROP, DEFINITIONS_PROP});
                if (propertyValues != null) {
                    return this.extractServiceSettingsDataForService(serviceUri, serviceId, propertyValues);
                }
            }
            catch (Exception e) {
                _logger.error((Object)("Unable to retrieve the settings for service " + serviceId + ". Error:"), (Throwable)e);
            }
        }
        return null;
    }

    private ServiceSettingsData extractServiceSettingsDataForService(URI serviceUri, String serviceId, PropertyValue[] propertyValues) {
        if (propertyValues == null) {
            return null;
        }
        ServiceSettingsData serviceSettingsData = new ServiceSettingsData();
        serviceSettingsData.serviceId = serviceId;
        serviceSettingsData.serviceUri = serviceUri.toString();
        block12: for (PropertyValue propertyValue : propertyValues) {
            if (!serviceUri.equals(propertyValue.resourceObject)) continue;
            switch (propertyValue.propertyName) {
                case "isStartable": {
                    serviceSettingsData.isStartable = (Boolean)propertyValue.value;
                    continue block12;
                }
                case "status": {
                    serviceSettingsData.status = propertyValue.value.toString();
                    continue block12;
                }
                case "configurations": {
                    serviceSettingsData.configurations = (Configuration[])propertyValue.value;
                    continue block12;
                }
                case "definitions": {
                    serviceSettingsData.definitions = (ConfigurationDefinition[])propertyValue.value;
                }
            }
        }
        return serviceSettingsData;
    }

    private static AutoDeployConfiguration extensionInfoToAutoDeployConfiguration(ExtensionInfo extensionInfo) {
        AutoDeployConfiguration config = new AutoDeployConfiguration();
        config.tftpBootZipUrl = extensionInfo.zipUrl;
        ArrayList<KeyValue> settings = new ArrayList<KeyValue>();
        if (extensionInfo.binaries != null) {
            for (PXEBinary binary : extensionInfo.binaries) {
                settings.add(new KeyValue(binary.description, binary.fileName));
            }
        }
        settings.add(new KeyValue(AutoDeployConfigurationPropertyProvider.getLocalizedMessage("config.settings.bootUrl", new String[0]), extensionInfo.bootUrl));
        settings.add(new KeyValue(AutoDeployConfigurationPropertyProvider.getLocalizedMessage("config.settings.cacheSize", new String[0]), extensionInfo.cacheSize));
        settings.add(new KeyValue(AutoDeployConfigurationPropertyProvider.getLocalizedMessage("config.settings.cacheInUse", new String[0]), extensionInfo.cacheInUse));
        config.settings = settings.toArray(new KeyValue[settings.size()]);
        return config;
    }

    private static String getLocalizedMessage(String key, String ... parameters) {
        return ResourceUtil.getString((String)"autodeployservice", (String)key, (String[])parameters, (ClassLoader)AutoDeployConfigurationPropertyProvider.class.getClassLoader());
    }
}

