/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.config.legacy;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.vcaddons.data.AutoDeployConfiguration;
import com.vmware.vsphere.client.h5.autodeploy.config.legacy.util.Util;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LegacyAutoDeployConfigurationProvider {
    private static final Log _logger = LogFactory.getLog(LegacyAutoDeployConfigurationProvider.class);
    private final KeystoreService _keystoreService;

    public LegacyAutoDeployConfigurationProvider(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public AutoDeployConfiguration getAutoDeployConfiguration(ManagedObjectReference objRef) {
        String serverGuid = objRef.getServerGuid();
        Extension.ServerInfo si = Util.getServerInfo(serverGuid, "com.vmware.rbd");
        if (si != null) {
            return this.getAutoDeployConfiguration(si.getUrl(), si.serverThumbprint, serverGuid);
        }
        _logger.error((Object)("Missing com.vmware.vim.viClientScripts serverInfo in AutoDeploy extension for server " + serverGuid));
        return null;
    }

    private AutoDeployConfiguration getAutoDeployConfiguration(String sourceURL, String thumbprint, String serverGuid) {
        try {
            Node child;
            URL autoDeployURL = new URL(sourceURL);
            String response = Util.executeRequest(autoDeployURL, thumbprint, null, this._keystoreService.getKeyStore());
            Document xmlDocument = XMLUtil.parseXml((String)response);
            Element root = xmlDocument.getDocumentElement();
            NodeList children = root.getChildNodes();
            String xmlUrl = null;
            int n = children.getLength();
            for (int i = 0; !(i >= n || (child = children.item(i)).getNodeType() == 1 && child.getNodeName().equals("extension") && (xmlUrl = XMLUtil.getChildTagValue((Node)child, (String)"url")) != null); ++i) {
            }
            if (xmlUrl == null) {
                return null;
            }
            VcService vcServer = VimSessionUtil.getService((String)serverGuid);
            String vimSessionKey = vcServer.getConnectionInfo().getUserSession().getKey();
            URIBuilder autoDeployBaseUrl = new URIBuilder(xmlUrl);
            autoDeployBaseUrl.setPath("");
            String autoDeployHost = autoDeployBaseUrl.build().toString();
            URIBuilder extensionInfoUrl = new URIBuilder(xmlUrl);
            extensionInfoUrl.setParameter("vimSessionKey", vimSessionKey);
            autoDeployURL = extensionInfoUrl.build().toURL();
            response = Util.executeRequest(autoDeployURL, thumbprint, vimSessionKey, this._keystoreService.getKeyStore());
            return this.parseAutoDeployConfiguration(response, autoDeployHost);
        }
        catch (Exception e) {
            _logger.error((Object)"Unable to retrieve AutoDeploy service information.", (Throwable)e);
            return null;
        }
    }

    private AutoDeployConfiguration parseAutoDeployConfiguration(String autoDeployConfigXmlStr, String autoDeployHost) {
        AutoDeployConfiguration autoDeployConfig = new AutoDeployConfiguration();
        Document xmlDocument = null;
        xmlDocument = XMLUtil.parseXml((String)autoDeployConfigXmlStr);
        if (xmlDocument == null) {
            return null;
        }
        Element root = xmlDocument.getDocumentElement();
        NodeList children = root.getChildNodes();
        ArrayList<KeyValue> propertyList = new ArrayList<KeyValue>();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("property")) {
                String propertyName = XMLUtil.getChildTagValue((Node)child, (String)"name");
                String propertyValue = XMLUtil.getChildTagValue((Node)child, (String)"value");
                KeyValue adKeyValue = new KeyValue();
                adKeyValue.key = propertyName;
                adKeyValue.value = propertyValue;
                propertyList.add(adKeyValue);
            }
            if (!child.getNodeName().equals("actions")) continue;
            Element links = XMLUtil.getChildTag((Node)child, (String)"links");
            List urlTags = XMLUtil.getChildTags((Node)links, (String)"url");
            for (Element actionChild : urlTags) {
                String urlName = XMLUtil.getAttribute((Element)actionChild, (String)"id");
                String urlValue = actionChild.getTextContent();
                if (urlName.equals("downloadTftpBootZip")) {
                    autoDeployConfig.tftpBootZipUrl = autoDeployHost + urlValue;
                    continue;
                }
                autoDeployConfig.logUrl = autoDeployHost + urlValue;
            }
        }
        autoDeployConfig.settings = propertyList.toArray(new KeyValue[propertyList.size()]);
        return autoDeployConfig;
    }
}

