/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.vmware.vim.binding.rbd.Capabilities;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.autodeploy.capability.AutodeployCapability;
import com.vmware.vsphere.client.h5.autodeploy.connection.EndpointLocator;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployWaiterService;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AutoDeployWaiterServiceFactory {
    private static final String AUTODEPLOY_WAITER_SERVICE_MAP = "com.vmware.vsphere.client.h5.autodeploy.connection.impl.AUTODEPLOY_WAITER_SERVICE_MAP";
    private final EndpointLocator _endpointLocator;
    private final AutodeployCapability _autodeployCapability;

    public AutoDeployWaiterServiceFactory(EndpointLocator endpointLocator, AutodeployCapability autodeployCapability) {
        this._endpointLocator = endpointLocator;
        this._autodeployCapability = autodeployCapability;
    }

    public AutoDeployWaiterService getService(String serverGuid) {
        String serviceKey;
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        ConcurrentMap<String, AutoDeployWaiterService> waiterServiceMap = AutoDeployWaiterServiceFactory.getAutoDeployWaiterServiceMap();
        if (waiterServiceMap.containsKey(serviceKey = serverGuid + ":" + vcService.getConnectionInfo().getSessionCookie()) && waiterServiceMap.get(serviceKey) instanceof AutoDeployWaiterService) {
            return (AutoDeployWaiterService)waiterServiceMap.get(serviceKey);
        }
        Capabilities autodeployCapabilitiesMap = this._autodeployCapability.getAutodeployCapabilities(serverGuid);
        URI waiterServiceUri = this._endpointLocator.getEndpoint(vcService);
        AutoDeployWaiterService autoDeployWaiterService = new AutoDeployWaiterService(waiterServiceUri, vcService, autodeployCapabilitiesMap.restApiHardening);
        waiterServiceMap.put(serviceKey, autoDeployWaiterService);
        return autoDeployWaiterService;
    }

    private static ConcurrentMap<String, AutoDeployWaiterService> getAutoDeployWaiterServiceMap() {
        ConcurrentMap serviceMap = (ConcurrentMap)SessionUtil.getData((String)AUTODEPLOY_WAITER_SERVICE_MAP);
        if (serviceMap == null) {
            SessionUtil.setData((String)AUTODEPLOY_WAITER_SERVICE_MAP, new ConcurrentHashMap());
            serviceMap = (ConcurrentMap)SessionUtil.getData((String)AUTODEPLOY_WAITER_SERVICE_MAP);
        }
        return serviceMap;
    }
}

