/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.autodeploy.ImageBuilderService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.CachingVmomiClientFactory;
import com.vmware.vsphere.client.h5.autodeploy.impl.ImageBuilderServiceImpl;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;

public class ImageBuilderServiceFactory {
    private static final String IMAGE_BUILDER_SERVICE_MAP = "com.vmware.vsphere.client.h5.autodeploy.connection.impl.IMAGE_BUILDER_SERVICE_MAP";
    private final CachingVmomiClientFactory _clientFactory;

    public ImageBuilderServiceFactory(CachingVmomiClientFactory clientFactory) {
        this._clientFactory = (CachingVmomiClientFactory)Preconditions.checkNotNull((Object)clientFactory);
    }

    public ImageBuilderService getService(String serverGuid) {
        Preconditions.checkNotNull((Object)serverGuid, (Object)"VC server GUID is null when retrieving ImageBuilder service.");
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        String clientId = SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession());
        return this.getService(vcService, clientId);
    }

    public ImageBuilderService getService(VcService vcService, String clientId) {
        Client vmomiClient = this._clientFactory.getClient(vcService, clientId);
        String serviceKey = vcService.getServiceGuid();
        ConcurrentMap<String, ImageBuilderService> imageBuilderServiceCache = ImageBuilderServiceFactory.getImageBuilderServiceMap();
        ImageBuilderServiceImpl service = null;
        Object serviceObj = imageBuilderServiceCache.get(serviceKey);
        if (serviceObj instanceof ImageBuilderServiceImpl) {
            service = (ImageBuilderServiceImpl)serviceObj;
        }
        if (service == null || service.getClient() != vmomiClient) {
            imageBuilderServiceCache.put(serviceKey, new ImageBuilderServiceImpl(vmomiClient, vcService.getServiceGuid()));
        }
        return (ImageBuilderService)imageBuilderServiceCache.get(serviceKey);
    }

    private static ConcurrentMap<String, ImageBuilderService> getImageBuilderServiceMap() {
        ConcurrentMap serviceMap = (ConcurrentMap)SessionUtil.getData((String)IMAGE_BUILDER_SERVICE_MAP);
        if (serviceMap == null) {
            SessionUtil.setData((String)IMAGE_BUILDER_SERVICE_MAP, new ConcurrentHashMap());
            serviceMap = (ConcurrentMap)SessionUtil.getData((String)IMAGE_BUILDER_SERVICE_MAP);
        }
        return serviceMap;
    }
}

