/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.autodeploy.connection.EndpointLocator;
import java.net.URI;

public class VcExtensionEndpointLocator
implements EndpointLocator {
    private final String _extensionKey;
    private final String _endpointType;

    public VcExtensionEndpointLocator(String extensionKey, String endpointType) {
        this._extensionKey = (String)Preconditions.checkNotNull((Object)extensionKey);
        this._endpointType = (String)Preconditions.checkNotNull((Object)endpointType);
    }

    @Override
    public URI getEndpoint(VcService vcService) {
        Preconditions.checkNotNull((Object)vcService, (Object)String.format("serverGuid is null when retrieving VC Extension with key=%s and type=%s.", this._extensionKey, this._endpointType));
        URI endpoint = null;
        Extension.ServerInfo serverInfo = VcExtensionEndpointLocator.findServerInfo(vcService, this._extensionKey, this._endpointType);
        if (serverInfo != null) {
            endpoint = URI.create(serverInfo.url);
        }
        return endpoint;
    }

    private static Extension.ServerInfo findServerInfo(VcService vcService, String extensionKey, String endpointType) {
        ExtensionManager extensionManager = VcExtensionEndpointLocator.getExtensionManager(vcService);
        Extension extension = extensionManager.findExtension(extensionKey);
        Extension.ServerInfo[] extensionServerInfos = extension.getServer();
        Extension.ServerInfo resultServerInfo = null;
        for (Extension.ServerInfo serverInfo : extensionServerInfos) {
            if (!endpointType.equals(serverInfo.type)) continue;
            resultServerInfo = serverInfo;
            break;
        }
        return resultServerInfo;
    }

    private static ExtensionManager getExtensionManager(VcService vcService) {
        ServiceInstanceContent service = vcService.getServiceInstanceContent();
        ManagedObjectReference extensionManagerRef = service.getExtensionManager();
        ExtensionManager extensionManager = (ExtensionManager)vcService.getManagedObject(extensionManagerRef);
        return extensionManager;
    }
}

