/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.vmodl.versionId;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.VcServiceHelper;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.autodeploy.connection.EndpointLocator;
import com.vmware.vsphere.client.h5.autodeploy.connection.http.HttpClientConfigFactory;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmomiClientFactory {
    private static final Log _logger = LogFactory.getLog(VmomiClientFactory.class);
    private EndpointLocator _endpointLocator;
    private Map<Class<?>, Class<?>> _versionClassMap;
    private Class<?> _defaultVersionClass;
    private Class<?> _olderVcVersionClass;
    private Class<?> _latestUnstableVersionClass;
    private HttpClientConfigFactory _httpClientConfig;
    private final ConfigurationService _configurationService;

    public VmomiClientFactory(EndpointLocator endpointLocator, Map<Class<?>, Class<?>> versionClass, Class<?> defaultVersionClass, Class<?> olderVcVersionClass, Class<?> latestUnstableVersionClass, HttpClientConfigFactory httpClientConfig, ConfigurationService configurationService) {
        this._endpointLocator = (EndpointLocator)Preconditions.checkNotNull((Object)endpointLocator);
        this._versionClassMap = (Map)Preconditions.checkNotNull(versionClass);
        this._defaultVersionClass = (Class)Preconditions.checkNotNull(defaultVersionClass);
        this._olderVcVersionClass = (Class)Preconditions.checkNotNull(olderVcVersionClass);
        this._latestUnstableVersionClass = (Class)Preconditions.checkNotNull(latestUnstableVersionClass);
        this._httpClientConfig = (HttpClientConfigFactory)Preconditions.checkNotNull((Object)httpClientConfig);
        this._configurationService = (ConfigurationService)Preconditions.checkNotNull((Object)configurationService);
    }

    public Client createClient(VcService vcService) {
        Class<?> vmodlVersion;
        boolean useUnstableVersion;
        URI endpoint = this._endpointLocator.getEndpoint(vcService);
        HttpClientConfiguration httpConfig = this._httpClientConfig.getHttpClientConfig(vcService);
        String configuredUseUnstableVmodl = this._configurationService.getProperty("use.unstable.vmodl");
        Boolean useUnstable = BooleanUtils.toBooleanObject((String)configuredUseUnstableVmodl);
        boolean bl = useUnstableVersion = useUnstable != null ? useUnstable : false;
        if (useUnstableVersion) {
            vmodlVersion = this._latestUnstableVersionClass;
            String vmodlVersionId = "UNKNOWN";
            versionId vId = vcService.getVmodlVersion().getAnnotation(versionId.class);
            vmodlVersionId = vId != null ? vId.value() : vmodlVersionId;
            _logger.info((Object)("Using unstable VMODL to connect to VC with VMODL id: " + vmodlVersionId));
        } else {
            vmodlVersion = this._versionClassMap.get(vcService.getVmodlVersion());
        }
        if (vmodlVersion == null) {
            VcServiceHelper vcServiceHelper = VcServiceHelper.getInstance();
            vmodlVersion = !vcServiceHelper.is80VcOrLaterByServerGuid(vcService.getServiceGuid(), true) ? this._olderVcVersionClass : this._defaultVersionClass;
            _logger.warn((Object)String.format("Could not determine VMODL so falling back to '%s'.", vmodlVersion));
        }
        try {
            _logger.info((Object)String.format("Attempting to use VMODL '%s' for talking to '%s'.", vmodlVersion.getName(), endpoint.toString()));
            return Client.Factory.createClient((URI)endpoint, vmodlVersion, (ClientConfiguration)httpConfig);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Falling back to VMODL '%s'.", vmodlVersion.getName()), (Throwable)e);
            return Client.Factory.createClient((URI)endpoint, this._olderVcVersionClass, (ClientConfiguration)httpConfig);
        }
    }
}

