/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.collect.Sets;
import com.vmware.vim.binding.imagebuilder.DepotManager;
import com.vmware.vim.binding.imagebuilder.DepotSpec;
import com.vmware.vim.binding.imagebuilder.fault.DatabaseError;
import com.vmware.vim.binding.imagebuilder.fault.NotFound;
import com.vmware.vim.binding.imagebuilder.pkg.VibPackageSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.autodeploy.ImageBuilderService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.ImageBuilderServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.depot.DepotType;
import com.vmware.vsphere.client.h5.autodeploy.impl.AdDataProviderAdapterBase;
import com.vmware.vsphere.client.h5.autodeploy.impl.DerivedProperty;
import com.vmware.vsphere.client.h5.autodeploy.impl.RelatedProperty;
import com.vmware.vsphere.client.h5.autodeploy.impl.VibPackageDataProviderAdapter;
import com.vmware.vsphere.client.h5.autodeploy.util.CommonReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.DepotReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.VibPackageReferenceUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="imagebuilder:Depot")
public class DepotDataProviderAdapter
extends AdDataProviderAdapterBase {
    public static final String DEPOT_URL_PROP = "url";
    public static final String DEPOT_TYPE_PROP = "depotType";
    public static final String DEPOT_NAME_PROP = "name";
    public static final String DEPOT_STATUS_PROP = "status";
    public static final String DEPOT_LAST_UPDATED_PROP = "lastUpdated";
    public static final String DEPOT_VIBS_PROP = "vibs";
    public static final String DEPOT_VC_REF_PROP = "vcRef";
    public static final String DEPOT_ICON_ID_PROP = "iconId";
    private static final DepotInfo[] EMPTY_RESULT = new DepotInfo[0];
    private static final Log _logger = LogFactory.getLog(DepotDataProviderAdapter.class);
    private final ImageBuilderServiceFactory _imageBuilderServiceFactory;
    private final ObjectReferenceService _objectReferenceService;

    public DepotDataProviderAdapter(QueryExecutor queryExecutor, ImageBuilderServiceFactory imageBuilderServiceFactory, ObjectReferenceService objectReferenceService) {
        super(queryExecutor);
        this._imageBuilderServiceFactory = imageBuilderServiceFactory;
        this._objectReferenceService = objectReferenceService;
    }

    @Override
    protected Set<String> initBaseProperties() {
        return Sets.newHashSet((Object[])new String[]{DEPOT_URL_PROP, DEPOT_TYPE_PROP, DEPOT_NAME_PROP, DEPOT_STATUS_PROP, DEPOT_LAST_UPDATED_PROP, DEPOT_VIBS_PROP, DEPOT_VC_REF_PROP});
    }

    @Override
    protected Map<String, DerivedProperty> initDerivedProperties() {
        HashMap<String, DerivedProperty> result = new HashMap<String, DerivedProperty>();
        result.put(DEPOT_ICON_ID_PROP, new DerivedProperty<DepotInfo>(){

            @Override
            protected Object getValue(DepotInfo depotInfo, DerivedProperty.BasePropertyHolder holder) {
                String depotType = (String)holder.getInput(DepotDataProviderAdapter.DEPOT_TYPE_PROP);
                if (DepotType.ONLINE.toString().equals(depotType)) {
                    DepotSpec.State depotState = (DepotSpec.State)holder.getInput(DepotDataProviderAdapter.DEPOT_STATUS_PROP);
                    if (depotState == DepotSpec.State.Error) {
                        return "onlineDisconnected";
                    }
                    return "onlineConnected";
                }
                if (DepotType.USER.toString().equals(depotType)) {
                    return "user";
                }
                if (DepotType.ZIP.toString().equals(depotType)) {
                    return "offline";
                }
                _logger.error((Object)("Unexpected depot type: " + depotType));
                return null;
            }

            @Override
            public String[] getInputPropertyNames() {
                return new String[]{DepotDataProviderAdapter.DEPOT_STATUS_PROP, DepotDataProviderAdapter.DEPOT_TYPE_PROP};
            }
        });
        return result;
    }

    @Override
    protected Map<String, RelatedProperty> initRelatedProperties() {
        HashMap<String, RelatedProperty> result = new HashMap<String, RelatedProperty>();
        result.put("grantedPrivileges", new RelatedProperty("grantedPrivileges", DEPOT_VC_REF_PROP));
        return result;
    }

    protected DepotInfo[] getEmptyResult() {
        return EMPTY_RESULT;
    }

    @Override
    protected Object[] filterObjects(RelationalConstraint c, Map<String, Object> requestContext) {
        if ("imageBuilderDepots".equals(c.relation)) {
            if (c.constraintOnRelatedObject instanceof ObjectIdentityConstraint) {
                ObjectIdentityConstraint oic = (ObjectIdentityConstraint)c.constraintOnRelatedObject;
                ManagedObjectReference target = (ManagedObjectReference)oic.target;
                DepotSpec[] depotSpecs = this.getDepots(target.getServerGuid());
                int numberOfDepots = depotSpecs == null ? 0 : depotSpecs.length;
                Object[] result = new DepotInfo[numberOfDepots];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = new DepotInfo(target.getServerGuid(), depotSpecs[i]);
                }
                return result;
            }
        } else if ("userCreatedImageBuilderDepots".equals(c.relation) && c.constraintOnRelatedObject instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)c.constraintOnRelatedObject;
            ManagedObjectReference target = (ManagedObjectReference)oic.target;
            DepotSpec[] depotSpecs = this.getDepots(target.getServerGuid());
            ArrayList<DepotInfo> result = new ArrayList<DepotInfo>();
            for (int i = 0; i < depotSpecs.length; ++i) {
                if (depotSpecs[i].type != DepotSpec.Type.User) continue;
                result.add(new DepotInfo(target.getServerGuid(), depotSpecs[i]));
            }
            return result.toArray(EMPTY_RESULT);
        }
        return EMPTY_RESULT;
    }

    @Override
    protected Object[] filterObjects(ObjectIdentityConstraint c, Map<String, Object> requestContext) {
        DepotSpec[] depotSpecs;
        if (!CommonReferenceUtil.isReferenceOfType(c.target, "imagebuilder:Depot", this._objectReferenceService)) {
            return EMPTY_RESULT;
        }
        URI targetUri = (URI)c.target;
        String vcGuid = DepotReferenceUtil.getVcGuid(targetUri);
        String depotUrl = DepotReferenceUtil.getDepotUrl(targetUri);
        ImageBuilderService ib = this._imageBuilderServiceFactory.getService(vcGuid);
        DepotManager dm = ib.getDepotManager();
        DepotManager.DepotFilterSpec filter = new DepotManager.DepotFilterSpec(depotUrl);
        try {
            depotSpecs = dm.GetDepots(filter);
        }
        catch (DatabaseError e) {
            depotSpecs = null;
        }
        assert (depotSpecs == null || depotSpecs.length == 1);
        if (depotSpecs == null) {
            return EMPTY_RESULT;
        }
        return new DepotInfo[]{new DepotInfo(vcGuid, depotSpecs[0])};
    }

    @Override
    protected Map<String, Object[]> retrieveBaseProperties(Set<String> propertyNames, Object[] sourceObjectRefs, Map<String, Object> requestContext) {
        assert (sourceObjectRefs instanceof DepotInfo[]);
        DepotInfo[] depotInfos = (DepotInfo[])sourceObjectRefs;
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        for (String pn : propertyNames) {
            int i;
            Object[] valuesPerProperty = new Object[depotInfos.length];
            if (DEPOT_URL_PROP.equals(pn)) {
                for (i = 0; i < depotInfos.length; ++i) {
                    valuesPerProperty[i] = depotInfos[i].spec.depotIndexUrl;
                }
            } else if (DEPOT_TYPE_PROP.equals(pn)) {
                for (i = 0; i < depotInfos.length; ++i) {
                    valuesPerProperty[i] = DepotDataProviderAdapter.translateDepotType(depotInfos[i].spec.type).toString();
                }
            } else if (DEPOT_NAME_PROP.equals(pn)) {
                for (i = 0; i < depotInfos.length; ++i) {
                    valuesPerProperty[i] = depotInfos[i].spec.name;
                }
            } else if (DEPOT_STATUS_PROP.equals(pn)) {
                for (i = 0; i < depotInfos.length; ++i) {
                    valuesPerProperty[i] = depotInfos[i].spec.status;
                }
            } else if (DEPOT_LAST_UPDATED_PROP.equals(pn)) {
                for (i = 0; i < depotInfos.length; ++i) {
                    valuesPerProperty[i] = depotInfos[i].spec.lastConnected;
                }
            } else if (DEPOT_VIBS_PROP.equals(pn)) {
                for (i = 0; i < depotInfos.length; ++i) {
                    valuesPerProperty[i] = this.getDepotVibs(depotInfos[i].vcGuid, depotInfos[i].spec);
                }
            } else if (DEPOT_VC_REF_PROP.equals(pn)) {
                for (i = 0; i < depotInfos.length; ++i) {
                    valuesPerProperty[i] = ManagedObjectUtil.getRootFolder((String)depotInfos[i].vcGuid);
                }
            }
            result.put(pn, valuesPerProperty);
        }
        return result;
    }

    @Override
    protected Object sourceObjectToReference(Object sourceObject) {
        assert (sourceObject instanceof DepotInfo);
        DepotInfo di = (DepotInfo)sourceObject;
        return DepotReferenceUtil.createRef(di.vcGuid, di.spec.depotIndexUrl);
    }

    private DepotSpec[] getDepots(String vcGuid) {
        try {
            ImageBuilderService ib = this._imageBuilderServiceFactory.getService(vcGuid);
            DepotManager dm = ib.getDepotManager();
            return dm.GetDepots(null);
        }
        catch (DatabaseError e) {
            throw new RuntimeException(e);
        }
    }

    private URI[] getDepotVibs(String vcGuid, DepotSpec depotSpec) {
        VibPackageSpec[] rawVibs;
        assert (depotSpec != null);
        _logger.debug((Object)("Retrieving VIB packages in depot: " + depotSpec.depotIndexUrl));
        long start = System.currentTimeMillis();
        DepotManager dm = this._imageBuilderServiceFactory.getService(vcGuid).getDepotManager();
        DepotManager.VibPackageFilterSpec filterSpec = VibPackageDataProviderAdapter.createEmptyVibPackageFilterSpec();
        filterSpec.matchDepotUrl = new String[]{depotSpec.depotIndexUrl};
        try {
            rawVibs = dm.queryPackages(filterSpec);
        }
        catch (NotFound e) {
            throw new RuntimeException("Error while querying packages", e);
        }
        URI[] result = rawVibs == null ? new URI[]{} : new URI[rawVibs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = VibPackageReferenceUtil.createRef(vcGuid, rawVibs[i].Guid);
        }
        long time = System.currentTimeMillis() - start;
        _logger.debug((Object)("Retrieving VIB packages for depot: " + depotSpec.depotIndexUrl + " took " + time + "ms"));
        return result;
    }

    private static DepotType translateDepotType(DepotSpec.Type type2) {
        if (type2 == DepotSpec.Type.Offline) {
            return DepotType.ZIP;
        }
        if (type2 == DepotSpec.Type.Online) {
            return DepotType.ONLINE;
        }
        if (type2 == DepotSpec.Type.User) {
            return DepotType.USER;
        }
        throw new IllegalStateException("Depot type of unexpected value: " + type2);
    }

    private static class DepotInfo {
        final String vcGuid;
        final DepotSpec spec;

        DepotInfo(String vg, DepotSpec s) {
            this.vcGuid = vg;
            this.spec = s;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DepotInfo o = (DepotInfo)other;
            return this.vcGuid.equals(o.vcGuid) && this.spec.depotIndexUrl.equals(o.spec.depotIndexUrl);
        }

        public int hashCode() {
            return 17 * this.vcGuid.hashCode() + 31 * this.spec.depotIndexUrl.hashCode();
        }
    }
}

