/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import java.util.Map;

public abstract class DerivedProperty<T> {
    public abstract String[] getInputPropertyNames();

    protected abstract Object getValue(T var1, BasePropertyHolder var2);

    public Object[] getValues(T[] sourceObjects, Map<String, Object[]> basePropertyValues) {
        assert (this.containsRequiredProperties(basePropertyValues));
        BasePropertyHolder holder = new BasePropertyHolder(basePropertyValues);
        Object[] result = new Object[sourceObjects.length];
        for (int i = 0; i < sourceObjects.length; ++i) {
            holder.index = i;
            result[i] = this.getValue(sourceObjects[i], holder);
        }
        return result;
    }

    private boolean containsRequiredProperties(Map<String, Object[]> in) {
        for (String pn : this.getInputPropertyNames()) {
            if (in.containsKey(pn)) continue;
            return false;
        }
        return true;
    }

    protected static class BasePropertyHolder {
        private int index;
        private final Map<String, Object[]> _table;

        private BasePropertyHolder(Map<String, Object[]> table) {
            this._table = table;
        }

        protected final <C> C getInput(String propertyName) {
            assert (this._table.containsKey(propertyName));
            return (C)this._table.get(propertyName)[this.index];
        }
    }
}

