/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.vmware.vim.binding.imagebuilder.DepotManager;
import com.vmware.vim.binding.imagebuilder.ImageProfileCompareResult;
import com.vmware.vim.binding.imagebuilder.ImageProfileEngine;
import com.vmware.vim.binding.imagebuilder.pkg.ImageProfile;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.h5.autodeploy.ImageBuilderService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.ImageBuilderServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.CompareImageProfileSpec;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.ImageProfileComparisonResult;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.ImageProfileComparisonResultElement;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.ImageProfileComparisonResultElementType;
import com.vmware.vsphere.client.h5.autodeploy.util.AutoDeployUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.CommonReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.ImageProfileReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.VibPackageReferenceUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageProfilePropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(ImageProfilePropertyProvider.class);
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;
    private ImageBuilderServiceFactory _imageBuilderServiceFactory;
    private ObjectReferenceService _objectReferenceService;

    public ImageProfilePropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, ImageBuilderServiceFactory imageBuilderServiceFactory, ObjectReferenceService objectReferenceService) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._imageBuilderServiceFactory = imageBuilderServiceFactory;
        this._objectReferenceService = objectReferenceService;
    }

    @type(value="imagebuilder:ImageProfile")
    public ImageProfileComparisonResult getComparisonResult(URI referenceImageProfileRef, CompareImageProfileSpec compareImageProfileSpec) throws MethodFault {
        if (compareImageProfileSpec == null) {
            throw new IllegalArgumentException(ImageProfilePropertyProvider.getLocalizedMessage("imageProfile.compare.nullSpecError", new String[0]));
        }
        URI comparedImageProfileRef = compareImageProfileSpec.comparedImageProfileRef;
        String[] resultVibPackagesPropertyNames = compareImageProfileSpec.resultVibPackagesPropertyNames;
        if (!this.isImageProfileRef(referenceImageProfileRef)) {
            throw new IllegalArgumentException(ImageProfilePropertyProvider.getLocalizedMessage("imageProfile.compare.invalidReferenceImageProfileError", new String[0]));
        }
        if (!this.isImageProfileRef(comparedImageProfileRef)) {
            throw new IllegalArgumentException(ImageProfilePropertyProvider.getLocalizedMessage("imageProfile.compare.invalidComparedImageProfileError", new String[0]));
        }
        if (resultVibPackagesPropertyNames == null) {
            throw new IllegalArgumentException(ImageProfilePropertyProvider.getLocalizedMessage("imageProfile.compare.invalidVibPackagePropertyNamesError", new String[0]));
        }
        if (!ImageProfilePropertyProvider.areImageProfilesOnSameVc(referenceImageProfileRef, comparedImageProfileRef)) {
            throw new MethodFault(ImageProfilePropertyProvider.getLocalizedMessage("imageProfile.compare.imageProfilesNotOnSameVcError", new String[0]));
        }
        ImageProfile[] profilePair = this.getImageProfilePair(referenceImageProfileRef, comparedImageProfileRef);
        String vcGuid = ImageProfileReferenceUtil.getVcGuid(referenceImageProfileRef);
        ImageBuilderService imageBuilderService = this._imageBuilderServiceFactory.getService(vcGuid);
        ImageProfileEngine imageProfileEngine = imageBuilderService.getImageProfileEngine();
        ImageProfileCompareResult rawComparisonResult = imageProfileEngine.diffProfile(profilePair[0], profilePair[1]);
        Map<String, Map<String, Object>> referenceImageProfileVibPackageMap = this.getImageProfileVibPackageMap(referenceImageProfileRef, resultVibPackagesPropertyNames);
        Map<String, Map<String, Object>> comparedImageProfileVibPackageMap = this.getImageProfileVibPackageMap(comparedImageProfileRef, resultVibPackagesPropertyNames);
        ImageProfileComparisonResult transformedComparisonResult = this.transformRawComparisonResult(rawComparisonResult, referenceImageProfileVibPackageMap, comparedImageProfileVibPackageMap);
        return transformedComparisonResult;
    }

    private ImageProfileComparisonResult transformRawComparisonResult(ImageProfileCompareResult rawComparisonResult, Map<String, Map<String, Object>> referenceImageProfileVibPackageMap, Map<String, Map<String, Object>> comparedImageProfileVibPackageMap) {
        ImageProfileComparisonResult result = new ImageProfileComparisonResult();
        result.referenceImageProfileName = rawComparisonResult.refProfile.name;
        result.comparedImageProfileName = rawComparisonResult.compProfile.name;
        ArrayList<ImageProfileComparisonResultElement> elements = new ArrayList<ImageProfileComparisonResultElement>();
        for (ImageProfileCompareResult.CompareResultElement rawElement : rawComparisonResult.compareResult) {
            List<ImageProfileComparisonResultElement> transformedElements = this.transformRawComparisonResultElement(rawElement, referenceImageProfileVibPackageMap, comparedImageProfileVibPackageMap);
            elements.addAll(transformedElements);
        }
        result.elements = elements.toArray(new ImageProfileComparisonResultElement[0]);
        return result;
    }

    private List<ImageProfileComparisonResultElement> transformRawComparisonResultElement(ImageProfileCompareResult.CompareResultElement rawElement, Map<String, Map<String, Object>> referenceImageProfileVibPackageMap, Map<String, Map<String, Object>> comparedImageProfileVibPackageMap) {
        ArrayList<ImageProfileComparisonResultElement> result;
        block3: {
            block6: {
                block5: {
                    block4: {
                        block2: {
                            result = new ArrayList<ImageProfileComparisonResultElement>();
                            if (!(rawElement instanceof ImageProfileCompareResult.Identical)) break block2;
                            ImageProfileCompareResult.Identical identicalRawElement = (ImageProfileCompareResult.Identical)rawElement;
                            ImageProfileComparisonResultElement element = new ImageProfileComparisonResultElement();
                            element.type = ImageProfileComparisonResultElementType.IDENTICAL;
                            element.referenceVibPackage = referenceImageProfileVibPackageMap.get(identicalRawElement.packageId);
                            element.comparedVibPackage = comparedImageProfileVibPackageMap.get(identicalRawElement.packageId);
                            result.add(element);
                            break block3;
                        }
                        if (!(rawElement instanceof ImageProfileCompareResult.OnlyInRef)) break block4;
                        ImageProfileCompareResult.OnlyInRef removedRawElement = (ImageProfileCompareResult.OnlyInRef)rawElement;
                        ImageProfileComparisonResultElement element = new ImageProfileComparisonResultElement();
                        element.type = ImageProfileComparisonResultElementType.REMOVED;
                        element.referenceVibPackage = referenceImageProfileVibPackageMap.get(removedRawElement.packageId);
                        result.add(element);
                        break block3;
                    }
                    if (!(rawElement instanceof ImageProfileCompareResult.OnlyInComp)) break block5;
                    ImageProfileCompareResult.OnlyInComp addedRawElement = (ImageProfileCompareResult.OnlyInComp)rawElement;
                    ImageProfileComparisonResultElement element = new ImageProfileComparisonResultElement();
                    element.type = ImageProfileComparisonResultElementType.ADDED;
                    element.comparedVibPackage = comparedImageProfileVibPackageMap.get(addedRawElement.packageId);
                    result.add(element);
                    break block3;
                }
                if (!(rawElement instanceof ImageProfileCompareResult.DowngradeFromRef)) break block6;
                ImageProfileCompareResult.DowngradeFromRef downgradedRawElement = (ImageProfileCompareResult.DowngradeFromRef)rawElement;
                for (String referenceVibPackageGuid : downgradedRawElement.refPackageIds) {
                    ImageProfileComparisonResultElement element = new ImageProfileComparisonResultElement();
                    element.type = ImageProfileComparisonResultElementType.DOWNGRADED;
                    element.referenceVibPackage = referenceImageProfileVibPackageMap.get(referenceVibPackageGuid);
                    element.comparedVibPackage = comparedImageProfileVibPackageMap.get(downgradedRawElement.compPackageId);
                    result.add(element);
                }
                break block3;
            }
            if (!(rawElement instanceof ImageProfileCompareResult.UpgradeFromRef)) break block3;
            ImageProfileCompareResult.UpgradeFromRef upgradedRawElement = (ImageProfileCompareResult.UpgradeFromRef)rawElement;
            for (String referenceVibPackageGuid : upgradedRawElement.refPackageIds) {
                ImageProfileComparisonResultElement element = new ImageProfileComparisonResultElement();
                element.type = ImageProfileComparisonResultElementType.UPGRADED;
                element.referenceVibPackage = referenceImageProfileVibPackageMap.get(referenceVibPackageGuid);
                element.comparedVibPackage = comparedImageProfileVibPackageMap.get(upgradedRawElement.compPackageId);
                result.add(element);
            }
        }
        return result;
    }

    private ImageProfile[] getImageProfilePair(URI source, URI target) throws MethodFault {
        ImageBuilderService imageBuilderService = this._imageBuilderServiceFactory.getService(ImageProfileReferenceUtil.getVcGuid(source));
        DepotManager dm = imageBuilderService.getDepotManager();
        DepotManager.ImageProfileFilterSpec filterSpec = AutoDeployUtil.createEmptyImageProfileFilterSpec();
        filterSpec.matchGuid = new String[]{ImageProfileReferenceUtil.getImageProfileId(source), ImageProfileReferenceUtil.getImageProfileId(target)};
        Object[] queryResult = dm.queryProfiles(filterSpec, Boolean.valueOf(false));
        if (queryResult.length != 2) {
            _logger.warn((Object)("Identity constraint for two image profiles returned result: " + Arrays.toString(queryResult)));
            throw new MethodFault(ImageProfilePropertyProvider.getLocalizedMessage("imageProfile.compare.imageProfileRetrievalError", source.toString(), target.toString()));
        }
        if (ImageProfileReferenceUtil.getImageProfileId(source).equals(queryResult[0].profileId)) {
            return queryResult;
        }
        return new ImageProfile[]{queryResult[1], queryResult[0]};
    }

    private Map<String, Map<String, Object>> getImageProfileVibPackageMap(URI imageProfileRef, String[] vibPackagesPropertyNames) throws MethodFault {
        Constraint constraint = this._querySpecBuilder.createConstraintForRelationship((Object)imageProfileRef, "vibPackages", "imagebuilder:VibPackage");
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = vibPackagesPropertyNames;
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        ResultSet resultSet = null;
        try {
            resultSet = this._queryExecutor.getData(querySpec);
        }
        catch (Exception e) {
            _logger.error((Object)("Error retrieving vibPackages for ImageProfile: " + imageProfileRef), (Throwable)e);
            throw new MethodFault(ImageProfilePropertyProvider.getLocalizedMessage("imageProfile.compare.imageProfileVibPackagesRetrievalError", imageProfileRef.toString()));
        }
        if (resultSet == null) {
            _logger.error((Object)("Null ResultSet when retrieving vibPackages for ImageProfile: " + imageProfileRef));
            throw new MethodFault(ImageProfilePropertyProvider.getLocalizedMessage("imageProfile.compare.imageProfileVibPackagesRetrievalError", imageProfileRef.toString()));
        }
        if (resultSet.error != null) {
            _logger.error((Object)("ResultSet error when retrieving vibPackages for ImageProfile: " + imageProfileRef), (Throwable)resultSet.error);
            throw new MethodFault(ImageProfilePropertyProvider.getLocalizedMessage("imageProfile.compare.imageProfileVibPackagesRetrievalError", imageProfileRef.toString()));
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        if (ArrayUtils.isEmpty((Object[])resultSet.items)) {
            return result;
        }
        for (ResultItem resultItem : resultSet.items) {
            URI imageProfileVibPackageRef = (URI)resultItem.resourceObject;
            String imageProfileVibPackageGuid = VibPackageReferenceUtil.getVibPackageGuid(imageProfileVibPackageRef);
            result.put(imageProfileVibPackageGuid, this.resultItemToPropertyMap(resultItem));
        }
        return result;
    }

    private Map<String, Object> resultItemToPropertyMap(ResultItem resultItem) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        for (PropertyValue propertyValue : resultItem.properties) {
            propertyMap.put(propertyValue.propertyName, propertyValue.value);
        }
        return propertyMap;
    }

    private boolean isImageProfileRef(Object object) {
        return CommonReferenceUtil.isReferenceOfType(object, "imagebuilder:ImageProfile", this._objectReferenceService);
    }

    private static boolean areImageProfilesOnSameVc(URI ... imageProfileRefs) {
        if (imageProfileRefs == null || imageProfileRefs.length == 0) {
            return true;
        }
        String vcGuid = ImageProfileReferenceUtil.getVcGuid(imageProfileRefs[0]);
        for (int i = 1; i < imageProfileRefs.length; ++i) {
            if (vcGuid.equals(ImageProfileReferenceUtil.getVcGuid(imageProfileRefs[i]))) continue;
            return false;
        }
        return true;
    }

    private static String getLocalizedMessage(String key, String ... parameters) {
        return ResourceUtil.getString((String)"autodeployservice", (String)key, (String[])parameters, (ClassLoader)ImageProfilePropertyProvider.class.getClassLoader());
    }
}

