/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.vmware.vim.binding.rbd.ProxyServerList;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.proxyServer.AddProxyServerSpec;
import com.vmware.vsphere.client.h5.autodeploy.proxyServer.RemoveProxyServerSpec;

public class ProxyServerMutationProvider
implements MutationProvider {
    private AutoDeployServiceFactory _autoDeployServiceFactory;

    public ProxyServerMutationProvider(AutoDeployServiceFactory autoDeployServiceFactory) {
        this._autoDeployServiceFactory = autoDeployServiceFactory;
    }

    public OperationResult add(AddProxyServerSpec addProxyServersSpec) {
        OperationResult operationResult = new OperationResult();
        if (addProxyServersSpec.serverGuid == null || addProxyServersSpec.address == null) {
            return operationResult;
        }
        try {
            ProxyServerList proxyServerList = this.getProxyServerList(addProxyServersSpec.serverGuid);
            proxyServerList.addProxyServer(addProxyServersSpec.address);
            operationResult.entity = ManagedObjectUtil.getRootFolder((String)addProxyServersSpec.serverGuid);
        }
        catch (Exception e) {
            operationResult.error = e;
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference vcFolderRef, RemoveProxyServerSpec removeProxyServerSpec) {
        OperationResult operationResult = new OperationResult();
        if (vcFolderRef == null || removeProxyServerSpec == null || removeProxyServerSpec.address == null) {
            return operationResult;
        }
        try {
            ProxyServerList proxyServerList = this.getProxyServerList(vcFolderRef.getServerGuid());
            proxyServerList.deleteProxyServerByAddress(removeProxyServerSpec.address);
            operationResult.entity = vcFolderRef;
        }
        catch (Exception e) {
            operationResult.error = e;
        }
        return operationResult;
    }

    private ProxyServerList getProxyServerList(String serverGuid) {
        AutoDeployService autoDeployService = this._autoDeployServiceFactory.getService(serverGuid);
        ManagedObjectReference proxyServerListRef = autoDeployService.getServiceContent().getProxyServerList();
        return (ProxyServerList)autoDeployService.getManagedObject(proxyServerListRef);
    }
}

