/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.collect.Sets;
import com.vmware.vim.binding.rbd.RuleData;
import com.vmware.vim.binding.rbd.RuleSet;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.impl.AdDataProviderAdapterBase;
import com.vmware.vsphere.client.h5.autodeploy.impl.DerivedProperty;
import com.vmware.vsphere.client.h5.autodeploy.impl.RelatedProperty;
import com.vmware.vsphere.client.h5.autodeploy.impl.RuleProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="rbd1:Rule")
public class RuleDataProviderAdapter
extends AdDataProviderAdapterBase {
    public static final String RULE_TYPE = "rbd1:Rule";
    private static final ManagedObjectReference[] EMPTY_RESULT = new ManagedObjectReference[0];
    private static final String RULE_MANAGER_RULE_DATA_KEY = "RuleManager.RuleData";
    private static final String RULE_MANAGER_ACTIVE_RULESET_KEY = "RuleManager.ActiveRuleSet";
    private static final Log _logger = LogFactory.getLog(RuleDataProviderAdapter.class);
    private final AutoDeployServiceFactory _autoDeployServiceFactory;
    private final QueryExecutor _queryExecutor;
    private final ObjectReferenceService _objectReferenceService;
    private final Map<String, String> _knownSupportedAttributes;

    public RuleDataProviderAdapter(AutoDeployServiceFactory adServiceFactory, QueryExecutor queryExecutor, ObjectReferenceService objectReferenceService, Map<String, String> knownSupportedAttributes, ThreadPoolExecutor threadPoolExecutor) {
        super(queryExecutor, threadPoolExecutor);
        this._autoDeployServiceFactory = adServiceFactory;
        this._queryExecutor = queryExecutor;
        this._objectReferenceService = objectReferenceService;
        this._knownSupportedAttributes = knownSupportedAttributes;
    }

    @Override
    protected Set<String> initBaseProperties() {
        return Sets.newHashSet((Object[])new String[]{"name", "ruleSpec", "isLocationLcmCluster", "ruleSet", "grantedPrivileges"});
    }

    @Override
    protected Map<String, DerivedProperty> initDerivedProperties() {
        HashMap<String, DerivedProperty> result = new HashMap<String, DerivedProperty>();
        result.put("hostProfile", new RuleProperties.HostProfile());
        result.put("imageProfile", new RuleProperties.ImageProfile());
        result.put("location", new RuleProperties.Location());
        result.put("scriptBundle", new RuleProperties.ScriptBundle());
        result.put("patternList", new RuleProperties.PatternList());
        result.put("patternInfoList", new RuleProperties.PatternInfoList(this._knownSupportedAttributes));
        result.put("activeOrder", new RuleProperties.ActiveOrder());
        result.put("isActive", new RuleProperties.IsActive());
        return result;
    }

    @Override
    protected Map<String, RelatedProperty> initRelatedProperties() {
        HashMap<String, RelatedProperty> result = new HashMap<String, RelatedProperty>();
        result.put("imageProfileName", RuleProperties.RULE_IMAGE_PROFILE_NAME_DESCRIPTOR);
        result.put("hostProfileName", RuleProperties.RULE_HOST_PROFILE_NAME_DESCRIPTOR);
        result.put("locationName", RuleProperties.RULE_LOCATION_NAME_DESCRIPTOR);
        result.put("isLocationConfigManagerCluster", RuleProperties.IS_CONFIG_MANAGER_CLUSTER_DESCRIPTOR);
        result.put("scriptBundleName", RuleProperties.RULE_SCRIPT_BUNDLE_NAME_DESCRIPTOR);
        return result;
    }

    protected ManagedObjectReference[] getEmptyResult() {
        return EMPTY_RESULT;
    }

    @Override
    protected Object[] filterObjects(RelationalConstraint c, final Map<String, Object> requestContext) {
        if (!RuleDataProviderAdapter.shouldHandleConstraintForType((Constraint)c)) {
            return EMPTY_RESULT;
        }
        if ("autoDeployRules".equals(c.relation) && c.constraintOnRelatedObject instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)c.constraintOnRelatedObject;
            ManagedObjectReference target = (ManagedObjectReference)oic.target;
            final AutoDeployService autoDeploy = this._autoDeployServiceFactory.getService(target.getServerGuid());
            ArrayList<Callable<Void>> apiRequests = new ArrayList<Callable<Void>>();
            apiRequests.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        RuleSet activeRuleSet = (RuleSet)autoDeploy.getManagedObject(autoDeploy.getRuleManager().getLiveRuleSetList()[0]);
                        requestContext.put(RuleDataProviderAdapter.RULE_MANAGER_ACTIVE_RULESET_KEY, activeRuleSet);
                    }
                    catch (Exception ex) {
                        _logger.error((Object)"Failed to retrieve active ruleSet", (Throwable)ex);
                    }
                    return null;
                }
            });
            apiRequests.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        RuleData[] ruleDataItems = autoDeploy.getRuleManager().retrieveRuleObjects();
                        if (ruleDataItems == null) {
                            requestContext.put(RuleDataProviderAdapter.RULE_MANAGER_RULE_DATA_KEY, new RuleData[0]);
                        } else {
                            requestContext.put(RuleDataProviderAdapter.RULE_MANAGER_RULE_DATA_KEY, ruleDataItems);
                        }
                    }
                    catch (Exception ex) {
                        _logger.error((Object)"Failed to retrieve ruleData", (Throwable)ex);
                    }
                    return null;
                }
            });
            try {
                this._threadPoolExecutor.invokeAll(apiRequests);
            }
            catch (Exception ex) {
                _logger.error((Object)"Failed to retrieve properties in parallel.", (Throwable)ex);
                return EMPTY_RESULT;
            }
            RuleData[] ruleDataItems = (RuleData[])requestContext.get(RULE_MANAGER_RULE_DATA_KEY);
            if (ruleDataItems == null) {
                return EMPTY_RESULT;
            }
            Object[] rules = new ManagedObjectReference[ruleDataItems.length];
            for (int i = 0; i < rules.length; ++i) {
                rules[i] = ruleDataItems[i].rule;
            }
            return rules;
        }
        return EMPTY_RESULT;
    }

    @Override
    protected Object[] filterObjects(ObjectIdentityConstraint c, Map<String, Object> requestContext) {
        if (!RuleDataProviderAdapter.shouldHandleConstraintForType((Constraint)c)) {
            return EMPTY_RESULT;
        }
        ManagedObjectReference target = (ManagedObjectReference)c.target;
        if (RULE_TYPE.equalsIgnoreCase(this._objectReferenceService.getResourceObjectType((Object)target))) {
            return new ManagedObjectReference[]{target};
        }
        return EMPTY_RESULT;
    }

    @Override
    protected Map<String, Object[]> retrieveBaseProperties(Set<String> basePropertyNames, Object[] sourceObjectRefs, Map<String, Object> requestContext) {
        assert (sourceObjectRefs instanceof ManagedObjectReference[]);
        ManagedObjectReference[] sourceObjects = (ManagedObjectReference[])sourceObjectRefs;
        String serverGuid = sourceObjects[0].getServerGuid();
        AutoDeployService autoDeploy = this._autoDeployServiceFactory.getService(serverGuid);
        HashMap<String, Object[]> valuesByProperty = new HashMap<String, Object[]>();
        Map<Object, Object> ruleDataIndexByRule = Collections.emptyMap();
        boolean isRuleDataPropertyRequested = RuleDataProviderAdapter.isRuleDataPropertyRequested(basePropertyNames);
        if (isRuleDataPropertyRequested) {
            RuleData[] ruleDataItems = requestContext.containsKey(RULE_MANAGER_RULE_DATA_KEY) ? (RuleData[])requestContext.get(RULE_MANAGER_RULE_DATA_KEY) : autoDeploy.getRuleManager().retrieveRuleObjects();
            ruleDataIndexByRule = RuleDataProviderAdapter.groupDataItemsByRule(ruleDataItems);
        }
        for (String basePropertyName : basePropertyNames) {
            Object[] values = new Object[sourceObjects.length];
            if ("grantedPrivileges".equals(basePropertyName)) {
                try {
                    Object grantedPrivileges = this._queryExecutor.getProperty((Object)ManagedObjectUtil.getRootFolder((String)serverGuid), "grantedPrivileges");
                    for (int j = 0; j < sourceObjects.length; ++j) {
                        values[j] = grantedPrivileges;
                    }
                }
                catch (Exception e) {
                    _logger.error((Object)"Could not retrieve privileges for VC root folder", (Throwable)e);
                }
            } else if ("ruleSet".equals(basePropertyName)) {
                RuleSet activeRuleSet = requestContext.containsKey(RULE_MANAGER_ACTIVE_RULESET_KEY) ? (RuleSet)requestContext.get(RULE_MANAGER_ACTIVE_RULESET_KEY) : (RuleSet)autoDeploy.getManagedObject(autoDeploy.getRuleManager().getLiveRuleSetList()[0]);
                RuleSet.RuleSetSpec spec = activeRuleSet.getSpec();
                for (int j = 0; j < sourceObjects.length; ++j) {
                    values[j] = spec;
                }
            } else if ("name".equals(basePropertyName)) {
                for (int j = 0; j < sourceObjects.length; ++j) {
                    values[j] = ((RuleData)ruleDataIndexByRule.get((Object)sourceObjects[j])).getMetadataObject().name;
                }
            } else if ("ruleSpec".equals(basePropertyName)) {
                for (int j = 0; j < sourceObjects.length; ++j) {
                    values[j] = ((RuleData)ruleDataIndexByRule.get(sourceObjects[j])).getSpecObject();
                }
            } else if ("isLocationLcmCluster".equals(basePropertyName)) {
                for (int j = 0; j < sourceObjects.length; ++j) {
                    values[j] = Boolean.TRUE.equals(((RuleData)ruleDataIndexByRule.get((Object)sourceObjects[j])).lcmCluster);
                }
            } else {
                _logger.warn((Object)("Unknown rule property: " + basePropertyName));
            }
            valuesByProperty.put(basePropertyName, values);
        }
        return valuesByProperty;
    }

    @Override
    protected Object sourceObjectToReference(Object sourceObject) {
        assert (sourceObject instanceof ManagedObjectReference);
        return sourceObject;
    }

    private static boolean shouldHandleConstraintForType(Constraint c) {
        return c.targetType == null || c.targetType.equalsIgnoreCase(RULE_TYPE);
    }

    private static Map<ManagedObjectReference, RuleData> groupDataItemsByRule(RuleData[] ruleDataItems) {
        HashMap<ManagedObjectReference, RuleData> ruleDataIndexByRule = new HashMap<ManagedObjectReference, RuleData>();
        for (RuleData ruleDataItem : ruleDataItems) {
            ruleDataIndexByRule.put(ruleDataItem.getRule(), ruleDataItem);
        }
        return ruleDataIndexByRule;
    }

    private static boolean isRuleDataPropertyRequested(Set<String> basePropertyNames) {
        return basePropertyNames.contains("name") || basePropertyNames.contains("ruleSpec");
    }
}

