/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.vmware.vim.binding.rbd.PxeProfile;
import com.vmware.vim.binding.rbd.Rule;
import com.vmware.vim.binding.rbd.RuleSet;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.h5.autodeploy.impl.DerivedProperty;
import com.vmware.vsphere.client.h5.autodeploy.impl.RelatedProperty;
import com.vmware.vsphere.client.h5.autodeploy.impl.RulePropertyProvider;
import com.vmware.vsphere.client.h5.autodeploy.rule.RulePatternInfo;
import com.vmware.vsphere.client.h5.autodeploy.util.AutoDeployUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RuleProperties {
    private static final Log _logger = LogFactory.getLog(RuleProperties.class);
    public static final String RULE_NAME_PROP = "name";
    public static final String RULE_SPEC_PROP = "ruleSpec";
    public static final String RULE_LCM_CLUSTER_PROP = "isLocationLcmCluster";
    public static final String ACTIVE_RULE_SET_SPEC_PROP = "ruleSet";
    public static final String RULE_IMAGE_PROFILE_PROP = "imageProfile";
    public static final String RULE_HOST_PROFILE_PROP = "hostProfile";
    public static final String RULE_LOCATION_PROP = "location";
    public static final String RULE_SCRIPT_BUNDLE_PROP = "scriptBundle";
    public static final String RULE_PATTERN_LIST_PROP = "patternList";
    public static final String RULE_PATTERN_INFO_LIST_PROP = "patternInfoList";
    public static final String RULE_ACTIVE_ORDER_PROP = "activeOrder";
    public static final String RULE_IS_ACTIVE_PROP = "isActive";
    public static final String RULE_IMAGE_PROFILE_NAME_PROP = "imageProfileName";
    public static final String RULE_HOST_PROFILE_NAME_PROP = "hostProfileName";
    public static final String RULE_LOCATION_NAME_PROP = "locationName";
    public static final String RULE_CM_CLUSTER_LOCATION_PROP = "isLocationConfigManagerCluster";
    public static final String RULE_SCRIPT_BUNDLE_NAME_PROP = "scriptBundleName";
    public static final RelatedProperty RULE_IMAGE_PROFILE_NAME_DESCRIPTOR = new RelatedProperty("name", "imageProfile");
    public static final RelatedProperty RULE_HOST_PROFILE_NAME_DESCRIPTOR = new RelatedProperty("name", "hostProfile");
    public static final RelatedProperty RULE_LOCATION_NAME_DESCRIPTOR = new RelatedProperty("name", "location");
    public static final RelatedProperty IS_CONFIG_MANAGER_CLUSTER_DESCRIPTOR = new RelatedProperty("isClusterCMEnabled", "location");
    public static final RelatedProperty RULE_SCRIPT_BUNDLE_NAME_DESCRIPTOR = new RelatedProperty("name", "scriptBundle");

    public static class IsActive
    extends DerivedProperty<ManagedObjectReference> {
        @Override
        public String[] getInputPropertyNames() {
            return new String[]{RuleProperties.ACTIVE_RULE_SET_SPEC_PROP};
        }

        @Override
        protected Object getValue(ManagedObjectReference rule, DerivedProperty.BasePropertyHolder holder) {
            RuleSet.RuleSetSpec activeRuleSetSpec = (RuleSet.RuleSetSpec)holder.getInput(RuleProperties.ACTIVE_RULE_SET_SPEC_PROP);
            Object[] ruleList = activeRuleSetSpec != null ? activeRuleSetSpec.ruleList : new ManagedObjectReference[]{};
            return ArrayUtils.contains((Object[])ruleList, (Object)rule);
        }
    }

    public static class ActiveOrder
    extends DerivedProperty<ManagedObjectReference> {
        @Override
        public String[] getInputPropertyNames() {
            return new String[]{RuleProperties.ACTIVE_RULE_SET_SPEC_PROP};
        }

        @Override
        protected Object getValue(ManagedObjectReference rule, DerivedProperty.BasePropertyHolder holder) {
            RuleSet.RuleSetSpec activeRuleSetSpec = (RuleSet.RuleSetSpec)holder.getInput(RuleProperties.ACTIVE_RULE_SET_SPEC_PROP);
            Object[] ruleList = activeRuleSetSpec != null ? activeRuleSetSpec.ruleList : new ManagedObjectReference[]{};
            return ArrayUtils.indexOf((Object[])ruleList, (Object)rule) + 1;
        }
    }

    public static class PatternInfoList
    extends DerivedProperty<ManagedObjectReference> {
        private static final String MULTI_VALUE_PATTERN_DELIMITER = ",";
        private static final String PATTERN_WRAPPER = "'";
        private final Map<String, String> _knownSupportedAttributes;

        public PatternInfoList(Map<String, String> knownSupportedAttributes) {
            this._knownSupportedAttributes = knownSupportedAttributes;
        }

        @Override
        public String[] getInputPropertyNames() {
            return new String[]{RuleProperties.RULE_SPEC_PROP};
        }

        @Override
        protected Object getValue(ManagedObjectReference rule, DerivedProperty.BasePropertyHolder holder) {
            Rule.RuleSpec ruleSpec = (Rule.RuleSpec)holder.getInput(RuleProperties.RULE_SPEC_PROP);
            Rule.Pattern[] patternList = ruleSpec.patternList;
            HashMap<String, RulePatternInfo> patternsInfo = new HashMap<String, RulePatternInfo>();
            if (patternList != null && patternList.length > 0) {
                for (int i = 0; i < patternList.length; ++i) {
                    RulePatternInfo patternInfo = (RulePatternInfo)patternsInfo.get(patternList[i].attribute);
                    if (patternInfo == null) {
                        patternInfo = this.createRulePatternInfo(patternList[i]);
                        patternsInfo.put(patternList[i].attribute, patternInfo);
                        continue;
                    }
                    patternInfo.pattern = patternInfo.pattern + MULTI_VALUE_PATTERN_DELIMITER + this.formatPattern(patternList[i].pattern);
                }
            }
            return patternsInfo.values().toArray(new RulePatternInfo[0]);
        }

        private RulePatternInfo createRulePatternInfo(Rule.Pattern pattern) {
            RulePatternInfo patternInfo = new RulePatternInfo();
            patternInfo.label = this.getLocalizedAttributeName(pattern.attribute);
            patternInfo.attribute = pattern.attribute;
            patternInfo.type = pattern.type;
            patternInfo.pattern = this.formatPattern(pattern.pattern);
            return patternInfo;
        }

        private String getLocalizedAttributeName(String attribute) {
            String label;
            if (this._knownSupportedAttributes.containsKey(attribute)) {
                String key = this._knownSupportedAttributes.get(attribute);
                label = ResourceUtil.getString((String)"autodeployservice", (String)key, (ClassLoader)RulePropertyProvider.class.getClassLoader());
            } else {
                label = attribute;
                _logger.warn((Object)String.format("Rule attribute '%s' is unknown to the client.", attribute));
            }
            return label;
        }

        private String formatPattern(String pattern) {
            if (pattern.contains(MULTI_VALUE_PATTERN_DELIMITER)) {
                String formattedPattern = pattern;
                if (pattern.contains(PATTERN_WRAPPER)) {
                    formattedPattern = pattern.replace(PATTERN_WRAPPER, "''");
                }
                return PATTERN_WRAPPER + formattedPattern + PATTERN_WRAPPER;
            }
            return pattern;
        }
    }

    public static class PatternList
    extends DerivedProperty<ManagedObjectReference> {
        @Override
        public String[] getInputPropertyNames() {
            return new String[]{RuleProperties.RULE_SPEC_PROP};
        }

        @Override
        protected Object getValue(ManagedObjectReference rule, DerivedProperty.BasePropertyHolder holder) {
            Rule.RuleSpec ruleSpec = (Rule.RuleSpec)holder.getInput(RuleProperties.RULE_SPEC_PROP);
            return ruleSpec.patternList;
        }
    }

    public static class ScriptBundle
    extends DerivedProperty<ManagedObjectReference> {
        @Override
        public String[] getInputPropertyNames() {
            return new String[]{RuleProperties.RULE_SPEC_PROP};
        }

        @Override
        public Object getValue(ManagedObjectReference rule, DerivedProperty.BasePropertyHolder holder) {
            Rule.RuleSpec ruleSpec = (Rule.RuleSpec)holder.getInput(RuleProperties.RULE_SPEC_PROP);
            String scriptBundleType = com.vmware.vim.binding.rbd.ScriptBundle.class.getSimpleName();
            for (ManagedObjectReference item : ruleSpec.itemList) {
                if (!scriptBundleType.equals(item.getType())) continue;
                return item;
            }
            return null;
        }
    }

    public static class Location
    extends DerivedProperty<ManagedObjectReference> {
        @Override
        public String[] getInputPropertyNames() {
            return new String[]{RuleProperties.RULE_SPEC_PROP};
        }

        @Override
        protected Object getValue(ManagedObjectReference rule, DerivedProperty.BasePropertyHolder holder) {
            Rule.RuleSpec ruleSpec = (Rule.RuleSpec)holder.getInput(RuleProperties.RULE_SPEC_PROP);
            for (ManagedObjectReference item : ruleSpec.itemList) {
                if (!AutoDeployUtil.isValidRuleLocationItem(item)) continue;
                return item;
            }
            return null;
        }
    }

    public static class HostProfile
    extends DerivedProperty<ManagedObjectReference> {
        @Override
        public String[] getInputPropertyNames() {
            return new String[]{RuleProperties.RULE_SPEC_PROP};
        }

        @Override
        protected Object getValue(ManagedObjectReference rule, DerivedProperty.BasePropertyHolder holder) {
            String hostProfileType = com.vmware.vim.binding.vim.profile.host.HostProfile.class.getSimpleName();
            Rule.RuleSpec ruleSpec = (Rule.RuleSpec)holder.getInput(RuleProperties.RULE_SPEC_PROP);
            for (ManagedObjectReference item : ruleSpec.itemList) {
                if (!hostProfileType.equals(item.getType())) continue;
                return item;
            }
            return null;
        }
    }

    public static class ImageProfile
    extends DerivedProperty<ManagedObjectReference> {
        @Override
        public String[] getInputPropertyNames() {
            return new String[]{RuleProperties.RULE_SPEC_PROP};
        }

        @Override
        protected Object getValue(ManagedObjectReference rule, DerivedProperty.BasePropertyHolder holder) {
            Rule.RuleSpec ruleSpec = (Rule.RuleSpec)holder.getInput(RuleProperties.RULE_SPEC_PROP);
            for (ManagedObjectReference item : ruleSpec.itemList) {
                if (!PxeProfile.class.getSimpleName().equals(item.getType())) continue;
                return item;
            }
            return null;
        }
    }
}

