/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.util;

import com.vmware.vim.binding.rbd.PxeProfile;
import com.vmware.vim.binding.rbd.RuleSet;
import com.vmware.vim.binding.rbd.ScriptBundle;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.Pair;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.autodeploy.host.DeployedHost;
import com.vmware.vsphere.client.h5.autodeploy.impl.HostOpsPropertyProvider;
import com.vmware.vsphere.client.h5.autodeploy.rule.HostComplianceData;
import com.vmware.vsphere.client.h5.autodeploy.util.AutoDeployUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostComplianceHelper {
    private static final Log _logger = LogFactory.getLog(HostComplianceHelper.class);
    private final HostOpsPropertyProvider _hostOpsPropertyProvider;
    private final QueryExecutor _queryExecutor;

    public HostComplianceHelper(HostOpsPropertyProvider hostOpsPropertyProvider, QueryExecutor queryExecutor) {
        this._hostOpsPropertyProvider = hostOpsPropertyProvider;
        this._queryExecutor = queryExecutor;
    }

    public HostComplianceData[] retrieveHostItemsData(RuleSet.BulkCheckResult[] checkResults) {
        if (ArrayUtils.isEmpty((Object[])checkResults)) {
            return new HostComplianceData[0];
        }
        ManagedObjectReference rootFolder = ManagedObjectUtil.getRootFolder((String)checkResults[0].host.getServerGuid());
        DeployedHost[] currentAssociations = this._hostOpsPropertyProvider.getDeployedHosts(rootFolder, null);
        Pair<DeployedHost, RuleSet.BulkCheckResult>[] relevantAssociations = this.filterRelevantAssociations(currentAssociations, checkResults);
        Map<String, String> itemNames = this.retrieveItemNames(checkResults);
        ArrayList<HostComplianceData> result = new ArrayList<HostComplianceData>(relevantAssociations.length);
        for (Pair<DeployedHost, RuleSet.BulkCheckResult> p : relevantAssociations) {
            DeployedHost association = (DeployedHost)p.first;
            RuleSet.BulkCheckResult checkRes = (RuleSet.BulkCheckResult)p.second;
            if (p.first == null) {
                _logger.warn((Object)("Missing association for host: " + ((RuleSet.BulkCheckResult)p.second).host));
                continue;
            }
            if (p.second == null) {
                _logger.warn((Object)("Missing check result for host: " + ((DeployedHost)p.first).host));
                continue;
            }
            HostComplianceData data = this.createComplianceData(association, checkRes.checkResult, itemNames);
            result.add(data);
        }
        return result.toArray(new HostComplianceData[0]);
    }

    public HostComplianceData retrieveHostItemsData(ManagedObjectReference host, RuleSet.CheckResult[] checkResults) {
        DeployedHost[] currentAssociations = this._hostOpsPropertyProvider.getDeployedHosts(ManagedObjectUtil.getRootFolder((String)host.getServerGuid()), host);
        assert (currentAssociations.length <= 1);
        if (currentAssociations.length == 0) {
            _logger.warn((Object)("Unable to retrieve associations for host " + host.toString()));
            return new HostComplianceData();
        }
        Map<String, String> namesMap = this.retrieveItemNames(checkResults);
        return this.createComplianceData(currentAssociations[0], checkResults, namesMap);
    }

    private HostComplianceData createComplianceData(DeployedHost associationForHost, RuleSet.CheckResult[] checkResults, Map<String, String> namesMap) {
        HostComplianceData result = new HostComplianceData();
        result.host = associationForHost.host;
        if (associationForHost.hostProfile != null) {
            result.currentHostProfile = associationForHost.hostProfile;
            result.currentHostProfileName = associationForHost.hostProfileName;
        }
        if (associationForHost.location != null) {
            result.currentLocation = associationForHost.location;
            result.currentLocationName = associationForHost.locationName;
        }
        if (associationForHost.pxeProfile != null) {
            result.currentImageProfile = associationForHost.pxeProfile;
            result.currentImageProfileName = associationForHost.pxeProfileName;
        }
        if (associationForHost.scriptBundle != null) {
            result.currentScriptBundle = associationForHost.scriptBundle;
            result.currentScriptBundleName = associationForHost.scriptBundleName;
        }
        if (checkResults != null) {
            result.isHostCompliant = false;
            for (RuleSet.CheckResult checkResult : checkResults) {
                ManagedObjectReference complianceItemTypeRep;
                ManagedObjectReference managedObjectReference = complianceItemTypeRep = checkResult.expectedItem != null ? checkResult.expectedItem : checkResult.currentItem;
                if (ManagedObjectUtil.isOfType((ManagedObjectReference)complianceItemTypeRep, HostProfile.class)) {
                    result.newHostProfile = checkResult.expectedItem;
                    result.newHostProfileName = this.nameForAssociation(namesMap, result.newHostProfile);
                    continue;
                }
                if (AutoDeployUtil.isValidRuleLocationItem(complianceItemTypeRep)) {
                    result.newLocation = checkResult.expectedItem;
                    result.newLocationName = this.nameForAssociation(namesMap, result.newLocation);
                    continue;
                }
                if (ManagedObjectUtil.isOfType((ManagedObjectReference)complianceItemTypeRep, PxeProfile.class)) {
                    result.newImageProfile = checkResult.expectedItem;
                    result.newImageProfileName = this.nameForAssociation(namesMap, result.newImageProfile);
                    continue;
                }
                if (!ManagedObjectUtil.isOfType((ManagedObjectReference)complianceItemTypeRep, ScriptBundle.class)) continue;
                result.newScriptBundle = checkResult.expectedItem;
                result.newScriptBundleName = this.nameForAssociation(namesMap, result.newScriptBundle);
            }
        } else {
            result.isHostCompliant = true;
        }
        return result;
    }

    private String nameForAssociation(Map<String, String> namesMap, ManagedObjectReference entity) {
        if (entity != null) {
            return namesMap.get(entity.toString());
        }
        return "--";
    }

    private Map<String, String> retrieveItemNames(RuleSet.BulkCheckResult[] checkResults) {
        HashSet<ManagedObjectReference> relevantItems = new HashSet<ManagedObjectReference>();
        for (RuleSet.BulkCheckResult bulkResult : checkResults) {
            HostComplianceHelper.addRelevantObjects(bulkResult.checkResult, relevantItems);
        }
        return this.queryItemNames(relevantItems);
    }

    private Map<String, String> retrieveItemNames(RuleSet.CheckResult[] checkResults) {
        HashSet<ManagedObjectReference> relevantItems = new HashSet<ManagedObjectReference>();
        HostComplianceHelper.addRelevantObjects(checkResults, relevantItems);
        return this.queryItemNames(relevantItems);
    }

    private Map<String, String> queryItemNames(Set<ManagedObjectReference> items) {
        Object[] vcObjects = items.toArray(new ManagedObjectReference[0]);
        PropertyValue[] propValues = new PropertyValue[]{};
        try {
            if (vcObjects.length > 0) {
                propValues = this._queryExecutor.getProperty(vcObjects, "name");
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Error retrieving names for compliance objects", (Throwable)ex);
        }
        HashMap<String, String> namesMap = new HashMap<String, String>();
        for (PropertyValue value : propValues) {
            namesMap.put(value.resourceObject.toString(), value.value.toString());
        }
        return namesMap;
    }

    private static void addRelevantObjects(RuleSet.CheckResult[] checkResults, Set<ManagedObjectReference> out) {
        assert (out != null);
        if (checkResults == null) {
            return;
        }
        for (RuleSet.CheckResult checkResult : checkResults) {
            if (ManagedObjectUtil.areEqual((ManagedObjectReference)checkResult.currentItem, (ManagedObjectReference)checkResult.expectedItem).booleanValue()) continue;
            if (HostComplianceHelper.isKnownType(checkResult.currentItem)) {
                out.add(checkResult.currentItem);
            }
            if (!HostComplianceHelper.isKnownType(checkResult.expectedItem)) continue;
            out.add(checkResult.expectedItem);
        }
    }

    private Pair<DeployedHost, RuleSet.BulkCheckResult>[] filterRelevantAssociations(DeployedHost[] allAssociations, RuleSet.BulkCheckResult[] results) {
        HashMap<ManagedObjectReference, RuleSet.BulkCheckResult> hostsInResult = new HashMap<ManagedObjectReference, RuleSet.BulkCheckResult>();
        for (RuleSet.BulkCheckResult bcr : results) {
            hostsInResult.put(bcr.host, bcr);
        }
        Pair[] relevantAssociations = new Pair[hostsInResult.size()];
        int i = 0;
        for (DeployedHost association : allAssociations) {
            if (!hostsInResult.containsKey(association.host)) continue;
            relevantAssociations[i] = new Pair((Object)association, (Object)((RuleSet.BulkCheckResult)hostsInResult.get(association.host)));
            ++i;
        }
        if (i != relevantAssociations.length) {
            _logger.warn((Object)"Mismatch between count of associations and check results.");
        }
        return relevantAssociations;
    }

    private static boolean isKnownType(ManagedObjectReference entity) {
        return entity != null && (ManagedObjectUtil.isOfType((ManagedObjectReference)entity, HostProfile.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)entity, PxeProfile.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)entity, ScriptBundle.class) || AutoDeployUtil.isValidRuleLocationItem(entity));
    }
}

