/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.common;

import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ExtensionUriSpec {
    public static final String RESOURCE_NAME = "VcExtension";
    private final String _serverGuid;
    private final String _key;
    private final URI _sourceUri;

    public ExtensionUriSpec(URI dataServiceUri) throws IllegalArgumentException {
        Validate.notNull((Object)dataServiceUri);
        String uriType = DefaultUriSchemeUtil.getType((URI)dataServiceUri);
        String[] uriSegments = DefaultUriSchemeUtil.getIdSegments((URI)dataServiceUri);
        if (!ExtensionUriSpec.isValid(uriType, uriSegments)) {
            throw new IllegalArgumentException("VC Extension URI is malformed");
        }
        this._sourceUri = dataServiceUri;
        this._serverGuid = uriSegments[0];
        this._key = uriSegments[1];
    }

    private ExtensionUriSpec(URI sourceUri, String extensionKey, String serverGuid) {
        assert (sourceUri != null && StringUtils.isNotEmpty((CharSequence)serverGuid) && StringUtils.isNotEmpty((CharSequence)extensionKey));
        this._sourceUri = sourceUri;
        this._serverGuid = serverGuid;
        this._key = extensionKey;
    }

    public String getServerGuid() {
        return this._serverGuid;
    }

    public String getKey() {
        return this._key;
    }

    public URI getUri() {
        return this._sourceUri;
    }

    public String toString() {
        return this._sourceUri.toString();
    }

    public static URI toDataServiceUri(String extensionKey, String serverGuid) {
        Validate.notNull((Object)extensionKey);
        Validate.notNull((Object)serverGuid);
        if (extensionKey.isEmpty() || serverGuid.isEmpty()) {
            throw new IllegalArgumentException("extensionKey or serveGuid is empty");
        }
        String id = serverGuid + "/" + extensionKey;
        return DefaultUriSchemeUtil.createUri((String)RESOURCE_NAME, (String)id);
    }

    public static ExtensionUriSpec fromDataServiceUri(URI dataServiceUri) {
        Validate.notNull((Object)dataServiceUri);
        String uriType = DefaultUriSchemeUtil.getType((URI)dataServiceUri);
        String[] uriSegments = DefaultUriSchemeUtil.getIdSegments((URI)dataServiceUri);
        if (ExtensionUriSpec.isValid(uriType, uriSegments)) {
            return new ExtensionUriSpec(dataServiceUri, uriSegments[1], uriSegments[0]);
        }
        return null;
    }

    private static boolean isValid(String uriType, String[] uriSegments) {
        return RESOURCE_NAME.equals(uriType) && uriSegments != null && uriSegments.length == 2 && StringUtils.isNotEmpty((CharSequence)uriSegments[0]) && StringUtils.isNotEmpty((CharSequence)uriSegments[1]);
    }
}

