/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.common;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.common.Session;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.sidecar.SidecarUrlService;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.ClientWithSharedHttpConfig;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareSharedHttpConfigPool;
import com.vmware.vsphere.client.vcextension.common.VcExtensionManagerProxy;
import com.vmware.vsphere.client.vcextension.common.internal.Config;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class VmomiClientFactory {
    private static final Log _logger = LogFactory.getLog(VmomiClientFactory.class);
    private static final Object _vmodlContextLock = new Object();
    private static final int THREAD_POOL_MAXIMUM_SIZE = 10;
    private static VmomiClientFactory _instance = new VmomiClientFactory();
    private static final VcAwareSharedHttpConfigPool _httpConfigPool = new VcAwareSharedHttpConfigPool.Builder().maxConnections(Config.VMOMI_HTTP_CONNECTION_POOL_SIZE_VCF).timeoutInMillis(Config.VMOMI_HTTP_SOCKET_TIMEOUT_VCF).connectionTimeoutInMillis(Config.VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_VCF).build();
    private final ExecutorService _threadPool = ThreadPoolFactory.newQueingCachedThreadPool((int)10, (ThreadFactory)new WorkerThreadFactory("vcextension-vmomi-client-pool"), (long)2L, (TimeUnit)TimeUnit.SECONDS, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);
    private volatile VcExtensionManagerProxy _extensionManagerProxy;
    private volatile KeystoreService _ksService;
    private SidecarUrlService _sidecarUrlService;

    private VmomiClientFactory() {
    }

    public static VmomiClientFactory getInstance() {
        return _instance;
    }

    @Required
    public void setExtensionManagerProxy(VcExtensionManagerProxy proxy) {
        Validate.notNull((Object)proxy, (String)"extension manager proxy is null");
        this._extensionManagerProxy = proxy;
    }

    @Required
    public void setKeystoreService(KeystoreService ksService) {
        Validate.notNull((Object)ksService, (String)"keystore service is null");
        this._ksService = ksService;
    }

    @Required
    public void setSidecarUrlService(SidecarUrlService sidecarUrlService) {
        Validate.notNull((Object)sidecarUrlService, (String)"sidecarUrl service is null");
        this._sidecarUrlService = sidecarUrlService;
    }

    public Client newClient(ClientSpec spec) throws Exception {
        Validate.notNull((Object)spec, (String)"clientSpec is null");
        spec = (ClientSpec)ObjectUtil.shallowCopy((Object)spec, ClientSpec.class);
        spec.validate();
        _logger.info((Object)("Creating client: " + spec.toString()));
        StopWatch timer = new StopWatch();
        timer.start();
        VmomiClientFactory.initializeVmodlContext(spec.vmodlPackage, spec.vmodlVersion);
        VcService vcService = VimSessionUtil.getService((String)spec.serverGuid);
        URI apiEndpoint = this.getExtensionServerUri(vcService, spec.extensionKey, spec.extensionServerType);
        ClientConfiguration clientConfig = this.getClientConfig(apiEndpoint, vcService);
        Client client = Client.Factory.createClient((URI)apiEndpoint, spec.vmodlVersion, (ClientConfiguration)clientConfig);
        client = new ClientWithSharedHttpConfig(client, (SharedHttpConfigPool)_httpConfigPool);
        ProtocolBinding binding = client.getBinding();
        String sessionCookie = vcService.getConnectionInfo().getSessionCookie();
        Session session = binding.createSession(sessionCookie);
        binding.setSession(session);
        timer.stop();
        _logger.info((Object)("Creation of client " + spec.toString() + " took " + timer.getTime() + " ms"));
        return client;
    }

    private ClientConfiguration getClientConfig(URI apiEndpoint, VcService vcService) {
        String serviceUrl = apiEndpoint.toString();
        KeyStore keyStore = this._ksService.getKeyStore();
        String vcGuid = vcService.getServiceGuid();
        String sslThumbprint = vcService.getThumbprint();
        URI sidecarUri = this._sidecarUrlService.createSidecarUrl(URI.create(serviceUrl), SidecarUrlService.CertificateAuthority.VECS);
        HttpConfiguration httpConfig = _httpConfigPool.getHttpConfig(sidecarUri.toString(), vcGuid, keyStore, sslThumbprint);
        HttpClientConfiguration clientConfig = HttpClientConfiguration.Factory.newInstance();
        clientConfig.setExecutor((Executor)this._threadPool);
        clientConfig.setHttpConfiguration(httpConfig);
        return clientConfig;
    }

    private URI getExtensionServerUri(VcService vcService, String extensionKey, String extensionServerType) throws Exception {
        Extension.ServerInfo[] serverInfos;
        Extension extension = this.getExtension(vcService.getServiceGuid(), extensionKey);
        if (extension == null) {
            throw new Exception("Unknown extension " + extensionKey + " on server with GUID " + vcService.getServiceUrl());
        }
        String vcHost = this.getVcHostName(vcService);
        for (Extension.ServerInfo info : serverInfos = extension.getServer()) {
            if (!info.getType().equalsIgnoreCase(extensionServerType)) continue;
            String url = info.getUrl();
            url = url.replace("*", vcHost);
            try {
                return new URI(url);
            }
            catch (URISyntaxException ex) {
                throw new Exception("Invalid extension server URL " + url + " for extension " + extensionKey, ex);
            }
        }
        throw new Exception("Unknown server type " + extensionServerType + "for extension " + extensionKey);
    }

    private String getVcHostName(VcService vcService) {
        String serviceUrl = vcService.getServiceUrl();
        URI serviceUri = URI.create(serviceUrl);
        return serviceUri.getHost();
    }

    private Extension getExtension(String serverGuid, String extensionKey) {
        if (this._extensionManagerProxy == null) {
            throw new IllegalStateException("Factory not initialized: VcExtensionManagerProxy not set");
        }
        HashSet<String> extensionKeys = new HashSet<String>(Arrays.asList(extensionKey));
        List<Extension> extensions = this._extensionManagerProxy.getExtensionsForServer(serverGuid, extensionKeys);
        if (extensions.isEmpty()) {
            return null;
        }
        assert (extensions.size() == 1) : "Multiple extensions with key" + extensionKey;
        return extensions.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeVmodlContext(String vmodlPackage, Class<?> version) {
        if (VmodlVersionMap.Factory.getVmodlVersionMap().getVersion(version) != null) {
            _logger.debug((Object)("VMODL definitions for '" + version.getName() + "' already loaded."));
        } else {
            Object object = _vmodlContextLock;
            synchronized (object) {
                if (VmodlVersionMap.Factory.getVmodlVersionMap().getVersion(version) == null) {
                    _logger.info((Object)("Adding package '" + vmodlPackage + "' version '" + version.getName() + "' to VMODL context."));
                    ClassLoader bundleClassLoader = version.getClassLoader();
                    ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(bundleClassLoader);
                        VmodlContext.initContext((String[])new String[]{vmodlPackage});
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(currentClassLoader);
                    }
                }
            }
        }
    }

    public static class ClientSpec {
        public String extensionKey;
        public String serverGuid;
        public String extensionServerType;
        public String vmodlPackage;
        public Class<?> vmodlVersion;

        public void validate() {
            Validate.notEmpty((String)this.serverGuid, (String)"serverGuid is null or empty");
            Validate.notEmpty((String)this.extensionKey, (String)"extensionKey null or empty");
            Validate.notEmpty((String)this.extensionServerType, (String)"extensionServerType is null or empty");
            Validate.notEmpty((String)this.vmodlPackage, (String)"vmodlPackage is null or empty");
            Validate.notNull(this.vmodlVersion, (String)"vmodlVersion is null");
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.serverGuid);
            builder.append("/");
            builder.append(this.extensionKey);
            builder.append(":");
            builder.append(this.vmodlPackage);
            builder.append(":");
            builder.append(this.vmodlVersion.getSimpleName());
            return builder.toString();
        }
    }
}

