/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.logbundle;

import com.vmware.cis.services.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestRequest;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.SamlTokenEx;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.http.Request;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.sidecar.SidecarUrlService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vsphere.client.logbundle.UrlZipEntry;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoOverRestZipEntry
extends UrlZipEntry {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final int HEADER_CHUNK_SIZE = 1024;
    @Nullable
    private final SsoDomain _ssoDomain;
    private final KeyStore _ks;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final SidecarUrlService _sidecarUrlService;

    public SsoOverRestZipEntry(URI remoteUri, SsoDomain ssoDomain, KeyStore ks, SSLConfigurationProvider sslConfigProvider, SidecarUrlService sidecarUrlService) {
        super(remoteUri);
        this._ssoDomain = ssoDomain;
        this._ks = ks;
        this._sslConfigurationProvider = sslConfigProvider;
        this._sidecarUrlService = sidecarUrlService;
    }

    @Override
    protected InputStream connect(String clientId) throws IOException, Exception {
        SamlTokenEx ssoTokenEx;
        if (this._ssoDomain != null) {
            ssoTokenEx = AuthSessionUtil.getSsoTokenEx((SsoDomain)this._ssoDomain, (String)clientId);
        } else {
            _logger.warn((Object)"No SSO domain specified. Will use the local domain.");
            ssoTokenEx = AuthSessionUtil.getSsoTokenEx((SsoDomain)SsoDomainHelper.getLocal(), (String)clientId);
        }
        SsoOverRestRequest req = new SsoOverRestRequest(Request.Method.GET, this.url.toURL(), null);
        SamlToken ssoToken = ssoTokenEx.getToken();
        PrivateKey pk = ssoTokenEx.getPrivateKey().orElse(null);
        Map authorizationHeaders = SsoOverRestHelper.calcAuthHeader((com.vmware.cis.common.sso.SsoOverRestRequest)req, (PrivateKey)pk, (SamlToken)ssoToken, (int)1024);
        HttpClient httpClient = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).addTrustStore(this._ks).socketReadTimeout(0).buildHttpClientIgnoreErrors();
        URI sidecarUri = this._sidecarUrlService.createSidecarUrl(this.url, SidecarUrlService.CertificateAuthority.VECS);
        return httpClient.executeMethodResponseAsStream(sidecarUri.toString(), null, authorizationHeaders);
    }
}

