/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.logbundle;

import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.sidecar.SidecarUrlService;
import com.vmware.vsphere.client.logbundle.FileZipEntry;
import com.vmware.vsphere.client.logbundle.HttpZipEntry;
import com.vmware.vsphere.client.logbundle.LogBundleDownloadSpec;
import com.vmware.vsphere.client.logbundle.ScaPublishedLogBundleDownloadSpec;
import com.vmware.vsphere.client.logbundle.SsoOverRestZipEntry;
import com.vmware.vsphere.client.logbundle.exception.ReadIOException;
import com.vmware.vsphere.client.logbundle.exception.WriteIOException;
import com.vmware.vsphere.client.logbundle.helper.DownloadingLogsTask;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UrlZipEntry {
    private static final Log _logger = LogFactory.getLog(UrlZipEntry.class);
    private static final int MAX_BYTES_FOR_READ = 65536;
    private static final String FILE_SCHEME = "file";
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final String VM_PARAM_SEARCH_PATTERN = "&vm=";
    private static final double MINIMUM_TASK_UPDATE_THRESHOLD = 3.0;
    private static final int INITAL_PROGRESS_UPDATE_PERCENTS = 2;
    private InputStream inputStream = null;
    protected URI url;
    protected long contentLength;

    public static UrlZipEntry getInstance(LogBundleDownloadSpec spec, KeyStore ks, SSLConfigurationProvider sslConfigProvider, SidecarUrlService sidecarUrlService) {
        String bundleUrl = spec.bundleUrl;
        String vmPath = null;
        int indexOfSearchPattern = bundleUrl.indexOf(VM_PARAM_SEARCH_PATTERN);
        if (indexOfSearchPattern >= 0) {
            vmPath = bundleUrl.substring(indexOfSearchPattern + VM_PARAM_SEARCH_PATTERN.length());
            bundleUrl = bundleUrl.substring(0, indexOfSearchPattern);
        }
        URI url = URI.create(bundleUrl);
        SsoDomain ssoDomain = null;
        if (spec.ssoDomainId != null) {
            ssoDomain = SsoDomainHelper.valueOf((String)spec.ssoDomainId, null, null);
        }
        if (spec instanceof ScaPublishedLogBundleDownloadSpec) {
            return new SsoOverRestZipEntry(url, ssoDomain, ks, sslConfigProvider, sidecarUrlService);
        }
        String uriScheme = url.getScheme();
        if (FILE_SCHEME.equals(uriScheme = uriScheme.toLowerCase())) {
            return new FileZipEntry(url);
        }
        if (HTTP_SCHEME.equals(uriScheme) || HTTPS_SCHEME.equals(uriScheme)) {
            HttpZipEntry resultEntry = new HttpZipEntry(url, spec, ks, sslConfigProvider, sidecarUrlService);
            if (vmPath != null) {
                resultEntry.setVmPath(vmPath);
            }
            resultEntry.setEncryptPassword(spec.encryptPassword);
            return resultEntry;
        }
        throw new IllegalArgumentException("Unsupported URI scheme: " + uriScheme);
    }

    public UrlZipEntry(URI fileUrl) {
        this.url = fileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ZipOutputStream stream, String clientId, DownloadingLogsTask downloadTask, int percentsOfTotalTask) throws IOException, Exception {
        try {
            this.inputStream = this.connect(clientId);
            byte[] content = new byte[65536];
            int bytesRead = 0;
            int oldProgress = 0;
            if (downloadTask != null) {
                downloadTask.getProgress();
            }
            double percentsForCurrentUpdate = 0.0;
            boolean downloadStarted = false;
            while (true) {
                try {
                    bytesRead = this.inputStream.read(content, 0, 65536);
                }
                catch (IOException e) {
                    throw new ReadIOException(e);
                }
                if (bytesRead < 0) break;
                try {
                    stream.write(content, 0, bytesRead);
                }
                catch (IOException e) {
                    throw new WriteIOException(e);
                }
                if (downloadTask == null) continue;
                if ((long)bytesRead <= this.contentLength) {
                    if (!((percentsForCurrentUpdate += (double)bytesRead / (double)this.contentLength * (double)percentsOfTotalTask) > 3.0)) continue;
                    downloadTask.updateProgress((int)percentsForCurrentUpdate);
                    percentsForCurrentUpdate = 0.0;
                    continue;
                }
                if (downloadStarted) continue;
                downloadStarted = true;
                downloadTask.updateProgress(2);
            }
            if (downloadTask != null && oldProgress + percentsOfTotalTask > downloadTask.getProgress()) {
                downloadTask.setProgress(oldProgress + percentsOfTotalTask);
            }
        }
        finally {
            this.cleanup();
        }
    }

    protected void cleanup() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException ioe) {
            _logger.warn((Object)("Cannot close the stream to url " + this.url), (Throwable)ioe);
        }
    }

    protected abstract InputStream connect(String var1) throws IOException, Exception;
}

