/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.logbundle.helper;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.logbundle.LogBundleDownloadSpec;
import com.vmware.vsphere.client.logbundle.SelectedLogsSpec;
import com.vmware.vsphere.client.task.TaskRegistry;
import com.vmware.vsphere.client.task.impl.TaskUtil;
import java.util.Calendar;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadingLogsTask {
    private static final Log _logger = LogFactory.getLog(DownloadingLogsTask.class);
    private static final String ROOT_FOLDER_ENTITY_TYPE = "rootFolder";
    private static final String NAME_PROPERTY = "name";
    private static final String DOWNLOADING_LOGS_CLIENT_TASK_TYPE = "DownloadingLogsTask";
    private static final String DOWNLOADING_LOGS_CLIENT_TASK_VALUE_PREFIX = "dlt-";
    private static final char FILE_ID_VALUE_DELIMITER = '_';
    private static final String DOWNLOADING_LOGS_TASK_DESCRIPTION_KEY = "downloading.logs.task.description";
    private static final AtomicInteger DOWNLOADING_LOGS_CLIENT_TASK_COUNTER = new AtomicInteger(1);
    private ClientTaskInfo _clientTask;
    private final TaskRegistry _taskRegistry;

    public static ManagedObjectReference findTaskTarget(SelectedLogsSpec selectedLogsSpec, Collection<LogBundleDownloadSpec> logBundleDownloadSpecs) {
        if (selectedLogsSpec != null) {
            if (!selectedLogsSpec.vCenterLogsIncluded && !ArrayUtils.isEmpty((Object[])selectedLogsSpec.selectedHosts) && selectedLogsSpec.selectedHosts.length == 1) {
                return selectedLogsSpec.selectedHosts[0];
            }
            return selectedLogsSpec.targetObjectReference;
        }
        for (LogBundleDownloadSpec spec : logBundleDownloadSpecs) {
            if (spec.vcReference == null) continue;
            return spec.vcReference;
        }
        for (LogBundleDownloadSpec spec : logBundleDownloadSpecs) {
            if (spec.serviceUuid == null) continue;
            return ManagedObjectUtil.getRootFolder((String)spec.serviceUuid);
        }
        return null;
    }

    public DownloadingLogsTask(String clientId, ManagedObjectReference taskTarget, int fileId, QueryExecutor queryExecutor, TaskRegistry taskRegistry) {
        if (taskTarget == null) {
            throw new IllegalArgumentException("taskTarget must not be null.");
        }
        this._taskRegistry = taskRegistry;
        String initiator = (String)SessionUtil.getData((String)"USER_NAME", (String)clientId);
        this._clientTask = new ClientTaskInfo();
        this._clientTask.initiator = initiator;
        this._clientTask.entity = taskTarget;
        this._clientTask.entityType = ManagedObjectUtil.isRootFolder((ManagedObjectReference)taskTarget) ? ROOT_FOLDER_ENTITY_TYPE : taskTarget.getType();
        this._clientTask.cancelable = true;
        this._clientTask.startTime = Calendar.getInstance().getTime();
        this._clientTask.description = TaskUtil.getLocalizedString((String)DOWNLOADING_LOGS_TASK_DESCRIPTION_KEY);
        this._clientTask.state = TaskState.RUNNING;
        this._clientTask.taskRef = this.generateTaskReference(fileId, taskTarget.getServerGuid());
        try {
            String entityNamePropVal;
            this._clientTask.entityName = entityNamePropVal = (String)queryExecutor.getProperty((Object)taskTarget, NAME_PROPERTY);
        }
        catch (Exception e) {
            _logger.error((Object)"Cannot get entity name.", (Throwable)e);
        }
        this._clientTask = this._taskRegistry.addTask(this._clientTask);
    }

    public int getProgress() {
        return this._clientTask.progress;
    }

    public void updateProgress(int percentsToAdd) {
        this._clientTask.progress += percentsToAdd;
        this._taskRegistry.updateTask(this._clientTask);
    }

    public void setProgress(int progress) {
        this._clientTask.progress = progress;
        this._taskRegistry.updateTask(this._clientTask);
    }

    public TaskState getState() {
        this._clientTask = this._taskRegistry.getTask(this._clientTask.key);
        return this._clientTask.state;
    }

    public void updateState(TaskState state, Exception exception) {
        this._clientTask.state = state;
        if (exception != null) {
            this._clientTask.error = exception;
        }
        if (TaskState.SUCCESS.equals((Object)state)) {
            this._clientTask.completionTime = Calendar.getInstance().getTime();
        }
        this._taskRegistry.updateTask(this._clientTask);
    }

    public String getKey() {
        return this._clientTask.key;
    }

    public ClientTaskInfo getClientTaskInfo() {
        return this._clientTask;
    }

    private ManagedObjectReference generateTaskReference(int fileId, String serverGuid) {
        String taskReferenceValue = DOWNLOADING_LOGS_CLIENT_TASK_VALUE_PREFIX + DOWNLOADING_LOGS_CLIENT_TASK_COUNTER.getAndIncrement() + '_' + fileId;
        return new ManagedObjectReference(DOWNLOADING_LOGS_CLIENT_TASK_TYPE, taskReferenceValue, serverGuid);
    }
}

