/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.scheduling.impl;

import com.vmware.vim.binding.vim.scheduler.OnceTaskScheduler;
import com.vmware.vim.binding.vim.scheduler.ScheduledTask;
import com.vmware.vim.binding.vim.scheduler.TaskScheduler;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.scheduler.OnceScheduler;
import com.vmware.vise.core.model.scheduling.ScheduledTaskSpec;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScheduledOpsMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ScheduledOpsMutationProvider.class);
    private DataService _dataService;

    public ScheduledOpsMutationProvider(DataService dataService) {
        this._dataService = dataService;
        _logger.debug((Object)"Instance created");
    }

    public OperationResult apply(ManagedObjectReference entity, ScheduledTaskSpec spec) throws Exception {
        OperationResult result = new OperationResult();
        if (spec.recurrence instanceof OnceScheduler) {
            entity = (ManagedObjectReference)spec.scheduledTask;
            result.entity = entity;
            this.runOperation(entity, spec);
        } else {
            TaskScheduler recurrence = (TaskScheduler)spec.recurrence;
            if (this.shouldRunNow(recurrence).booleanValue()) {
                result.entity = entity;
                this.runOperation(entity, spec);
            }
        }
        return result;
    }

    public OperationResult remove(ManagedObjectReference entity, ScheduledTaskSpec spec) throws Exception {
        OperationResult result = new OperationResult();
        result.entity = entity;
        if (spec.recurrence instanceof OnceScheduler) {
            entity = (ManagedObjectReference)spec.scheduledTask;
            result.entity = entity;
        }
        this.removeOperation(entity);
        QueryUtil.waitUntilNotSearchable((DataService)this._dataService, (Object)entity);
        return result;
    }

    private void runOperation(ManagedObjectReference entity, ScheduledTaskSpec spec) throws Exception {
        ScheduledTask scheduledTask = (ScheduledTask)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entity);
        scheduledTask.run();
    }

    private void removeOperation(ManagedObjectReference entity) throws Exception {
        ScheduledTask scheduledTask = (ScheduledTask)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entity);
        scheduledTask.remove();
    }

    private Boolean shouldRunNow(TaskScheduler scheduler) {
        if (scheduler instanceof OnceTaskScheduler) {
            return ((OnceTaskScheduler)scheduler).runAt == null;
        }
        return false;
    }
}

