/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.scheduling.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QuerySpecBuilder;

public class ScheduledOpsPropertyProvider
implements PropertyProviderBean {
    private final DataService _dataService;
    private final QuerySpecBuilder _querySpecBuilder;

    public ScheduledOpsPropertyProvider(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
    }

    @type(value="Folder,Datacenter,HostSystem,ComputeResource,VirtualMachine,ClusterComputeResource,Datastore,DistributedVirtualPortgroup,DistributedVirtualSwitch,VmwareDistributedVirtualSwitch,ResourcePool,VirtualApp,StoragePod,HostProfile,Network,")
    public ResultSet getAllScheduledTasks(ManagedObjectReference target) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)target);
        RelationalConstraint scheduledTaskConstraint = this._querySpecBuilder.createRelationalConstraint("scheduledTask", (Constraint)objectIdentityConstraint, Boolean.valueOf(true), "vsphere:ScheduledTask");
        QuerySpec tagQuerySpec = this._querySpecBuilder.buildQuerySpec((Constraint)scheduledTaskConstraint, new String[]{"scheduledTaskInfo"});
        RequestSpec reqSpec = new RequestSpec();
        reqSpec.querySpec = new QuerySpec[]{tagQuerySpec};
        Response response = this._dataService.getData(reqSpec);
        return response.resultSet[0];
    }

    @type(value="ScheduledTask")
    public ResultSet getScheduledTaskExecutionInfo(ManagedObjectReference target) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)target);
        objectIdentityConstraint.targetType = "vsphere:ScheduledTask";
        QuerySpec tagQuerySpec = this._querySpecBuilder.buildQuerySpec((Constraint)objectIdentityConstraint, new String[]{"scheduledTaskExecutionInfo"});
        RequestSpec reqSpec = new RequestSpec();
        reqSpec.querySpec = new QuerySpec[]{tagQuerySpec};
        Response response = this._dataService.getData(reqSpec);
        return response.resultSet[0];
    }

    @type(value="ScheduledTask")
    public ResultSet getScheduledTaskInfo(ManagedObjectReference target) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)target);
        objectIdentityConstraint.targetType = "vsphere:ScheduledTask";
        QuerySpec tagQuerySpec = this._querySpecBuilder.buildQuerySpec((Constraint)objectIdentityConstraint, new String[]{"scheduledTaskInfo"});
        RequestSpec reqSpec = new RequestSpec();
        reqSpec.querySpec = new QuerySpec[]{tagQuerySpec};
        Response response = this._dataService.getData(reqSpec);
        return response.resultSet[0];
    }
}

