/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.library.impl;

import com.vmware.content.library.StorageBacking;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.derivedproperty.DerivedPropertyProviderAdapter;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.library.util.LibraryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    public static final String VCENTER_NAME = "vcenterName";
    public static final String BACKING_DATASTORES = "backingDatastores";
    public static final String VCENTER_ICON = "vcenterIcon";
    public static final String[] ALL_PROPERTIES = new String[]{"vcenterName", "backingDatastores", "vcenterIcon"};
    public static final Set<String> ALL_PROPERTIES_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ALL_PROPERTIES)));
    public static final String VC_GUID_PROP = "com.vmware.content.LibraryModel/serverGuid";
    public static final String STORAGE_BACKINGS_PROP = "com.vmware.content.LibraryModel/storageBackings";
    private static final Log _logger = LogFactory.getLog(LibraryPropertyProviderAdapter.class);

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Validate.notNull((Object)propertyRequest.objects);
        Validate.notNull((Object)propertyRequest.properties);
        HashSet<String> requestedProperties = new HashSet<String>();
        for (PropertySpec propSpec : propertyRequest.properties) {
            for (String propName : propSpec.propertyNames) {
                if (!ALL_PROPERTIES_SET.contains(propName)) continue;
                requestedProperties.add(propName);
            }
        }
        if (requestedProperties.isEmpty()) {
            _logger.error((Object)"No properties requested.");
            throw new IllegalArgumentException(LibraryUtil.getLocalizedString("error.emptyProperties"));
        }
        Object[] objects = propertyRequest.objects;
        if (ArrayUtils.isEmpty((Object[])objects)) {
            _logger.warn((Object)"No object reference retrieved.");
            return null;
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        for (Object obj : objects) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null) continue;
            ResultItem resItem = new ResultItem();
            resItem.resourceObject = obj;
            PropertyValue[] computedValues = this.computeResultSet(requestedProperties, sourcePropertyValuesMap, resItem.resourceObject);
            resItem.properties = computedValues;
            resultItems.add(resItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    public void setDsExtensionRegistry(DataServiceExtensionRegistry dsExtensionRegistry) {
        if (dsExtensionRegistry == null) {
            throw new IllegalArgumentException("DataServiceExtensionRegistry null reference provided.");
        }
        dsExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getTypeInfos());
    }

    private PropertyValue[] computeResultSet(Set<String> reqProps, Map<String, Object> propertyValuesMap, Object resourceObject) {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>();
        if (reqProps.contains(VCENTER_NAME)) {
            this.computeVCenterName(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(VCENTER_ICON)) {
            this.computeVCenterIcon(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(BACKING_DATASTORES)) {
            this.computeBackingDatastores(propertyValuesMap, results, resourceObject);
        }
        return results.toArray(new PropertyValue[0]);
    }

    private void computeVCenterName(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        String vCenterName = null;
        String vcGuid = (String)propertyValuesMap.get(VC_GUID_PROP);
        try {
            vCenterName = VcServiceUtil.getServiceName((String)vcGuid);
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
        propValues.add(this.createPropValue(VCENTER_NAME, vCenterName, resourceObject));
    }

    private void computeVCenterIcon(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        String vCenterIcon = "vsphere-icon-vcenter";
        String vcGuid = (String)propertyValuesMap.get(VC_GUID_PROP);
        VcService vcService = VimSessionUtil.getService((String)vcGuid);
        try {
            if (VcServiceUtil.isCloudVc((VcService)vcService)) {
                vCenterIcon = "vsphere-icon-cloud-vcenter";
            }
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
        propValues.add(this.createPropValue(VCENTER_ICON, vCenterIcon, resourceObject));
    }

    private void computeBackingDatastores(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        ArrayList<ManagedObjectReference> dsRef = new ArrayList<ManagedObjectReference>();
        ArrayList storageBackings = (ArrayList)propertyValuesMap.get(STORAGE_BACKINGS_PROP);
        for (StorageBacking s : storageBackings) {
            if (!StorageBacking.Type.DATASTORE.equals((Object)s.getType())) continue;
            ManagedObjectReference ds = CisIdConverter.fromGlobalCisId((String)s.getDatastoreId(), (String)Datastore.class.getSimpleName());
            dsRef.add(ds);
        }
        propValues.add(this.createPropValue(BACKING_DATASTORES, dsRef.toArray(new ManagedObjectReference[dsRef.size()]), resourceObject));
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private TypeInfo[] getTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.properties = ALL_PROPERTIES;
        ti.type = "com.vmware.content.Library";
        DerivedPropertyInfo vCenterNameInfo = new DerivedPropertyInfo();
        vCenterNameInfo.propertyName = VCENTER_NAME;
        vCenterNameInfo.sourcePropertyNames = new String[]{VC_GUID_PROP};
        DerivedPropertyInfo vCenterIconInfo = new DerivedPropertyInfo();
        vCenterIconInfo.propertyName = VCENTER_ICON;
        vCenterIconInfo.sourcePropertyNames = new String[]{VC_GUID_PROP};
        DerivedPropertyInfo storageBackingsInfo = new DerivedPropertyInfo();
        storageBackingsInfo.propertyName = BACKING_DATASTORES;
        storageBackingsInfo.sourcePropertyNames = new String[]{STORAGE_BACKINGS_PROP};
        ti.derivedProperties = new DerivedPropertyInfo[]{vCenterNameInfo, vCenterIconInfo, storageBackingsInfo};
        return new TypeInfo[]{ti};
    }
}

