/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.util;

import com.vmware.vsphere.client.libraryItem.model.FileType;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TransferUtil {
    private static final Set<String> _supportedSchemes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("file", "http", "https", "ds")));

    public static FileType getFileType(URI source) {
        if (source == null) {
            return FileType.UNKNOWN;
        }
        String path = source.getPath();
        if (path.endsWith("/")) {
            path = StringUtils.stripEnd((String)path, (String)"/\\");
        }
        String fileExt = StringUtils.substringAfterLast((String)path, (String)".").toLowerCase();
        return FileType.fromExtension(fileExt);
    }

    public static String getSourceFileName(URI source) {
        String name = "";
        if (source != null) {
            String path = source.getPath();
            if (path.endsWith("/")) {
                path = StringUtils.stripEnd((String)path, (String)"/");
            }
            name = StringUtils.substringAfterLast((String)path, (String)"/");
        }
        return name;
    }

    public static String getSourceFileNameWithoutExt(URI source) {
        String fileName = TransferUtil.getSourceFileName(source);
        String name = "";
        if (fileName != null) {
            name = fileName.contains(".") ? StringUtils.substringBeforeLast((String)fileName, (String)".") : fileName;
        }
        return name;
    }

    public static String getLibraryItemType(FileType sourceType) {
        if (sourceType == FileType.OVF) {
            return "ovf";
        }
        if (sourceType == FileType.ISO) {
            return "iso";
        }
        if (sourceType == FileType.SCRIPT) {
            return "script";
        }
        return "file";
    }

    public static boolean isSourceSchemeSupported(URI source) {
        if (source == null) {
            return false;
        }
        return _supportedSchemes.contains(source.getScheme());
    }
}

