/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.authentication;

import com.vmware.ph.ceip.authentication.DsHttpServletRequest;
import com.vmware.ph.ceip.authentication.DsHttpSession;
import com.vmware.ph.ceip.authentication.DsSessionSimulator;
import com.vmware.ph.ceip.authentication.ServiceEndpointInfo;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.ApiGatewaySession;
import com.vmware.vcenter.apigw.api.ApiGatewaySessionManager;
import com.vmware.vcenter.apigw.api.sso.ServicePrincipal;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.SsoDomainNotFoundException;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.ImmutableSingleDomainNonRenewingTokenProvider;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.SamlTokenEx;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.TokenAcquisitionResult;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.TokenException;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.TokenProvider;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.vim.version.internal.versions;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.extensions.impl.LinkedVcGroupRegistryImpl;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroupFactory;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsSessionSimulatorImpl
implements DsSessionSimulator {
    private final VcGroupsRegistryProvider registryProvider;
    private final ApiGatewaySessionManager apiGatewaySessionManager;
    private static final Logger logger = LoggerFactory.getLogger(DsSessionSimulatorImpl.class);

    public DsSessionSimulatorImpl(VcGroupsRegistryProvider registryProvider, ApiGatewaySessionManager apiGatewaySessionManager) {
        this.registryProvider = registryProvider;
        this.apiGatewaySessionManager = apiGatewaySessionManager;
    }

    @Override
    public HttpServletRequest simulate(ServicePrincipal svcPrincipal, String simulationUserName) {
        SamlTokenEx tokenEx = svcPrincipal.getTokenForLocalDomain();
        LinkedVcGroupRegistry registry = this.registryProvider.getLinkedVcGroupRegistry(tokenEx.getIssuerSsoDomain(), tokenEx.getToken(), tokenEx.getPrivateKey().orElse(null), simulationUserName);
        DsHttpSession cisDsSession = this.establishSession(svcPrincipal, registry, simulationUserName);
        DsHttpServletRequest request = new DsHttpServletRequest(cisDsSession);
        SessionUtil.setHttpRequest((HttpServletRequest)request);
        return request;
    }

    @Override
    public void close(HttpServletRequest request) {
        if (request == null) {
            logger.debug("Request cannot be closed since it is null. Skipping close().");
            return;
        }
        HttpSession cisDataSession = request.getSession();
        LinkedVcGroupRegistry vcGroupRegistry = (LinkedVcGroupRegistry)SessionUtil.getData((String)"LINKED_VC_GROUP_REGISTRY", (HttpSession)cisDataSession);
        if (vcGroupRegistry != null) {
            LinkedVcGroup[] startupLinkedVcGroups;
            LinkedVcGroupRegistry.StartupGroupUtils utils = vcGroupRegistry.getUtils();
            for (LinkedVcGroup vcGroup : startupLinkedVcGroups = utils.getStartupLinkedVcGroups()) {
                vcGroup.logout();
            }
        } else {
            logger.warn("LinkedVcGroupRegistry not available in SessionUtil. As a result there are no LinkedVcGroups to logout from. We don't consider this an error. We assume that UI Platform has cleared the session correctly.");
        }
        SessionUtil.removeAll((HttpSession)cisDataSession);
        SessionUtil.setHttpRequest(null);
        this.apiGatewaySessionManager.logout(cisDataSession.getId());
    }

    private DsHttpSession establishSession(ServicePrincipal svcPrincipal, LinkedVcGroupRegistry registry, String simulationUserName) {
        SamlTokenEx localTokenEx = svcPrincipal.getTokenForLocalDomain();
        String sessionId = this.logIntoApiGwAndGetSessionId(localTokenEx.getToken());
        DsHttpSession cisDsSession = new DsHttpSession(sessionId);
        SessionUtil.generateAndSaveClientId((HttpSession)cisDsSession);
        SessionUtil.setData((String)"USER_NAME", (Object)simulationUserName, (HttpSession)cisDsSession);
        SessionUtil.setData((String)"LINKED_VC_GROUP_REGISTRY", (Object)registry, (HttpSession)cisDsSession);
        AuthSessionUtil.setSsoTokenProvider((TokenProvider)new ServicePrincipalTokenProviderForLocalDomain(svcPrincipal), (HttpSession)cisDsSession);
        return cisDsSession;
    }

    private String logIntoApiGwAndGetSessionId(SamlToken token) {
        try {
            ApiGatewaySession session = this.apiGatewaySessionManager.login(token);
            return session.getId();
        }
        catch (RuntimeException ex) {
            logger.error("There was a problem logging into the Api Gateway", (Throwable)ex);
            throw ex;
        }
    }

    private static class ServicePrincipalTokenProviderForLocalDomain
    implements TokenProvider {
        private final ServicePrincipal _servicePrincipal;

        public ServicePrincipalTokenProviderForLocalDomain(ServicePrincipal servicePrincipal) {
            this._servicePrincipal = servicePrincipal;
        }

        public SamlTokenEx getSamlToken(SsoDomain ssoDomain) throws SsoDomainNotFoundException, TokenException {
            SsoDomain localDomain = SsoDomainHelper.getLocal();
            Validate.isTrue((boolean)localDomain.equals((Object)ssoDomain), (String)"Only the local domain is supported", (Object[])new Object[0]);
            return this._servicePrincipal.getToken(ssoDomain);
        }

        public CompletableFuture<SamlTokenEx> getSamlTokenAsync(SsoDomain ssoDomain) throws SsoDomainNotFoundException {
            SsoDomain localDomain = SsoDomainHelper.getLocal();
            Validate.isTrue((boolean)localDomain.equals((Object)ssoDomain), (String)"Only the local domain is supported", (Object[])new Object[0]);
            return this._servicePrincipal.getTokenAsync(ssoDomain);
        }

        public Collection<TokenAcquisitionResult> getAllTokens() {
            SsoDomain localDomain = SsoDomainHelper.getLocal();
            try {
                SamlTokenEx localTokenEx = this._servicePrincipal.getTokenForLocalDomain();
                return Collections.singleton(new TokenAcquisitionResult(localDomain, localTokenEx, null));
            }
            catch (Exception e) {
                return Collections.singleton(new TokenAcquisitionResult(localDomain, null, (Throwable)e));
            }
        }

        public CompletableFuture<Collection<TokenAcquisitionResult>> getAllTokensAsync() {
            SsoDomain localDomain = SsoDomainHelper.getLocal();
            try {
                return ((CompletableFuture)this._servicePrincipal.getTokenForLocalDomainAsync().thenApply(localTokenEx -> Collections.singleton(new TokenAcquisitionResult(localDomain, localTokenEx, null)))).exceptionally(t -> Collections.singleton(new TokenAcquisitionResult(localDomain, null, t)));
            }
            catch (Exception e) {
                return CompletableFuture.completedFuture(Collections.singleton(new TokenAcquisitionResult(localDomain, null, (Throwable)e)));
            }
        }
    }

    public static class ServiceInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final ServiceEndpointInfo _serviceEndpointInfo;

        public ServiceInitializationException(String message, ServiceEndpointInfo serviceEndpointInfo) {
            super(message);
            this._serviceEndpointInfo = serviceEndpointInfo;
        }

        public ServiceInitializationException(String message, ServiceEndpointInfo serviceEndpointInfo, Throwable cause) {
            super(message, cause);
            this._serviceEndpointInfo = serviceEndpointInfo;
        }

        public ServiceEndpointInfo getServiceEndpointInfo() {
            return this._serviceEndpointInfo;
        }
    }

    static class VcGroupsRegistryProvider {
        private final LookupService lookupService;
        private final ServiceEndpointLocator serviceEndpointLocator;
        private final LinkedVcGroupFactory linkedVcGroupFactory;
        private final HomeLduFactory homeLduFactory;
        private final ConfigurationService configurationService;

        public VcGroupsRegistryProvider(LookupService lookupService, ServiceEndpointLocator serviceEndpointLocator, LinkedVcGroupFactory linkedVcGroupFactory, HomeLduFactory homeLduFactory, ConfigurationService configurationService) {
            this.lookupService = lookupService;
            this.serviceEndpointLocator = serviceEndpointLocator;
            this.linkedVcGroupFactory = linkedVcGroupFactory;
            this.homeLduFactory = homeLduFactory;
            this.configurationService = configurationService;
        }

        public LinkedVcGroupRegistry getLinkedVcGroupRegistry(SsoDomain domainWhichIssuedTheToken, SamlToken token, PrivateKey privateKey, String userName) {
            logger.debug("findTargetVcService for " + token.getSubject() + " solutionUser on behalf of userName = " + userName);
            String serviceHomeLdu = this.homeLduFactory.getHomeLdu(this.lookupService);
            ServiceEndpointInfo vcEndpoint = this.findVcServiceEndpoint(serviceHomeLdu);
            ServiceEndpointInfo invEndpoint = this.findISServiceEndpoint(serviceHomeLdu);
            LoginSpec loginSpec = this.buildLoginSpec(serviceHomeLdu, vcEndpoint, invEndpoint, userName, token, domainWhichIssuedTheToken, privateKey, Locale.US);
            try {
                logger.debug("creating LinkedVcGroupImpl");
                LinkedVcGroup linkedVcGroup = this.linkedVcGroupFactory.create(loginSpec);
                logger.debug("LinkedVcGroupImpl created. Logging in.");
                linkedVcGroup.login();
                logger.debug("LinkedVcGroupImpl successfully logged in. Adding it to LinkedVcGroupRegistry.");
                LinkedVcGroupRegistryImpl registry = new LinkedVcGroupRegistryImpl();
                LinkedVcGroupRegistry.StartupGroupUtils utils = registry.getUtils();
                utils.addStartupLinkedVcGroup(linkedVcGroup);
                return registry;
            }
            catch (Exception e) {
                String message = "Exception occurred while locating TargetVCService " + vcEndpoint.toString() + " As a result session cannot be simulated, since there is no VC to work with. For more details see the underlying exception: " + e.getMessage();
                logger.error(message, (Throwable)e);
                throw new ServiceInitializationException(message, vcEndpoint, e);
            }
        }

        private ServiceEndpointInfo findISServiceEndpoint(String serviceHomeLdu) {
            ServiceEndpointInfo invEndpoint = null;
            String errorMsg = "No InventoryService records found in LDU " + serviceHomeLdu + ". Continue to work without InventoryService source. This may result in inability of DataService to collect certain types of data.";
            try {
                invEndpoint = this.serviceEndpointLocator.findServiceEndpointInfo(ServiceEndpointType.IS, serviceHomeLdu);
                if (invEndpoint == null) {
                    logger.warn(errorMsg);
                }
            }
            catch (Exception e) {
                logger.warn(errorMsg + " For further details see the underlying exception: " + e.getMessage(), (Throwable)e);
            }
            return invEndpoint;
        }

        private ServiceEndpointInfo findVcServiceEndpoint(String serviceHomeLdu) {
            ServiceEndpointInfo vcEndpoint = this.serviceEndpointLocator.findServiceEndpointInfo(ServiceEndpointType.VC, serviceHomeLdu);
            if (vcEndpoint == null) {
                throw new RuntimeException("No VC records found in LDU=" + serviceHomeLdu + " As a result a DataService session with logged-in VcService object in it cannot be simulated. Please file a SR for issue with the Customer Experience Improvement Program (CEIP)");
            }
            return vcEndpoint;
        }

        private LoginSpec buildLoginSpec(String homeLdu, ServiceEndpointInfo vcInfo, ServiceEndpointInfo invSvcInfo, String userName, SamlToken token, SsoDomain domainWhichIssuedTheToken, PrivateKey privateKey, Locale locale) {
            ServiceEndpointEx[] serviceEndpointExArray;
            ServiceEndpointEx invSvcEndpoint;
            SsoDomain vcSsoDomain = vcInfo.getSsoDomain();
            if (invSvcInfo != null) {
                Validate.isTrue((boolean)invSvcInfo.getSsoDomain().equals((Object)vcSsoDomain), (String)("VC domain: " + vcSsoDomain + ", IS domanin: " + invSvcInfo.getSsoDomain()), (Object[])new Object[0]);
            }
            SamlTokenEx tokenEx = new SamlTokenEx(token, domainWhichIssuedTheToken, privateKey);
            ImmutableSingleDomainNonRenewingTokenProvider tokenProvider = new ImmutableSingleDomainNonRenewingTokenProvider(vcSsoDomain, tokenEx);
            LoginSpec loginSpec = new LoginSpec();
            loginSpec.ssoDomain = vcSsoDomain;
            loginSpec.nodeId = vcInfo.getNodeId();
            loginSpec.userName = userName;
            loginSpec.tokenProvider = tokenProvider;
            loginSpec.locale = locale.toString();
            loginSpec.serviceUrl = vcInfo.getServiceUrl().toString();
            loginSpec.serviceGuid = vcInfo.getServiceGuid();
            loginSpec.vmodlVersion = this.vmodlVersion();
            ServiceEndpointEx vcEndpoint = ServiceEndpointEx.buildVcServiceEndpoint((SsoDomain)vcSsoDomain, (String)homeLdu, (String)loginSpec.serviceGuid, (String)vcInfo.getInstanceName(), (String)loginSpec.serviceUrl, (String)vcInfo.getCertificate());
            ServiceEndpointEx serviceEndpointEx = invSvcEndpoint = invSvcInfo == null ? null : ServiceEndpointEx.buildInventoryServiceEndpoint((SsoDomain)vcSsoDomain, (String)homeLdu, (String)vcInfo.getServiceGuid(), (String)invSvcInfo.getServiceGuid(), (String)invSvcInfo.getServiceUrl().toString(), (String)invSvcInfo.getCertificate());
            if (invSvcEndpoint == null) {
                ServiceEndpointEx[] serviceEndpointExArray2 = new ServiceEndpointEx[1];
                serviceEndpointExArray = serviceEndpointExArray2;
                serviceEndpointExArray2[0] = vcEndpoint;
            } else {
                ServiceEndpointEx[] serviceEndpointExArray3 = new ServiceEndpointEx[2];
                serviceEndpointExArray3[0] = vcEndpoint;
                serviceEndpointExArray = serviceEndpointExArray3;
                serviceEndpointExArray3[1] = invSvcEndpoint;
            }
            loginSpec.endpoints = serviceEndpointExArray;
            return loginSpec;
        }

        private Class<?> vmodlVersion() {
            boolean useUnstableVmodl = PropertyUtil.getBooleanProperty((ConfigurationService)this.configurationService, (String)"use.unstable.vmodl", (boolean)false);
            if (useUnstableVmodl) {
                return versions.VIM_VERSION_NEWEST;
            }
            return versions.VIM_VERSION_LTS;
        }

        static class HomeLduFactory {
            HomeLduFactory() {
            }

            public String getHomeLdu(LookupService lookupService) {
                return lookupService.getLocalHostNodeId();
            }
        }

        static class ServiceEndpointLocator {
            private final LookupService lookupService;

            public ServiceEndpointLocator(LookupService lookupService) {
                this.lookupService = lookupService;
            }

            public ServiceEndpointInfo findServiceEndpointInfo(ServiceEndpointType serviceType, String serviceLdu) {
                ServiceEndpointInfo endpointInfo;
                String endpointType;
                ServiceRegistration.ServiceType serviceTypeDesc;
                logger.debug("findServiceEndpointInfo for serviceType={} and serviceLdu={}", (Object)serviceType.name(), (Object)serviceLdu);
                switch (serviceType) {
                    case VC: {
                        serviceTypeDesc = new ServiceRegistration.ServiceType("com.vmware.cis", "vcenterserver");
                        endpointType = "com.vmware.vim";
                        break;
                    }
                    case IS: {
                        serviceTypeDesc = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.inventory");
                        endpointType = "com.vmware.cis.inventory";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("BUG: findServiceEndpointInfo() for unsupported type: " + serviceType);
                    }
                }
                ServiceRegistration.Info svcInfo = this.findServiceInLdu(serviceTypeDesc, serviceLdu);
                if (svcInfo != null) {
                    ServiceRegistration.Endpoint svcEndpoint = ServiceEndpointLocator.findEndpoint(svcInfo, endpointType);
                    SsoDomain ssoDomain = (SsoDomain)LookupUtil.getSsoDomain((ServiceRegistration.Info)svcInfo).orElse((Object)SsoDomainHelper.getLocal());
                    String nodeId = svcInfo.getNodeId();
                    String instanceName = ServiceEndpointLocator.getServiceAttr(svcInfo, "com.vmware.vim.vcenter.instanceName");
                    endpointInfo = new ServiceEndpointInfo(ssoDomain, nodeId, serviceType, svcInfo.getServiceId(), instanceName, svcEndpoint.getUrl(), null);
                } else {
                    endpointInfo = null;
                }
                return endpointInfo;
            }

            private ServiceRegistration.Info findServiceInLdu(ServiceRegistration.ServiceType serviceType, String lduGuid) {
                ServiceRegistration.Filter filterCriteria = new ServiceRegistration.Filter();
                filterCriteria.setServiceType(serviceType);
                filterCriteria.setNodeId(lduGuid);
                filterCriteria.setSearchAllSsoDomains(Boolean.valueOf(true));
                ServiceRegistration.Info[] foundServices = this.lookupService.getServiceRegistrationInfos(filterCriteria);
                foundServices = foundServices == null ? new ServiceRegistration.Info[]{} : foundServices;
                logger.debug("LookupService returned {} services for filterCriteria={}", (Object)foundServices.length, (Object)filterCriteria);
                ServiceRegistration.Info result = null;
                if (foundServices.length == 0) {
                    logger.warn("No services found while searching for service {}:{} - LookupService returned empty list. For further details look in LookupService logs.", (Object)serviceType.getProduct(), (Object)serviceType.getType());
                } else {
                    result = foundServices[0];
                    logger.debug("Found service with nodeId={} that matches lduGuid={}.", (Object)result.getNodeId(), (Object)lduGuid);
                }
                return result;
            }

            private static ServiceRegistration.Endpoint findEndpoint(ServiceRegistration.Info serviceInfo, String soughtEndpointTypeId) {
                ServiceRegistration.Endpoint[] endpoints = serviceInfo.getServiceEndpoints();
                if (endpoints != null) {
                    for (ServiceRegistration.Endpoint endpoint : endpoints) {
                        String currentEndpointTypeId = endpoint.getEndpointType().getType();
                        if (!soughtEndpointTypeId.equals(currentEndpointTypeId)) continue;
                        return endpoint;
                    }
                }
                throw new RuntimeException("Can't find endpoint type '" + soughtEndpointTypeId + "' in " + serviceInfo.getClass().getSimpleName() + " " + serviceInfo.getServiceId());
            }

            static String getServiceAttr(ServiceRegistration.Info info, String key) {
                if (info != null && info.getServiceAttributes() != null) {
                    for (ServiceRegistration.Attribute serviceAttribute : info.getServiceAttributes()) {
                        if (!key.equals(serviceAttribute.getKey()) || serviceAttribute.getValue() == null) continue;
                        return serviceAttribute.getValue();
                    }
                }
                return null;
            }
        }
    }
}

