/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.authentication;

import com.vmware.ph.ceip.authentication.InitializationException;
import com.vmware.ph.ceip.authentication.StsCertificatesManager;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.SsoService;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

public final class StsCertificatesManagerImpl
implements StsCertificatesManager {
    private final SsoService _ssoService;
    private final Lock _trustedStsCertificatesLock = new ReentrantLock();
    @GuardedBy(value="_trustedStsCertificatesLock")
    private volatile List<X509Certificate> _trustedStsCertificates;

    public StsCertificatesManagerImpl(SsoService ssoService) {
        this._ssoService = ssoService;
    }

    @Override
    @GuardedBy(value="_trustedStsCertificatesLock")
    public List<X509Certificate> getStsCertificates() {
        if (this._trustedStsCertificates == null) {
            this.downloadStsCertificates(false);
        }
        return this._trustedStsCertificates;
    }

    @Override
    @GuardedBy(value="_trustedStsCertificatesLock")
    public List<X509Certificate> refetchStsCertificates() {
        this.downloadStsCertificates(true);
        return this._trustedStsCertificates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadStsCertificates(boolean refetch) {
        try {
            this._trustedStsCertificatesLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InitializationException("Interrupted while trying to fetch the STS trusted certificates", e);
        }
        try {
            if (!refetch && this._trustedStsCertificates != null) {
                return;
            }
            X509Certificate[] certificates = this._ssoService.getStsIssuersCertificates(SsoDomainHelper.getLocal());
            if (certificates == null && this._trustedStsCertificates == null) {
                throw new InitializationException("CIS DS service failed to retrieve the SSO trusted certificates. Please, check the log and see if the SsoService has initialized successfully and whether it crashed while fetching the certificates.");
            }
            List<X509Certificate> certList = Arrays.asList(certificates);
            certList = Collections.unmodifiableList(certList);
            this._trustedStsCertificates = certList;
        }
        finally {
            this._trustedStsCertificatesLock.unlock();
        }
    }
}

