/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.ceip.impl;

import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.SamlTokenEx;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.phonehome.data.ConsentConfigurationData;
import com.vmware.vim.binding.phonehome.service.ConsentConfigurationService;
import com.vmware.vim.binding.phonehome.version.version1;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vise.util.sidecar.SidecarUrlService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vsphere.client.ceip.CeipService;
import com.vmware.vsphere.client.ceip.util.CeipUtil;
import java.net.URI;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcsMoCeipServiceImpl
implements CeipService {
    static final String CCS_MO_SDK_ENDPOINT_TYPE = "com.vmware.ph.ceip.sdk";
    static final String CCS_MO_SDK_ENDPOINT_PROTOCOL = "vmomi";
    private static final String CCS_MO_ID = "ccService";
    private static final int VLSI_CLIENT_TIMEOUT_MS = 180000;
    private static final Logger _logger = LoggerFactory.getLogger(CcsMoCeipServiceImpl.class);
    private final LookupService _lookupService;
    private final KeystoreService _keystoreService;
    private final NodeIdProvider _nodeIdProvider;
    private final SidecarUrlService _sidecarUrlService;
    private VmodlContext _vmodlContext;

    public CcsMoCeipServiceImpl(LookupService lookupService, KeystoreService keystoreService, SidecarUrlService sidecarUrlService) {
        this(lookupService, keystoreService, new NodeIdProvider(), null, sidecarUrlService);
    }

    CcsMoCeipServiceImpl(LookupService lookupService, KeystoreService keystoreService, NodeIdProvider nodeIdProvider, VmodlContext vmodlContext, SidecarUrlService sidecarUrlService) {
        this._lookupService = lookupService;
        this._keystoreService = keystoreService;
        this._nodeIdProvider = nodeIdProvider;
        this._vmodlContext = vmodlContext;
        this._sidecarUrlService = sidecarUrlService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserCeipAuthorized() {
        URI ccsSdkUri = this.findCcsSdkUri();
        if (ccsSdkUri == null) {
            _logger.info("Consent Configuration Service cannot be discovered. User is considered unauthorized");
            return false;
        }
        Client ccsClient = this.createCcsClient(ccsSdkUri);
        try {
            ConsentConfigurationService ccs = this.createAuthenticatedCcsStub(ccsClient);
            ccs.validatePrivilegeForSet();
            boolean bl = true;
            return bl;
        }
        catch (SecurityError e) {
            _logger.info("The current user does not have permissions to change CEIP. {}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            _logger.warn("Failed to obtain a ConsentConfigurationService client stub.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            ccsClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCollectionEnabled() {
        URI ccsSdkUri = this.findCcsSdkUri();
        if (ccsSdkUri == null) {
            _logger.info("Consent Configuration Service cannot be discovered. Consent is considered 'false'.");
            return false;
        }
        boolean isConsentAccepted = false;
        Client ccsClient = this.createCcsClient(ccsSdkUri);
        try {
            ConsentConfigurationService ccs = this.createAuthenticatedCcsStub(ccsClient);
            ConsentConfigurationData ccData = ccs.get();
            _logger.debug("Consent data read from Consent Configuration Service {}", (Object)ccData);
            isConsentAccepted = CeipUtil.isCeipConsentAccepted(ccData);
        }
        catch (Exception e) {
            _logger.warn("Failed to read consent data.", (Throwable)e);
        }
        finally {
            ccsClient.shutdown();
        }
        return isConsentAccepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCollectionEnabled(boolean enabled) {
        URI ccsSdkUri = this.findCcsSdkUri();
        if (ccsSdkUri == null) {
            _logger.info("Consent Configuration Service cannot be discovered. Current consent will not be changed.");
            return;
        }
        Client ccsClient = this.createCcsClient(ccsSdkUri);
        try {
            ConsentConfigurationService ccs = this.createAuthenticatedCcsStub(ccsClient);
            _logger.debug("Setting consent accepted state to '{}'.", (Object)enabled);
            ConsentConfigurationData ccData = CeipUtil.createConsentConfigurationDataForConsentState(enabled);
            ccs.set(ccData);
        }
        catch (Exception e) {
            _logger.warn("Failed to write consent data.", (Throwable)e);
        }
        finally {
            ccsClient.shutdown();
        }
    }

    @Override
    public boolean isActive() {
        URI ccsSdkUri = this.findCcsSdkUri();
        boolean isActive = false;
        if (ccsSdkUri != null) {
            isActive = true;
        }
        _logger.debug("The active state for {} is '{}'.", (Object)CcsMoCeipServiceImpl.class.getSimpleName(), (Object)isActive);
        return isActive;
    }

    Client createCcsClient(URI ccsSdkUri) {
        this.initVmodlContext();
        Client client = Client.Factory.createClient((URI)ccsSdkUri, version1.class, (VmodlContext)this._vmodlContext, (ClientConfiguration)CcsMoCeipServiceImpl.createCcsClientHttpConfiguration(this._keystoreService));
        return client;
    }

    ConsentConfigurationService createAuthenticatedCcsStub(Client ccsClient) throws Exception {
        SamlTokenEx samlTokenEx = AuthSessionUtil.getSsoTokenEx((SsoDomain)SsoDomainHelper.getLocal());
        SamlToken samlToken = samlTokenEx.getToken();
        PrivateKey privateKey = samlTokenEx.getPrivateKey().orElse(null);
        return this.createConsentConfigurationServiceStub(ccsClient, samlToken, privateKey);
    }

    private URI findCcsSdkUri() {
        String nodeId = this._nodeIdProvider.getNodeId(this._lookupService);
        ServiceRegistration.EndpointType ccsEndpointType = new ServiceRegistration.EndpointType(CCS_MO_SDK_ENDPOINT_PROTOCOL, CCS_MO_SDK_ENDPOINT_TYPE);
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setNodeId(nodeId);
        filter.setEndpointType(ccsEndpointType);
        ServiceRegistration.Info[] servceInfos = this._lookupService.getServiceRegistrationInfos(filter);
        if (servceInfos == null) {
            return null;
        }
        ServiceRegistration.Info ccsInfo = servceInfos[0];
        ServiceRegistration.Endpoint ccsEndpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)ccsInfo, (String)ccsEndpointType.getType());
        URI ccsEndpointUri = null;
        if (ccsEndpoint != null) {
            ccsEndpointUri = this._sidecarUrlService.createSidecarUrl(ccsEndpoint.getUrl(), SidecarUrlService.CertificateAuthority.VECS);
        }
        return ccsEndpointUri;
    }

    private void initVmodlContext() {
        if (this._vmodlContext != null) {
            return;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ConsentConfigurationService.class.getClassLoader());
            VmodlContext ctx = VmodlContext.createContext((String[])new String[]{"com.vmware.vim.binding.phonehome"}, (boolean)true);
            Thread.currentThread().setContextClassLoader(ServiceRegistration.class.getClassLoader());
            ctx.loadVmodlPackages(new String[]{"com.vmware.vim.binding.lookup"}, true);
            this._vmodlContext = ctx;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private ConsentConfigurationService createConsentConfigurationServiceStub(Client ccsClient, SamlToken samlToken, PrivateKey privateKey) throws Exception {
        this.initVmodlContext();
        String ccsWsdlName = this._vmodlContext.getVmodlTypeMap().getVmodlType(ConsentConfigurationService.class).getWsdlName();
        ManagedObjectReference ccsMoRef = new ManagedObjectReference(ccsWsdlName, CCS_MO_ID);
        ConsentConfigurationService ccs = (ConsentConfigurationService)CcsMoCeipServiceImpl.createStub(ccsClient, this._vmodlContext, ccsMoRef);
        CcsMoCeipServiceImpl.addAuthenticationToStub(ccs, samlToken, privateKey);
        return ccs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends ManagedObject> T createStub(Client ccsClient, VmodlContext vmodlContext, ManagedObjectReference moRef) throws Exception {
        VmodlType vmodlType = vmodlContext.getVmodlTypeMap().getVmodlType(moRef.getType());
        Class typeClass = vmodlType.getTypeClass();
        ManagedObject managedObject = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CcsMoCeipServiceImpl.class.getClassLoader());
            managedObject = ccsClient.createStub(typeClass, moRef);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return (T)managedObject;
    }

    private static <T extends ManagedObject> void addAuthenticationToStub(T stub, SamlToken samlToken, PrivateKey privateKey) {
        if (samlToken == null || privateKey == null) {
            return;
        }
        RequestContextImpl requestContext = new RequestContextImpl();
        SignInfoImpl signInfo = new SignInfoImpl(privateKey, samlToken);
        requestContext.setSignInfo((SignInfo)signInfo);
        ((Stub)stub)._setRequestContext((RequestContext)requestContext);
    }

    private static HttpClientConfiguration createCcsClientHttpConfiguration(KeystoreService keystoreService) {
        HttpConfigurationImpl httpConfig = new HttpConfigurationImpl();
        httpConfig.setTrustStore(keystoreService.getKeyStore());
        httpConfig.setCheckStaleConnection(true);
        httpConfig.setTimeoutMs(180000);
        HttpClientConfiguration httpClientConfig = HttpClientConfiguration.Factory.newInstance();
        httpClientConfig.setHttpConfiguration((HttpConfiguration)httpConfig);
        return httpClientConfig;
    }

    static class NodeIdProvider {
        NodeIdProvider() {
        }

        public String getNodeId(LookupService lookupService) {
            return lookupService.getLocalHostNodeId();
        }
    }
}

