/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.ceip.util;

import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    static final String NO_VC_SERVICES_ERROR = "Session contains no VC services with LDU = '%s' (this indicates connection, login or permission failure.)";
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static VcService getVcService(LinkedVcGroupRegistry vcGroupRegistry, String lduGuid) {
        logger.debug("Getting VcService from LinkedVcGroupRegistry");
        VcService vcService = Utils.findFirst(lduGuid, vcGroupRegistry.getLinkedVcGroups());
        if (vcService == null) {
            String msg = String.format(NO_VC_SERVICES_ERROR, lduGuid);
            logger.debug(msg);
            throw new RuntimeException(msg);
        }
        return vcService;
    }

    private static VcService findFirst(String lduGuid, LinkedVcGroup[] vcGroups) {
        logger.debug("Getting VcService from LinkedVcGroup[] for the following lduGuid: '{}'", (Object)lduGuid);
        VcService result = null;
        for (LinkedVcGroup linkedVcGroup : vcGroups) {
            result = Utils.findFirst(lduGuid, linkedVcGroup.getVcServices());
            if (result == null) continue;
            logger.debug("Found VcService in ldu={} with serviceId={}", (Object)lduGuid, (Object)result.getServiceGuid());
            return result;
        }
        logger.debug("Couldn't find VcService in LinkedVcGroup[] with lduGuid='{}'. Returning null", (Object)lduGuid);
        return null;
    }

    private static VcService findFirst(String lduGuid, Collection<VcService> vcServices) {
        logger.debug("Searching for VcService in Collection<VcService> with lduGuid='{}'", (Object)lduGuid);
        for (VcService vcService : vcServices) {
            if (!StringUtils.isNotBlank((String)vcService.getServiceGuid())) continue;
            logger.trace("Looking in VcService with ServiceGuid='{}'", (Object)vcService.getServiceGuid());
            ServiceEndpointEx[] serviceEndPoints = vcService.getServiceEndPoints();
            ServiceEndpointEx foundEndPoint = Utils.findFirst(lduGuid, vcService.getServiceGuid(), serviceEndPoints);
            if (foundEndPoint == null) continue;
            logger.debug("Successfully got VcService with the following ServiceGuid: {}", (Object)vcService.getServiceGuid());
            return vcService;
        }
        logger.debug("Couldn't find VcService in Collection<VcService> with lduGuid='{}'. Returning null", (Object)lduGuid);
        return null;
    }

    private static ServiceEndpointEx findFirst(String lduGuid, String vcServiceGuid, ServiceEndpointEx[] serviceEndPoints) {
        logger.debug("Searching for ServiceEndpointEx in ServiceEndpointEx[] with lduGuid='{}' and ServiceGuid='{}'", (Object)lduGuid, (Object)vcServiceGuid);
        for (ServiceEndpointEx serviceEP : serviceEndPoints) {
            logger.trace("serviceEP.getLduGuid()='{}' and ServiceGuid='{}'", (Object)serviceEP.getLduGuid(), (Object)serviceEP.getInstanceUuid());
            if (serviceEP.getLduGuid() == null || !serviceEP.getLduGuid().toLowerCase().equals(lduGuid.toLowerCase()) || serviceEP.getInstanceUuid() == null || !serviceEP.getInstanceUuid().toLowerCase().equals(vcServiceGuid.toLowerCase())) continue;
            logger.debug(String.format("Found ServiceEndpointEx.URL ='%s' with lduGuid='%s' and ServiceGuid='%s'", serviceEP.url, lduGuid, vcServiceGuid));
            return serviceEP;
        }
        logger.debug("Couldn't find ServiceEndpointEx with lduGuid='{}' and ServiceGuid='{}'. Returning null", (Object)lduGuid, (Object)vcServiceGuid);
        return null;
    }
}

