/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.admin.sddc.link;

import com.vmware.bifrost.bridge.Request;
import com.vmware.bifrost.bus.BusTransaction;
import com.vmware.bifrost.bus.EventBus;
import com.vmware.cis.task.Info;
import com.vmware.vise.vim.messaging.BifrostRequestHandler;
import com.vmware.vise.vim.messaging.BifrostService;
import com.vmware.vise.vim.messaging.marshall.Marshaller;
import com.vmware.vise.vim.tasks.TaskMonitorSpec;
import com.vmware.vsphere.client.admin.sddc.link.spec.SddcTaskUpdate;
import com.vmware.vsphere.client.cis.tasks.VapiTaskMonitor;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SddcBifrostSubscriptionService
implements BifrostRequestHandler,
BifrostService {
    private static final Log _logger = LogFactory.getLog(SddcBifrostSubscriptionService.class);
    public static final String SDDC_TASKS_PREFIX = "sddc-tasks.";
    public static final String MONITOR_TASK_REQUEST = "monitorTask";
    private static final long TASK_MONITOR_POLLING_INTERVAL = TimeUnit.SECONDS.toMillis(2L);
    private static final long TASK_MONITOR_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    private final EventBus _eventBus;
    private final Marshaller _marshaller;
    private final VapiTaskMonitor _taskMonitor;

    public SddcBifrostSubscriptionService(EventBus eventBus, Marshaller marshaller, VapiTaskMonitor taskMonitor) {
        this._eventBus = eventBus;
        this._marshaller = marshaller;
        this._taskMonitor = taskMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(String channel, String clientId, final Request request) {
        if (MONITOR_TASK_REQUEST.equals(request.getRequest())) {
            String taskUid = request.getPayload().toString();
            TaskMonitorSpec spec = new TaskMonitorSpec();
            spec.intervalInMillis = TASK_MONITOR_POLLING_INTERVAL;
            spec.timeoutInMillis = TASK_MONITOR_TIMEOUT;
            final BusTransaction transaction = this._eventBus.respondStream(channel, null);
            try {
                this._taskMonitor.monitorTask(taskUid, spec, new Consumer<Info>(){

                    @Override
                    public void accept(Info taskInfo) {
                        SddcTaskUpdate taskUpdate = SddcTaskUpdate.newSddcTaskUpdate(request.getId(), taskInfo);
                        SddcBifrostSubscriptionService.this.sendTaskUpdate(taskUpdate, transaction);
                    }
                });
            }
            catch (TimeoutException ex) {
                _logger.error((Object)ex);
                SddcTaskUpdate taskUpdate = SddcTaskUpdate.newSddcTaskTimeoutUpdate(request.getId(), ex.getMessage());
                this.sendTaskUpdate(taskUpdate, transaction);
            }
            finally {
                transaction.unsubscribe();
            }
        }
    }

    private void sendTaskUpdate(SddcTaskUpdate taskUpdate, BusTransaction transaction) {
        try {
            transaction.tick((Object)this._marshaller.marshall((Object)taskUpdate));
        }
        catch (IOException ex) {
            _logger.error((Object)ex);
        }
    }

    public void handleNewSubscription(String channel, String clientId) {
    }
}

