/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.admin.sddc.link;

import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.std.errors.OperationNotFound;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.hlm.Community;
import com.vmware.vcenter.hlm.CommunityTypes;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.TokenRequestRejectedException;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.admin.sddc.link.SddcLinkStsTokenProvider;
import com.vmware.vsphere.client.admin.sddc.link.spec.SddcLinkSpec;
import com.vmware.vsphere.client.admin.sddc.link.spec.SddcLinkTokenValidationResult;
import com.vmware.vsphere.client.admin.sddc.link.spec.SddcLinkTokenValidationSpec;
import com.vmware.vsphere.client.admin.sddc.link.spec.SddcUnlinkSpec;
import com.vmware.vsphere.client.commonservice.util.Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SddcLinkMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(SddcLinkMutationProvider.class);
    private static final String DEFAULT_SSL_PORT = "443";
    private final SddcLinkStsTokenProvider _tokenProvider;
    private final Community _hlmCommunityService;

    public SddcLinkMutationProvider(SddcLinkStsTokenProvider tokenProvider, Community hlmCommunityService) {
        this._tokenProvider = tokenProvider;
        this._hlmCommunityService = hlmCommunityService;
    }

    public ValidationResult validate(SddcLinkTokenValidationSpec spec) throws InvalidTokenException, IOException, TokenRequestRejectedException, URISyntaxException, NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        char[] password = spec.password != null ? spec.password.toCharArray() : null;
        spec.password = "***";
        _logger.info((Object)String.format("validate, spec = %s", ObjectUtil.prettyPrint((Object)spec)));
        ValidationResult result = new ValidationResult();
        try {
            String newToken;
            String fqdnHostname = this.getFQDNHostname(spec.hostname);
            _logger.info((Object)String.format("validate, resolved hostname = %s to fqdn = %s", spec.hostname, fqdnHostname));
            SddcLinkTokenValidationResult tokenValidationResult = new SddcLinkTokenValidationResult();
            tokenValidationResult.token = newToken = this._tokenProvider.acquireToken(fqdnHostname, spec.username, password, spec.trustedThumbprint, spec.tsTrustedThumbprint);
            tokenValidationResult.trustedThumbprint = spec.trustedThumbprint != null ? spec.trustedThumbprint : this._tokenProvider.getThumbprint(fqdnHostname);
            result.result = tokenValidationResult;
        }
        catch (OperationNotFound e) {
            result.error = new Exception(Util.getLocalizedString("sddc.noncloudvc.error", spec.hostname));
        }
        catch (UnknownHostException e) {
            result.error = new Exception(Util.getLocalizedString("sddc.unknownHost.error", spec.hostname));
        }
        catch (CertificateValidationException e) {
            _logger.info((Object)String.format("validate, expected CertificateValidationException encountered, message = %s", e.getMessage()));
            result.error = e;
        }
        return result;
    }

    public ValidationResult validate(SddcLinkSpec spec) {
        ValidationResult result = new ValidationResult();
        try {
            String authToken = this.getAuthToken(spec);
            CommunityTypes.AddSpec addSpec = this.getAddSpec(spec, authToken);
            CommunityTypes.AddCheckSpec addCheckSpec = new CommunityTypes.AddCheckSpec();
            addCheckSpec.setAddSpec(addSpec);
            addCheckSpec.setCheckAll(true);
            result.result = this._hlmCommunityService.check(addCheckSpec, this.getInvocationConfig());
        }
        catch (Exception e) {
            _logger.error((Object)"Add SDDC preflight checks failed", (Throwable)e);
            result.error = e;
        }
        return result;
    }

    public OperationResult add(SddcLinkSpec spec) {
        OperationResult result = new OperationResult();
        try {
            String taskId;
            String authToken = this.getAuthToken(spec);
            CommunityTypes.AddSpec addSpec = this.getAddSpec(spec, authToken);
            result.taskUid = taskId = this._hlmCommunityService.add_Task(addSpec, this.getInvocationConfig());
            _logger.info((Object)String.format("Add SDDC initiated, spec = %s, result = %s", ObjectUtil.prettyPrint((Object)spec), ObjectUtil.prettyPrint((Object)result)));
        }
        catch (Exception e) {
            _logger.error((Object)"Add SDDC failed", (Throwable)e);
            result.error = e;
        }
        return result;
    }

    public OperationResult remove(URI resourceUri, SddcUnlinkSpec unlinkSpec) {
        String taskId = this._hlmCommunityService.remove_Task(unlinkSpec.hostname, this.getInvocationConfig());
        OperationResult result = new OperationResult();
        result.taskUid = taskId;
        _logger.info((Object)String.format("Remove SDDC initiated, spec = %s, result = %s", ObjectUtil.prettyPrint((Object)unlinkSpec), ObjectUtil.prettyPrint((Object)result)));
        return result;
    }

    private CommunityTypes.AddSpec getAddSpec(SddcLinkSpec spec, String authToken) {
        CommunityTypes.AddSpec addSpec = new CommunityTypes.AddSpec();
        addSpec.setHostname(spec.hostname);
        addSpec.setPort(DEFAULT_SSL_PORT);
        addSpec.setToken("sign=" + authToken);
        addSpec.setSslThumbprint(spec.trustedThumbprint);
        addSpec.setSslVerify(Boolean.valueOf(true));
        return addSpec;
    }

    private InvocationConfig getInvocationConfig() {
        SsoDomain localDomain = SsoDomainHelper.getLocal();
        return VapiUtil.newInvocationConfig((SsoDomain)localDomain);
    }

    private String getFQDNHostname(String hostname) throws UnknownHostException {
        return InetAddress.getByName(hostname).getHostName();
    }

    private String getAuthToken(SddcLinkSpec spec) throws IOException, CertificateException, NoSuchAlgorithmException, URISyntaxException, InvalidTokenException, CertificateValidationException, KeyManagementException, KeyStoreException, TokenRequestRejectedException {
        char[] password = spec.password != null ? spec.password.toCharArray() : null;
        spec.password = "***";
        return this._tokenProvider.acquireToken(this.getFQDNHostname(spec.hostname), spec.username, password, spec.trustedThumbprint, spec.trustedThumbprint);
    }
}

