/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.admin.sddc.link;

import com.vmware.vapi.client.exception.InvalidSslCertificateException;
import com.vmware.vapi.client.exception.SslException;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vcenter.settings.Namespaces;
import com.vmware.vim.sso.client.DefaultSecurityTokenServiceFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.TokenRequestRejectedException;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.util.sidecar.SidecarUrlService;
import com.vmware.vise.vim.vapi.StaticEndpointVapiConnectionManagerFactory;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.commonservice.util.CertificateExtendedUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SddcLinkStsTokenProvider {
    private static final Log _logger = LogFactory.getLog(SddcLinkStsTokenProvider.class);
    private static final long TOKEN_LIFETIME_SECS = 300L;
    private static final String FAKE_THUMBPRINT = "1234567890123456789012345678901234567890";
    private StaticEndpointVapiConnectionManagerFactory _vapiConnectionManagerFactory;
    private SidecarUrlService _sidecarUrlService;

    public SddcLinkStsTokenProvider(StaticEndpointVapiConnectionManagerFactory vapConnectionManagerFactory, SidecarUrlService sidecarUrlService) {
        _logger.info((Object)"instantiated");
        this._vapiConnectionManagerFactory = vapConnectionManagerFactory;
        this._sidecarUrlService = sidecarUrlService;
    }

    public String acquireToken(String hostname, String username, char[] password, String trustedThumbprint, String stsTrustedThumbprint) throws InvalidTokenException, IOException, CertificateValidationException, TokenRequestRejectedException, URISyntaxException, NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        SamlToken token = this.acquireSamlToken(hostname, username, password, trustedThumbprint, stsTrustedThumbprint);
        byte[] base64Token = Base64.encodeBase64((byte[])token.toXml().getBytes());
        return new String(base64Token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SamlToken acquireSamlToken(String hostname, String username, char[] password, String trustedThumbprint, String stsTrustedThumbprint) throws URISyntaxException, IOException, CertificateValidationException, InvalidTokenException, TokenRequestRejectedException, NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        try (InternalVapiServiceClient vapiServiceClient = null;){
            _logger.info((Object)String.format("acquireSamlToken, constructing anonymous VAPI client, hostname = %s", hostname));
            vapiServiceClient = this.newAnonymousVapiServiceClient(hostname, trustedThumbprint);
            _logger.info((Object)String.format("acquireSamlToken, probing for STS endpoint...", new Object[0]));
            URI stsUri = vapiServiceClient.getStsUri();
            URI stsSidecarUri = trustedThumbprint != null ? this._sidecarUrlService.createSidecarUrlValidatedByThumbprint(stsUri, trustedThumbprint) : this._sidecarUrlService.createSidecarUrl(stsUri, SidecarUrlService.CertificateAuthority.OS);
            _logger.info((Object)"acquireSamlToken, constructing STS client...");
            SecurityTokenService sts = this.newStsService(stsSidecarUri, stsTrustedThumbprint != null ? stsTrustedThumbprint : trustedThumbprint);
            TokenSpec tokenSpec = new TokenSpec.Builder(300L).delegationSpec(new TokenSpec.DelegationSpec(true)).createTokenSpec();
            _logger.info((Object)"acquireSamlToken, acquiring STS token...");
            SamlToken token = sts.acquireToken(username, new String(password), tokenSpec);
            _logger.info((Object)String.format("acquireSamlToken, acquiring STS token for user %s done", username));
            SamlToken samlToken = token;
            return samlToken;
        }
    }

    private SecurityTokenService newStsService(URI stsUri, String trustedCertThumbprint) throws MalformedURLException {
        SecurityTokenServiceConfig.ConnectionConfig connectionConfig = new SecurityTokenServiceConfig.ConnectionConfig(stsUri.toURL(), null, trustedCertThumbprint);
        SecurityTokenService result = DefaultSecurityTokenServiceFactory.getSecurityTokenService((SecurityTokenServiceConfig)new SecurityTokenServiceConfig(connectionConfig, null, null));
        return result;
    }

    private InternalVapiServiceClient newAnonymousVapiServiceClient(String hostname, String trustedThumbprint) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException, IOException, CertificateException, KeyStoreException, CertificateValidationException {
        URI vapiEndpointUri = new URI("https", hostname, "/api", null);
        URI vapiSidecarUri = trustedThumbprint != null ? this._sidecarUrlService.createSidecarUrlValidatedByThumbprint(vapiEndpointUri, trustedThumbprint) : this._sidecarUrlService.createSidecarUrl(vapiEndpointUri, SidecarUrlService.CertificateAuthority.OS);
        VapiConnectionManager connectionManager = this._vapiConnectionManagerFactory.newVapiConnectionManager(vapiSidecarUri, null, null, null);
        Namespaces tryService = (Namespaces)connectionManager.createServiceStub(Namespaces.class);
        try {
            tryService.list();
        }
        catch (SslException ssle) {
            connectionManager.close();
            Certificate cert = CertificateUtil.fetchCertificatesOfRemoteServer((URL)vapiSidecarUri.toURL())[0];
            String sslThumbprint = CertificateUtil.getThumbprint((Certificate)cert);
            if (!sslThumbprint.equals(trustedThumbprint)) {
                throw new CertificateValidationException(String.format("The SSL certificate of %s (thumbprint = %s) cannot be verified against the client-trusted thumbprint %s", vapiEndpointUri.toString(), sslThumbprint, trustedThumbprint), new X509Certificate[0], sslThumbprint);
            }
            connectionManager = this._vapiConnectionManagerFactory.newVapiConnectionManager(vapiSidecarUri, CertificateExtendedUtil.getKeyStore(cert), null, null);
        }
        catch (InvalidSslCertificateException ssle) {
            connectionManager.close();
            String base64Cert = ssle.getContent();
            X509Certificate cert = CertificateUtil.decodeCertificate((String)CertificateUtil.trimCertificateMarkers((String)base64Cert));
            String certThumbprint = CertificateUtil.getThumbprint((Certificate)cert);
            throw new CertificateValidationException(String.format("The SSL certificate of %s (thumbprint = %s) cannot be verified against the client-trusted thumbprint %s", vapiEndpointUri.toString(), certThumbprint, trustedThumbprint), new X509Certificate[0], certThumbprint);
        }
        catch (Exception e) {
            // empty catch block
        }
        return new InternalVapiServiceClient(hostname, connectionManager);
    }

    public String getThumbprint(String hostname) throws NoSuchAlgorithmException, KeyManagementException, IOException, CertificateEncodingException {
        URI hostUri = URI.create("https://" + hostname + "/api");
        URI sidecarUri = this._sidecarUrlService.createSidecarUrlValidatedByThumbprint(hostUri, FAKE_THUMBPRINT);
        Certificate[] serverSslCertificates = CertificateUtil.fetchCertificatesOfRemoteServer((URL)sidecarUri.toURL());
        String sslThumbprint = CertificateUtil.getThumbprint((Certificate)serverSslCertificates[0]);
        return sslThumbprint;
    }

    private static class InternalVapiServiceClient {
        String _hostname;
        VapiConnectionManager _connectionManager;

        public InternalVapiServiceClient(String hostname, VapiConnectionManager connectionManager) {
            this._hostname = hostname;
            this._connectionManager = connectionManager;
        }

        public URI getStsUri() throws URISyntaxException {
            Namespaces tryService = (Namespaces)this._connectionManager.createServiceStub(Namespaces.class);
            try {
                tryService.list();
            }
            catch (Unauthenticated e) {
                String authChallenge = e.getChallenge();
                if (authChallenge == null || authChallenge.isEmpty()) {
                    _logger.warn((Object)"getStsUri, Unauthenticated exception caught as expected, but does not contain a challenge. Rethrowing...");
                    throw e;
                }
                _logger.info((Object)String.format("getStsUri, Unauthenticated caught as expected. Processing authChallenge = %s", authChallenge));
                Map signChallenge = VapiUtil.extractSignAuthChallenge((String)authChallenge);
                if (signChallenge.containsKey("sts")) {
                    return new URI((String)signChallenge.get("sts"));
                }
                _logger.warn((Object)"getStsUri, Unauthenticated exception caught as expected, but does not contain a proper SIGN challenge. Rethrowing...");
                throw e;
            }
            throw new AssertionError((Object)String.format("Invoking %s.list() did not throw Unauthenticated. Cannot obtain STS endpoint", tryService.getClass().getName()));
        }

        public void close() {
            if (this._connectionManager == null) {
                return;
            }
            this._connectionManager.close();
            this._connectionManager = null;
        }
    }
}

