/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.admin.sddc.link.spec;

import com.vmware.cis.task.Info;
import com.vmware.cis.task.Progress;
import com.vmware.cis.task.Status;
import com.vmware.vapi.bindings.ApiError;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vapi.std.errors.Error;
import com.vmware.vsphere.client.commonservice.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class SddcTaskUpdate {
    public UUID requestId;
    public String status;
    public String description;
    public int progress = 0;
    public String error;

    public static SddcTaskUpdate newSddcTaskUpdate(UUID requestId, Info taskInfo) {
        Objects.requireNonNull(requestId);
        SddcTaskUpdate taskUpdate = new SddcTaskUpdate();
        taskUpdate.requestId = requestId;
        if (taskInfo == null) {
            taskUpdate.status = Status.FAILED.name();
            taskUpdate.error = Util.getLocalizedString("cis.tasks.taskNotFound");
        } else {
            ApiError taskInfoError;
            Progress progress;
            if (taskInfo.getStatus() != null) {
                taskUpdate.status = taskInfo.getStatus().name();
            }
            if (taskInfo.getDescription() != null) {
                taskUpdate.description = taskInfo.getDescription().getLocalized();
                if (taskUpdate.description == null) {
                    taskUpdate.description = taskInfo.getDescription().getDefaultMessage();
                }
            }
            if ((progress = taskInfo.getProgress()) != null && progress.getTotal() > 0L) {
                taskUpdate.progress = (int)(100.0 * (double)progress.getCompleted() / (double)progress.getTotal());
            }
            if ((taskInfoError = taskInfo.getError()) != null) {
                taskUpdate.error = taskInfoError instanceof Error ? SddcTaskUpdate.buildErrorMessage((Error)taskInfoError) : taskInfo.getError().getLocalizedMessage();
            }
        }
        return taskUpdate;
    }

    public static SddcTaskUpdate newSddcTaskTimeoutUpdate(UUID requestId, String error) {
        Objects.requireNonNull(requestId);
        SddcTaskUpdate taskUpdate = new SddcTaskUpdate();
        taskUpdate.requestId = requestId;
        taskUpdate.status = Status.FAILED.name();
        taskUpdate.error = error;
        return taskUpdate;
    }

    private static String buildErrorMessage(Error taskInfoError) {
        List messages = taskInfoError.getMessages();
        if (messages == null || messages.isEmpty()) {
            return taskInfoError.getLocalizedMessage();
        }
        ArrayList<String> result = new ArrayList<String>(messages.size());
        for (LocalizableMessage message : messages) {
            if (message.getLocalized() != null) {
                result.add(message.getLocalized());
                continue;
            }
            result.add(message.getDefaultMessage());
        }
        return String.join((CharSequence)"\n", result);
    }
}

