/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.properties;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class ClusterActionAvailabilityPropertyProvider
implements PropertyProviderBean {
    private static final String HOST_FOLDER = "hostFolder";
    private static final String DISABLED_METHOD = "disabledMethod";
    private static final String HAS_PRIVILEGES = "hasPrivileges";
    private static final String HOST_INVENTORY_CREATE_CLUSTER = "Host.Inventory.CreateCluster";
    private static final String CREATE_CLUSTER_EX = "CreateClusterEx";
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _queryBuilder;

    public void setQueryExecutor(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    public void setQuerySpecBuilder(QuerySpecBuilder queryBuilder) {
        this._queryBuilder = queryBuilder;
    }

    @type(value="Datacenter, Folder")
    public boolean getCanCreateCluster(ManagedObjectReference moRef) throws Exception {
        Constraint constraint;
        boolean isDatacenter = ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, (String)Datacenter.class.getSimpleName());
        if (isDatacenter) {
            constraint = this._queryBuilder.createConstraintForRelationship((Object)moRef, HOST_FOLDER, Folder.class.getSimpleName());
        } else if (ManagedObjectUtil.isHostFolder((ManagedObjectReference)moRef)) {
            constraint = this._queryBuilder.createObjectIdentityConstraint((Object)moRef);
        } else {
            return true;
        }
        QuerySpec query = this.createQuerySpec(constraint);
        ResultSet resultSet = this._queryExecutor.getData(query);
        boolean canCreateCluster = this.canCreateCluster(resultSet);
        return canCreateCluster;
    }

    private QuerySpec createQuerySpec(Constraint constraint) {
        ResourceSpec rSpec = new ResourceSpec();
        rSpec.constraint = constraint;
        rSpec.propertySpecs = new PropertySpec[]{this.createPropertySpec()};
        QuerySpec qSpec = new QuerySpec();
        qSpec.resourceSpec = rSpec;
        qSpec.name = "host-folder-privilege-and-disabled-methods-query";
        return qSpec;
    }

    private PropertySpec createPropertySpec() {
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.propertyName = HAS_PRIVILEGES;
        paramSpec.parameter = new String[]{HOST_INVENTORY_CREATE_CLUSTER};
        PropertySpec propSpec = new PropertySpec();
        propSpec.propertyNames = new String[]{HAS_PRIVILEGES, DISABLED_METHOD};
        propSpec.parameters = new ParameterSpec[]{paramSpec};
        propSpec.type = Folder.class.getSimpleName();
        return propSpec;
    }

    private boolean canCreateCluster(ResultSet resultSet) {
        boolean hasPrivilege = true;
        boolean isCreateClusterAllowed = true;
        if (resultSet != null && !ArrayUtils.isEmpty((Object[])resultSet.items)) {
            for (ResultItem item : resultSet.items) {
                for (PropertyValue pv : item.properties) {
                    if (HAS_PRIVILEGES.equalsIgnoreCase(pv.propertyName)) {
                        hasPrivilege = (Boolean)pv.value;
                        continue;
                    }
                    if (!DISABLED_METHOD.equalsIgnoreCase(pv.propertyName)) continue;
                    List<String> disabledMethods = Arrays.asList((String[])pv.value);
                    isCreateClusterAllowed = !disabledMethods.contains(CREATE_CLUSTER_EX);
                }
            }
        }
        return hasPrivilege && isCreateClusterAllowed;
    }
}

