/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.commonservice.util;

import com.vmware.vise.util.security.CertificateInfo;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vsphere.client.commonservice.util.CertificateSigningRequestInfo;
import com.vmware.vsphere.client.commonservice.util.model.CertificateExtendedInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class CertificateExtendedUtil {
    private static CertificateFactory _certFactory;
    private static final String BEGIN_CSR_MARKER = "-----BEGIN CERTIFICATE REQUEST-----\n";
    private static final String END_CSR_MARKER = "\n-----END CERTIFICATE REQUEST-----\n";
    private static final Log _logger;

    public static CertificateInfo getCertificateInfo(byte[] certData) throws UnsupportedEncodingException, CertificateException {
        X509Certificate certificate = (X509Certificate)CertificateExtendedUtil.generateCertificate(certData);
        return CertificateUtil.generateCertificateInfo((X509Certificate)certificate, (byte[])certData);
    }

    public static CertificateSigningRequestInfo getCertificateSigningRequestInfo(byte[] csrData) {
        PKCS10CertificationRequest csr = null;
        try {
            csr = new PKCS10CertificationRequest(csrData);
        }
        catch (Exception ex) {
            _logger.error((Object)"Exception in PKCS10CertificationRequest", (Throwable)ex);
            return null;
        }
        String algorithmObjectId = csr.getSignatureAlgorithm().getAlgorithm().getId();
        String subject = csr.getSubject().toString();
        CertificateSigningRequestInfo crsInfo = new CertificateSigningRequestInfo(subject, algorithmObjectId, csrData);
        return crsInfo;
    }

    public static String appendCSRMarkers(String csr) {
        csr = csr.replace("\r\n", "\n");
        StringBuffer newCsr = new StringBuffer();
        if (!csr.startsWith(BEGIN_CSR_MARKER)) {
            newCsr.append(BEGIN_CSR_MARKER);
        }
        newCsr.append(csr);
        if (!csr.endsWith(END_CSR_MARKER)) {
            newCsr.append(END_CSR_MARKER);
        }
        return newCsr.toString();
    }

    public static KeyStore getKeyStore(Certificate cert) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustStore.setEntry("SslTrustAnchor", new KeyStore.TrustedCertificateEntry(cert), null);
        return trustStore;
    }

    public static CertificateExtendedInfo getCertificateExtendedInfo(String certString) throws UnsupportedEncodingException, CertificateException {
        CertificateExtendedInfo certificateExtendedInfo = new CertificateExtendedInfo();
        certificateExtendedInfo.certificateInfo = CertificateUtil.getCertificateInfo((String)certString);
        X509Certificate x509Cert = (X509Certificate)CertificateUtil.generateCertificate((String)certString);
        certificateExtendedInfo.serialNumber = x509Cert.getSerialNumber().toString();
        certificateExtendedInfo.isExpired = x509Cert.getNotAfter().getTime() < new Date().getTime();
        certificateExtendedInfo.issuerDnMap = CertificateExtendedUtil.CreateMap(x509Cert.getIssuerDN().toString());
        certificateExtendedInfo.subjectDnMap = CertificateExtendedUtil.CreateMap(x509Cert.getSubjectDN().toString());
        return certificateExtendedInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Certificate generateCertificate(byte[] certData) throws UnsupportedEncodingException, CertificateException {
        Certificate certificate;
        ByteArrayInputStream is = null;
        try {
            Certificate cert;
            is = new ByteArrayInputStream(certData);
            certificate = cert = _certFactory.generateCertificate(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return certificate;
    }

    private static Map<String, String> CreateMap(String dnMapString) {
        String[] dnMapsStringList;
        HashMap<String, String> dnMap = new HashMap<String, String>();
        for (String s : dnMapsStringList = dnMapString.split(", ")) {
            if (s.indexOf("=") <= 0) continue;
            String[] dnPair = s.split("=");
            dnMap.put(dnPair[0], dnPair[1]);
        }
        return dnMap;
    }

    static {
        _logger = LogFactory.getLog(CertificateExtendedUtil.class);
        try {
            _certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            _logger.error((Object)"Error loading certificate factory", (Throwable)e);
        }
    }
}

