/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.commonservice.util;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryServiceUtil {
    public static <T> T queryProperty(QueryService queryService, ManagedObjectReference moRef, String propertyName) {
        return (T)QueryServiceUtil.queryProperties(queryService, moRef, propertyName).get(propertyName);
    }

    public static Map<String, Object> queryProperties(QueryService queryService, ManagedObjectReference moRef, String ... propertyNames) {
        Map<ManagedObjectReference, Map<String, Object>> result = QueryServiceUtil.queryPropertiesForMultipleObjects(queryService, Arrays.asList(moRef), propertyNames);
        if (result.isEmpty()) {
            return new HashMap<String, Object>();
        }
        return result.get(moRef);
    }

    public static Map<ManagedObjectReference, Map<String, Object>> queryPropertiesForMultipleObjects(QueryService queryService, Collection<ManagedObjectReference> moRefs, String ... propertyNames) {
        LinkedHashMap<ManagedObjectReference, Map<String, Object>> result = new LinkedHashMap<ManagedObjectReference, Map<String, Object>>();
        if (moRefs == null || moRefs.isEmpty() || propertyNames == null || propertyNames.length == 0) {
            return result;
        }
        ResultSet resultSet = queryService.select(propertyNames).from(new String[]{moRefs.iterator().next().getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, moRefs).fetch();
        List resourceItems = resultSet.getItems();
        for (ResourceItem ri : resourceItems) {
            HashMap<String, Object> propValues = new HashMap<String, Object>();
            result.put((ManagedObjectReference)ri.getKey(), propValues);
            for (String propName : propertyNames) {
                propValues.put(propName, ri.get(propName));
            }
        }
        return result;
    }
}

