/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;

public class FolderFilterBuilder
implements QueryFilterBuilder {
    private final ObjectReferenceService _objectReferenceService;
    private static final String RUNTIME_CONNECTION_STATE = "runtime/connectionState";
    private static final String IS_HOST_STANDALONE = "isStandalone";

    public FolderFilterBuilder(ObjectReferenceService objectReferenceService) {
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="connectedHostsFilter")
    public Filter connectedHostsFilter(String folderId) {
        Validate.notNull((Object)folderId);
        ManagedObjectReference folderRef = (ManagedObjectReference)this._objectReferenceService.getReference(folderId, true);
        if (folderRef == null) {
            return null;
        }
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        predicateList.add(new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)folderRef.getServerGuid()));
        predicateList.add(new PropertyPredicate(RUNTIME_CONNECTION_STATE, PropertyPredicate.ComparisonOperator.EQUAL, (Object)HostSystem.ConnectionState.connected));
        return new Filter(predicateList);
    }

    @QueryFilter(value="connectedStandaloneHostsFilter")
    public Filter connectedStandaloneHostsFilter(String folderId) {
        Validate.notNull((Object)folderId);
        ManagedObjectReference folderRef = (ManagedObjectReference)this._objectReferenceService.getReference(folderId, true);
        if (folderRef == null) {
            return null;
        }
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        predicateList.add(new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)folderRef.getServerGuid()));
        predicateList.add(new PropertyPredicate(IS_HOST_STANDALONE, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true));
        predicateList.add(new PropertyPredicate(RUNTIME_CONNECTION_STATE, PropertyPredicate.ComparisonOperator.EQUAL, (Object)HostSystem.ConnectionState.connected));
        predicateList.add(new PropertyPredicate("isConfigManagerEligible", PropertyPredicate.ComparisonOperator.EQUAL, (Object)true));
        return new Filter(predicateList);
    }
}

