/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceIconData;

@QueryBinding(value="Folder")
public final class VmFolderSummaryData
extends BaseSummaryData
implements ResourceIconData {
    @Property(value="Folder/allNonPodVMOrPrimaryFTVMForVMFolder/length")
    private int vmCount;
    @Relationship(value={"Folder/allNormalVMOrPrimaryFTVMForVMFolder"})
    @Property(value="VirtualMachine/summary/quickStats/overallCpuUsage")
    private int[] cpuUsageMhz;
    @Relationship(value={"Folder/allNormalVMOrPrimaryFTVMForVMFolder"})
    @Property(value="VirtualMachine/summary/storage/committed")
    private Long[] storageUsageB;
    @Relationship(value={"Folder/allNormalVMOrPrimaryFTVMForVMFolder"})
    @Property(value="VirtualMachine/summary/quickStats/guestMemoryUsage")
    private long[] memoryUsageMb;

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("summary.vmCount", (Object)this.vmCount)};
    }

    public ResourceIconData.ResourceIcon[] getResourceIcons() {
        return new ResourceIconData.ResourceIcon[]{new ResourceIconData.ResourceIcon("summary.cpuUsage", this.getCpuUsedMhz(), "vsphere-icon-cpu-summary"), new ResourceIconData.ResourceIcon("summary.memoryUsage", this.getMemoryUsageMb(), "vsphere-icon-memory-summary"), new ResourceIconData.ResourceIcon("summary.storageUsage", this.getStorageUsedB(), "vsphere-icon-storage-summary")};
    }

    private String getCpuUsedMhz() {
        int totalCpuUsageMhz = 0;
        if (this.cpuUsageMhz != null) {
            for (int vmCpuUsedMhz : this.cpuUsageMhz) {
                totalCpuUsageMhz += vmCpuUsedMhz;
            }
        }
        return FormatUtil.getFrequencyFormatted((Number)totalCpuUsageMhz, (int)2, (long)1000000L, (long)-1L, (boolean)true);
    }

    private String getStorageUsedB() {
        long totalStorageUsageB = 0L;
        if (this.storageUsageB != null) {
            for (Long vmStorageUsageB : this.storageUsageB) {
                if (vmStorageUsageB == null) continue;
                totalStorageUsageB += vmStorageUsageB.longValue();
            }
        }
        return FormatUtil.getStorageFormatted((Long)totalStorageUsageB, (long)1L, (long)-1L);
    }

    private String getMemoryUsageMb() {
        long totalMemoryUsageMb = 0L;
        if (this.memoryUsageMb != null) {
            for (long vmMemoryUsage : this.memoryUsageMb) {
                totalMemoryUsageMb += vmMemoryUsage;
            }
        }
        return FormatUtil.getStorageFormatted((Long)totalMemoryUsageMb, (long)0x100000L, (long)-1L);
    }
}

