/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.library.h5model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.content.library.StorageBacking;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.commonservice.util.Util;
import java.util.GregorianCalendar;
import java.util.List;

@QueryBinding(value="com.vmware.content.LibraryModel")
public class LibrarySummaryData
extends BaseSummaryData {
    @Property(value="com.vmware.content.LibraryModel/storageBackings")
    private List storageBacking;
    @Property(value="com.vmware.content.LibraryModel/libraryType.@formatted")
    private String type;
    @Property(value="com.vmware.content.LibraryModel/fileSizeInBytes.@formatted")
    private String size;
    @Property(value="com.vmware.content.LibraryModel/numberOfOther")
    private long numOfOther;
    @Property(value="com.vmware.content.LibraryModel/numberOfTemplates")
    private long numOfTemplates;
    @Property(value="com.vmware.content.LibraryModel/securityPolicyName")
    private String securityPolicyName;
    @Property(value="com.vmware.content.LibraryModel/optimizationInfo/optimizeRemotePublishing.@formatted")
    private String optimized;
    @Property(value="com.vmware.content.LibraryModel/creationTime")
    private GregorianCalendar createdTime;
    @Property(value="com.vmware.content.LibraryModel/lastModifiedTime")
    private GregorianCalendar modifiedTime;
    @Property(value="com.vmware.content.LibraryModel/lastSyncTime")
    private GregorianCalendar lastSyncTime;

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        String stbType = Util.getLocalizedString("fileSystem");
        if (this.storageBacking != null && !this.storageBacking.isEmpty() && this.storageBacking.get(0) != null) {
            Object stb = this.storageBacking.get(0);
            stbType = Util.getLocalizedString(((StorageBacking)stb).getType().getEnumValue().toString());
        }
        if (this.optimized == null) {
            this.optimized = Util.getLocalizedString("no");
        }
        if (this.securityPolicyName == null) {
            this.securityPolicyName = Util.getLocalizedString("notApplied");
        }
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("summaryView.type", (Object)this.type), new BaseSummaryData.LabelValue("library.summaryView.securityPolicyName", (Object)this.securityPolicyName), new BaseSummaryData.LabelValue("library.summaryView.backing.label", (Object)stbType), new BaseSummaryData.LabelValue("library.summaryView.fileSize", (Object)this.size), new BaseSummaryData.LabelValue("library.summaryView.numberOfItems", (Object)(this.numOfOther + this.numOfTemplates)), new BaseSummaryData.LabelValue("library.summaryView.optimized", (Object)this.optimized), new BaseSummaryData.LabelValue("summaryView.created", (Object)new BaseSummaryData.DateValue(this.createdTime)), new BaseSummaryData.LabelValue("summaryView.lastModified", (Object)new BaseSummaryData.DateValue(this.modifiedTime)), new BaseSummaryData.LabelValue("summaryView.lastSync", (Object)new BaseSummaryData.DateValue(this.lastSyncTime))};
    }
}

