/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.permission;

import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.external.ContentLibrary;
import com.vmware.vim.binding.vim.external.ContentLibraryItem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.derivedproperty.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.util.PropertyValueMap;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.security.AuthorizationObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vise.vim.security.data.PermissionData;
import com.vmware.vise.vim.security.data.PermissionInfo;
import com.vmware.vsphere.client.permission.PermissionItemData;
import com.vmware.vsphere.client.security.impl.VCAuthorizationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermissionsPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(PermissionsPropertyProviderAdapter.class);
    private static String PERMISSION_VIEW_DATA_PROP = "permissionViewData";
    private static String ENTITY_PERMISSION_DATA_PROP = "entityPermission";
    private static final String TAG_TYPE = "inventoryservice:InventoryServiceTag";
    private static final String CATEGORY_TYPE = "inventoryservice:InventoryServiceCategory";
    private static String PARENT_PROP = "parent";
    private static String NAME_PROP = "name";
    private static String HOST_PROP = "host";
    private final QueryExecutor _queryExecutor;
    private final ObjectReferenceService _objectReferenceService;
    private final DataServiceExtensionRegistry _dataServiceExtensionRegistry;
    private final String[] _supportedTypes = new String[]{VmwareDistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualSwitch.class.getSimpleName(), Folder.class.getSimpleName(), Datacenter.class.getSimpleName(), ComputeResource.class.getSimpleName(), HostSystem.class.getSimpleName(), VirtualMachine.class.getSimpleName(), VirtualApp.class.getSimpleName(), ClusterComputeResource.class.getSimpleName(), ResourcePool.class.getSimpleName(), Network.class.getSimpleName(), DistributedVirtualPortgroup.class.getSimpleName(), Datastore.class.getSimpleName(), StoragePod.class.getSimpleName(), OpaqueNetwork.class.getSimpleName(), ContentLibrary.class.getSimpleName(), ContentLibraryItem.class.getSimpleName(), "inventoryservice:InventoryServiceTag", "inventoryservice:InventoryServiceCategory", "acl:RootPermissionNode"};

    public PermissionsPropertyProviderAdapter(DataServiceExtensionRegistry registry, QueryExecutor queryExecutor, ObjectReferenceService objectReferenceService) {
        this._queryExecutor = queryExecutor;
        this._objectReferenceService = objectReferenceService;
        this._dataServiceExtensionRegistry = registry;
    }

    public void initialize() {
        this._dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getTypeInfo());
    }

    public void destroy() {
        this._dataServiceExtensionRegistry.unregisterDataAdapter((PropertyProviderAdapter)this);
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        PropertyValue[] permissions;
        boolean isGlobalPermissionRequest;
        Validate.notNull((Object)propertyRequest);
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        if (!PermissionsPropertyProviderAdapter.isValidPropertyRequest(propertyRequest)) {
            return null;
        }
        Map<Object, Object> ctxObjects = this.getActualCtxObjects(propertyRequest.objects);
        if (ctxObjects == null || ctxObjects.isEmpty()) {
            return null;
        }
        Object[] queryObjects = ctxObjects.keySet().toArray();
        ResultSet rs = new ResultSet();
        ManagedObjectReference mor = null;
        AuthorizationManager.Permission[] derivedPermissions = null;
        boolean isEntityPermissionPropertySupportedInVcAndNotGlobalPermissionRequest = false;
        String reqType = propertyRequest.properties[0].type;
        boolean bl = isGlobalPermissionRequest = reqType != null && reqType.equals("acl:RootPermissionNode");
        if (!isGlobalPermissionRequest) {
            mor = (ManagedObjectReference)propertyRequest.objects[0];
            if (derivedPropertyData != null) {
                derivedPermissions = (AuthorizationManager.Permission[])((Map)derivedPropertyData.getSourcePropertyValuesByObject().get(mor)).get(ENTITY_PERMISSION_DATA_PROP);
                boolean bl2 = isEntityPermissionPropertySupportedInVcAndNotGlobalPermissionRequest = derivedPermissions != null;
            }
        }
        if (isEntityPermissionPropertySupportedInVcAndNotGlobalPermissionRequest) {
            permissions = this.framePermissionsFromDerivedData(derivedPermissions, mor, ctxObjects);
        } else {
            try {
                permissions = this._queryExecutor.getProperty(queryObjects, "entityPermissionComputed");
            }
            catch (Exception e) {
                _logger.error((Object)("Error while getting entity permissions:" + e.getMessage()));
                rs.error = e;
                return rs;
            }
        }
        List<ResultItem> resultItems = this.computePermissionItems(permissions, ctxObjects);
        rs.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return rs;
    }

    private PropertyValue[] framePermissionsFromDerivedData(AuthorizationManager.Permission[] permissions, ManagedObjectReference mor, Map<Object, Object> ctxObjects) {
        PermissionInfo[] pInfos = new PermissionInfo[permissions.length];
        PropertyValue pValue = new PropertyValue();
        pValue.propertyName = PERMISSION_VIEW_DATA_PROP;
        pValue.resourceObject = this.getResourceObject(mor, ctxObjects);
        int counter = 0;
        for (AuthorizationManager.Permission permission : permissions) {
            boolean isGlobalPermission = permission.getEntity() == null;
            PermissionInfo pInfo = this.getPermissionInfo(permission, mor);
            pInfos[counter++] = pInfo;
            if (!isGlobalPermission) continue;
            pInfo.permission.entity = AuthorizationObjectUtil.ROOT_NODE_URI;
        }
        pValue.value = pInfos;
        return new PropertyValue[]{pValue};
    }

    private ManagedObjectReference getResourceObject(ManagedObjectReference mor, Map<Object, Object> ctxObjects) {
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, HostSystem.class)) {
            for (Map.Entry<Object, Object> entry : ctxObjects.entrySet()) {
                ManagedObjectReference hostParent;
                if (entry.getValue() == null || !entry.getValue().equals(mor) || !ManagedObjectUtil.isOfType((ManagedObjectReference)(hostParent = (ManagedObjectReference)entry.getKey()), ComputeResource.class)) continue;
                return hostParent;
            }
        }
        return mor;
    }

    private PermissionInfo getPermissionInfo(AuthorizationManager.Permission permission, ManagedObjectReference mor) {
        PermissionInfo pInfo = new PermissionInfo();
        PermissionData data = VCAuthorizationUtil.toPermissionData((AuthorizationManager.Permission)permission);
        try {
            AuthorizationManager.Role role = permission.getEntity() == null ? VCAuthorizationUtil.getRole((Integer)permission.roleId, (String)mor.getServerGuid()) : VCAuthorizationUtil.getRole((Integer)permission.roleId, (String)permission.entity.getServerGuid());
            if (role != null && role.name != null) {
                pInfo.label = AuthorizationUtil.getRoleLocalizedName((String)role.name);
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"Failed to retrieve role information:", (Throwable)e);
        }
        pInfo.permission = data;
        return pInfo;
    }

    private List<ResultItem> computePermissionItems(PropertyValue[] permissions, Map<Object, Object> ctxObjects) {
        ArrayList<Object> objNames = new ArrayList<Object>();
        ArrayList<Object> objHosts = new ArrayList<Object>();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        for (PropertyValue pv : permissions) {
            Object[] permissionInfos = (PermissionInfo[])pv.value;
            if (ArrayUtils.isEmpty((Object[])permissionInfos)) continue;
            ArrayList<PermissionItemData> permissionItems = new ArrayList<PermissionItemData>();
            Object[] objectArray = permissionInfos;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object pi = objectArray[i];
                PermissionItemData item = new PermissionItemData();
                item.principal = ((PermissionInfo)pi).permission.principal;
                item.role = ((PermissionInfo)pi).label;
                item.permissionId = ((PermissionInfo)pi).permission.id;
                item.roleId = ((PermissionInfo)pi).permission.roleId;
                item.isGroup = ((PermissionInfo)pi).permission.group;
                item.propagateToChildren = ((PermissionInfo)pi).permission.propagate;
                if (this.isGlobalPermission(((PermissionInfo)pi).permission)) {
                    item.isGlobal = true;
                    permissionItems.add(item);
                    continue;
                }
                if (((PermissionInfo)pi).permission.entity.equals(pv.resourceObject)) {
                    item.isDefinedOnCurrentObject = true;
                    permissionItems.add(item);
                    continue;
                }
                item.entityId = this._objectReferenceService.getUid(((PermissionInfo)pi).permission.entity, true);
                item.entityType = this._objectReferenceService.getResourceObjectType(((PermissionInfo)pi).permission.entity);
                if (((PermissionInfo)pi).permission.entity instanceof ManagedObjectReference) {
                    item.isRootFolder = ManagedObjectUtil.isRootFolder((ManagedObjectReference)((ManagedObjectReference)((PermissionInfo)pi).permission.entity));
                    if (item.isRootFolder) {
                        item.entityName = VcServiceUtil.getServiceName((String)((ManagedObjectReference)((PermissionInfo)pi).permission.entity).getServerGuid());
                        permissionItems.add(item);
                        continue;
                    }
                    if (ComputeResource.class.getSimpleName().equals(item.entityType)) {
                        objHosts.add(((PermissionInfo)pi).permission.entity);
                    }
                }
                objNames.add(((PermissionInfo)pi).permission.entity);
                permissionItems.add(item);
            }
            resultItems.add(PermissionsPropertyProviderAdapter.createResultItem(pv.resourceObject, permissionItems, ctxObjects));
        }
        PropertyValueMap objNamesMap = this.retrieveEntityProperty(objNames, NAME_PROP);
        PropertyValueMap objHostsMap = this.retrieveEntityProperty(objHosts, HOST_PROP);
        for (ResultItem ri : resultItems) {
            PermissionItemData[] items;
            for (PermissionItemData item : items = (PermissionItemData[])ri.properties[0].value) {
                ManagedObjectReference[] value;
                PropertyValue pv = objNamesMap.getProperty(item.entityId, NAME_PROP);
                if (pv != null && pv.value != null) {
                    item.entityName = (String)pv.value;
                }
                if (!ComputeResource.class.getSimpleName().equals(item.entityType)) continue;
                pv = objHostsMap.getProperty(item.entityId, HOST_PROP);
                item.entityType = HostSystem.class.getSimpleName();
                if (pv == null || pv.value == null || !(pv.value instanceof ManagedObjectReference[]) || (value = (ManagedObjectReference[])pv.value).length <= 0) continue;
                item.entityId = this._objectReferenceService.getUid((Object)value[0], true);
            }
        }
        return resultItems;
    }

    private Map<Object, Object> getActualCtxObjects(Object[] objects) {
        Validate.notNull((Object)objects);
        ArrayList<Object> hosts = new ArrayList<Object>();
        HashMap<Object, Object> ctxObjects = new HashMap<Object, Object>();
        for (Object object : objects) {
            String objType = this._objectReferenceService.getResourceObjectType(object);
            if (objType != null && objType.equals(HostSystem.class.getSimpleName())) {
                hosts.add(object);
                continue;
            }
            ctxObjects.put(object, null);
        }
        if (!hosts.isEmpty()) {
            PropertyValue[] hostParent;
            try {
                hostParent = this._queryExecutor.getProperty(hosts.toArray(), PARENT_PROP);
            }
            catch (Exception e) {
                _logger.error((Object)("Cannot get parent " + e.getMessage()));
                return null;
            }
            for (PropertyValue pv : hostParent) {
                if (pv.value == null || !(pv.value instanceof ManagedObjectReference)) {
                    _logger.error((Object)("Cannot get parent for host: " + pv.resourceObject.toString()));
                    continue;
                }
                ManagedObjectReference parent = (ManagedObjectReference)pv.value;
                if (ComputeResource.class.getSimpleName().equals(parent.getType())) {
                    ctxObjects.put(parent, pv.resourceObject);
                    continue;
                }
                ctxObjects.put(pv.resourceObject, null);
            }
        }
        return ctxObjects;
    }

    private PropertyValueMap retrieveEntityProperty(List<Object> objects, String prop) {
        PropertyValue[] propValues;
        PropertyValueMap result = new PropertyValueMap();
        if (objects.isEmpty()) {
            return result;
        }
        try {
            propValues = this._queryExecutor.getProperty(objects.toArray(), prop);
        }
        catch (Exception e) {
            _logger.error((Object)("Error while getting property " + prop + ": " + e.getMessage()));
            return result;
        }
        if (propValues != null) {
            for (PropertyValue pv : propValues) {
                String uid = this._objectReferenceService.getUid(pv.resourceObject);
                result.putProperty(uid, pv);
            }
        }
        return result;
    }

    private static boolean isValidPropertyRequest(PropertyRequestSpec propertyRequest) {
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (objects == null || objects.length < 1) {
            _logger.error((Object)"PermissionsPropertyProviderAdapter expects atleast one object");
            return false;
        }
        if (properties == null || properties.length < 1) {
            _logger.error((Object)"PermissionsPropertyProviderAdapter expects atleast one property");
            return false;
        }
        PropertySpec property = properties[0];
        if (property == null || property.propertyNames.length != 1 || !PERMISSION_VIEW_DATA_PROP.equals(property.propertyNames[0])) {
            _logger.error((Object)("PermissionsPropertyProviderAdapter expects request for property " + PERMISSION_VIEW_DATA_PROP));
            return false;
        }
        return true;
    }

    private boolean isGlobalPermission(PermissionData permission) {
        return AuthorizationObjectUtil.ROOT_NODE_URI.equals(permission.entity);
    }

    private static ResultItem createResultItem(Object resourceObject, List<PermissionItemData> permissionItems, Map<Object, Object> originalCtxObjects) {
        ResultItem item = new ResultItem();
        if (originalCtxObjects != null) {
            Object originalObj = originalCtxObjects.get(resourceObject);
            item.resourceObject = originalObj != null ? originalObj : resourceObject;
        }
        item.properties = new PropertyValue[1];
        item.properties[0] = new PropertyValue();
        item.properties[0].propertyName = PERMISSION_VIEW_DATA_PROP;
        item.properties[0].value = permissionItems.toArray(new PermissionItemData[permissionItems.size()]);
        return item;
    }

    private TypeInfo[] getTypeInfo() {
        TypeInfo[] typeInfo = new TypeInfo[this._supportedTypes.length];
        DerivedPropertyInfo[] info = new DerivedPropertyInfo[]{this.newDerivedPropertyInfo(PERMISSION_VIEW_DATA_PROP, new String[]{ENTITY_PERMISSION_DATA_PROP})};
        for (int i = 0; i < this._supportedTypes.length; ++i) {
            typeInfo[i] = this.newTypeInfo(this._supportedTypes[i], info);
        }
        return typeInfo;
    }

    private TypeInfo newTypeInfo(String objectType, DerivedPropertyInfo[] derivedProperties) {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = objectType;
        typeInfo.derivedProperties = derivedProperties;
        typeInfo.properties = new String[]{PERMISSION_VIEW_DATA_PROP};
        for (int index = 0; index < derivedProperties.length; ++index) {
            typeInfo.properties[index] = derivedProperties[index].propertyName;
        }
        return typeInfo;
    }

    private DerivedPropertyInfo newDerivedPropertyInfo(String computedProperty, String[] sourceProperties) {
        DerivedPropertyInfo derivedInfo = new DerivedPropertyInfo();
        derivedInfo.propertyName = computedProperty;
        derivedInfo.sourcePropertyNames = sourceProperties;
        return derivedInfo;
    }
}

