/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.Validate;

public class VmHostMigrateFilterBuilder
implements QueryFilterBuilder {
    private static final String CLUSTER_DRS_ENABLED_PROPERTY = "configurationEx/drsConfig/enabled";
    private static final String IS_ROOT_RP_PROPERTY = "isRootRP";
    private final ObjectReferenceService _objectReferenceService;

    public VmHostMigrateFilterBuilder(ObjectReferenceService objectReferenceService) {
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="vmMigrationHostFilter")
    public Filter vmMigrationHostFilter(String vmId, String[] allVms) {
        Validate.notNull((Object)vmId);
        ManagedObjectReference mor = (ManagedObjectReference)this._objectReferenceService.getReference(vmId, true);
        PropertyPredicate predicate = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)mor.getServerGuid());
        return new Filter(Collections.singletonList(predicate));
    }

    @QueryFilter(value="vmMigrationVirtualAppFilter")
    public Filter vmMigrationVirtualAppFilter(String vmId, String[] allVms) {
        Validate.notNull((Object)vmId);
        ManagedObjectReference mor = (ManagedObjectReference)this._objectReferenceService.getReference(vmId, true);
        PropertyPredicate predicate = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)mor.getServerGuid());
        return new Filter(Collections.singletonList(predicate));
    }

    @QueryFilter(value="vmMigrationClusterFilter")
    public Filter vmMigrationClusterFilter(String vmId, String[] allVms) {
        Validate.notNull((Object)vmId);
        ManagedObjectReference mor = (ManagedObjectReference)this._objectReferenceService.getReference(vmId, true);
        ArrayList<PropertyPredicate> criteria = new ArrayList<PropertyPredicate>();
        criteria.add(new PropertyPredicate(CLUSTER_DRS_ENABLED_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true));
        criteria.add(new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)mor.getServerGuid()));
        return new Filter(criteria);
    }

    @QueryFilter(value="vmMigrationResourcePoolFilter")
    public Filter vmMigrationResourcePoolFilter(String vmId, String[] allVms) {
        Validate.notNull((Object)vmId);
        ManagedObjectReference mor = (ManagedObjectReference)this._objectReferenceService.getReference(vmId, true);
        ArrayList<PropertyPredicate> criteria = new ArrayList<PropertyPredicate>();
        criteria.add(new PropertyPredicate(IS_ROOT_RP_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)false));
        criteria.add(new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)mor.getServerGuid()));
        return new Filter(criteria);
    }
}

