/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.Action;
import com.vmware.vim.binding.vim.cluster.Recommendation;
import com.vmware.vim.binding.vim.storageDrs.HbrDiskMigrationAction;
import com.vmware.vim.binding.vim.storageDrs.StorageMigrationAction;
import com.vmware.vim.binding.vim.storageDrs.StoragePlacementAction;
import com.vmware.vim.binding.vim.vm.RelocateSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.drs.RecommendationsService;
import com.vmware.vsphere.client.drs.model.DatastoreMonitorTargetData;
import com.vmware.vsphere.client.drs.model.MonitorTargetData;
import com.vmware.vsphere.client.drs.model.RecommendationActionItemData;
import com.vmware.vsphere.client.drs.model.RecommendationData;
import com.vmware.vsphere.client.drs.model.RecommendationGridData;
import com.vmware.vsphere.client.dscluster.model.SdrsRecommendationGridActionData;
import com.vmware.vsphere.client.dscluster.model.SdrsRecommendationGridItemData;
import com.vmware.vsphere.client.dscluster.model.SdrsRecommendationListItemData;
import com.vmware.vsphere.client.dscluster.model.SdrsVmTargetData;
import com.vmware.vsphere.client.dscluster.util.ModelPropertyRetrievalUtil;
import com.vmware.vsphere.client.dscluster.util.SdrsActionHistoryUtil;
import com.vmware.vsphere.client.dscluster.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SdrsRecommendationsService {
    private static final Log _logger = LogFactory.getLog(SdrsRecommendationsService.class);
    private static final String STORAGE_MIGRATION_ACTION_ICON = "vx-icon-vmDisk";
    private final QueryBindingService _queryBindingService;
    private final RecommendationsService _recommendationsService;
    public static final String SDRS_RECOMMENDATION_REASON_KEY_SUFFIX = ".summary";
    private static final String SDRS_RECOMMENDATION_REASON_KEY_PREFIX = "reason.";
    private final ObjectReferenceService _objectReferenceService;

    public SdrsRecommendationsService(QueryBindingService queryBindingService, ObjectReferenceService objectReferenceService, RecommendationsService recommendationsService) {
        this._queryBindingService = queryBindingService;
        this._objectReferenceService = objectReferenceService;
        this._recommendationsService = recommendationsService;
    }

    public SdrsRecommendationListItemData[] getRecommendationListData(Recommendation[] recommendations) throws Exception {
        if (ArrayUtils.isEmpty((Object[])recommendations)) {
            return new SdrsRecommendationListItemData[0];
        }
        ArrayList<SdrsRecommendationListItemData> result = new ArrayList<SdrsRecommendationListItemData>();
        List recommendationsData = this._recommendationsService.getRecommendationListItems(recommendations);
        HashSet<ManagedObjectReference> targets = new HashSet<ManagedObjectReference>();
        for (RecommendationData recommendation : recommendationsData) {
            targets.addAll(Arrays.asList(recommendation.targetObjects));
        }
        Map vmPropsByRef = ModelPropertyRetrievalUtil.getObjectProperties(this._queryBindingService, targets.toArray(new ManagedObjectReference[0]), VirtualMachine.class.getSimpleName(), SdrsVmTargetData.class);
        Map datastorePropsByRef = ModelPropertyRetrievalUtil.getObjectProperties(this._queryBindingService, targets.toArray(new ManagedObjectReference[0]), Datastore.class.getSimpleName(), DatastoreMonitorTargetData.class);
        HashMap<Object, MonitorTargetData> objPropsByRef = new HashMap<Object, MonitorTargetData>();
        objPropsByRef.putAll(vmPropsByRef);
        objPropsByRef.putAll(datastorePropsByRef);
        for (RecommendationData item : recommendationsData) {
            SdrsRecommendationListItemData listItem = this.getSdrsRecommendationListItemData(item, objPropsByRef);
            result.add(listItem);
        }
        return result.toArray(new SdrsRecommendationListItemData[0]);
    }

    public SdrsRecommendationGridItemData[] getRecommendationGridData(Recommendation[] recommendations) throws Exception {
        if (ArrayUtils.isEmpty((Object[])recommendations)) {
            return new SdrsRecommendationGridItemData[0];
        }
        List recommendationsData = this._recommendationsService.getRecommendationGridItems(recommendations);
        ArrayList<SdrsRecommendationGridItemData> result = new ArrayList<SdrsRecommendationGridItemData>(recommendationsData.size());
        HashMap<Object, SdrsVmTargetData> vmPropsByRef = new HashMap<Object, SdrsVmTargetData>();
        HashMap<Object, DatastoreMonitorTargetData> datastorePropsByRef = new HashMap<Object, DatastoreMonitorTargetData>();
        this.getVmAndDsPropsByRef(recommendationsData, vmPropsByRef, datastorePropsByRef);
        for (RecommendationGridData recommendation : recommendationsData) {
            ArrayList<SdrsRecommendationGridActionData> actions = new ArrayList<SdrsRecommendationGridActionData>();
            for (RecommendationActionItemData actionItem : recommendation.actions) {
                SdrsRecommendationGridActionData action = new SdrsRecommendationGridActionData();
                HashMap<Object, MonitorTargetData> objPropsByRef = new HashMap<Object, MonitorTargetData>();
                for (ManagedObjectReference target : actionItem.targetObjects) {
                    MonitorTargetData temp = (MonitorTargetData)vmPropsByRef.get(target);
                    if (temp != null) {
                        objPropsByRef.put(target, temp);
                    }
                    if ((temp = (MonitorTargetData)datastorePropsByRef.get(target)) == null) continue;
                    objPropsByRef.put(target, temp);
                }
                action.recommendationText = this.getRecommendationText(actionItem.action, objPropsByRef);
                action.targets = SdrsActionHistoryUtil.getTargetObjectsData(objPropsByRef, actionItem.targetObjects);
                action.image = this.getImage(actionItem.action);
                action.warningText = this.getWarningText(actionItem.recommendation);
                this.setUtilizationData(actionItem.action, action);
                actions.add(action);
            }
            SdrsRecommendationGridItemData gridItem = new SdrsRecommendationGridItemData();
            gridItem.priorityRating = recommendation.priorityRating;
            gridItem.recommendation = this.getRecommendationActionsTitle(recommendation.actions);
            gridItem.reasonText = recommendation.reasonText;
            gridItem.recommendationId = recommendation.recommendationId;
            gridItem.prerequisiteRecommendations = recommendation.prerequisiteRecommendations;
            gridItem.dependantRecommendations = recommendation.dependantRecommendations;
            gridItem.actions = actions.toArray(new SdrsRecommendationGridActionData[0]);
            result.add(gridItem);
        }
        return result.toArray(new SdrsRecommendationGridItemData[0]);
    }

    private SdrsRecommendationListItemData getSdrsRecommendationListItemData(RecommendationData recommendationData, Map<Object, MonitorTargetData> objPropsByRef) {
        SdrsRecommendationListItemData listItem = new SdrsRecommendationListItemData();
        String formatRecString = this.getRecommendationText(recommendationData.action, objPropsByRef);
        listItem.recommendationData = recommendationData;
        listItem.recommendationText = formatRecString;
        listItem.targets = SdrsActionHistoryUtil.getTargetObjectsData(objPropsByRef, recommendationData.targetObjects);
        listItem.warningText = this.getWarningText(recommendationData.parentRecommendation);
        listItem.recommendationData.parentRecommendation.reasonText = this.getReasonText(recommendationData);
        listItem.image = this.getImage(recommendationData.action);
        this.setUtilizationData(recommendationData.action, listItem);
        return listItem;
    }

    public String getReasonText(RecommendationData recommendationData) {
        String reasonText = null;
        if (StringUtils.isNotEmpty((CharSequence)recommendationData.parentRecommendation.reasonText)) {
            String reason = recommendationData.parentRecommendation.reason;
            String resID = String.format("%s%s%s", SDRS_RECOMMENDATION_REASON_KEY_PREFIX, reason, SDRS_RECOMMENDATION_REASON_KEY_SUFFIX);
            reasonText = LocalizationUtil.getLocalizedMessage((String)resID);
        } else {
            reasonText = recommendationData.parentRecommendation.reason;
        }
        return reasonText;
    }

    private String getRecommendationText(Action action, Map<Object, MonitorTargetData> objPropsByRef) {
        String actionText = null;
        if (action instanceof StorageMigrationAction) {
            StorageMigrationAction storageMigrationAction = (StorageMigrationAction)action;
            String vmDiskNames = this.getVmDisksFromAction(storageMigrationAction, objPropsByRef);
            if (StringUtils.isEmpty((CharSequence)vmDiskNames)) {
                actionText = Util.getLocalizedString("sdrs.recommendationList.migrateStorageWithNoVmDisks", new String[0]);
            } else {
                actionText = Util.getLocalizedString("sdrs.recommendationList.migrateStorageWithVmDisks", vmDiskNames);
                actionText = actionText + Util.getLocalizedString("sdrs.recommendationList.migrateStorageWithVmDisksFormat", new String[0]);
            }
        } else if (action instanceof HbrDiskMigrationAction) {
            HbrDiskMigrationAction hbrDiskMigrationAction = (HbrDiskMigrationAction)action;
            int numOfReplicaDisks = hbrDiskMigrationAction.diskIds.length;
            String vmName = hbrDiskMigrationAction.collectionName;
            actionText = numOfReplicaDisks > 1 ? Util.getLocalizedString("sdrs.recommendationList.migrateHbrReplicaDiskPlural", Integer.toString(numOfReplicaDisks), vmName) : Util.getLocalizedString("sdrs.recommendationList.migrateHbrReplicaDisk", Integer.toString(numOfReplicaDisks), vmName);
            actionText = actionText + Util.getLocalizedString("sdrs.recommendationList.migrateHbrReplicaDiskFormat", new String[0]);
        } else {
            _logger.warn((Object)("Unknown SDRS recommendation action found - " + action));
        }
        return actionText;
    }

    private String getVmDisksFromAction(StorageMigrationAction action, Map<Object, MonitorTargetData> objDetailsByRef) {
        if (action.vm == null || action.relocateSpec == null) {
            return null;
        }
        RelocateSpec.DiskLocator[] relocateSpecDisks = action.relocateSpec.disk;
        SdrsVmTargetData vmData = (SdrsVmTargetData)objDetailsByRef.get(action.vm);
        VirtualDisk[] currentVmDisks = vmData.getVirtualDisks();
        StringBuilder diskNamesBuilder = new StringBuilder();
        String diskNamesSeparator = Util.getLocalizedString("sdrs.recommendationList.vmVirtualDisksNameSeparator", new String[0]);
        if (relocateSpecDisks != null && currentVmDisks != null) {
            for (RelocateSpec.DiskLocator locator : relocateSpecDisks) {
                for (VirtualDisk disk : currentVmDisks) {
                    if (locator.diskId != disk.key || disk.deviceInfo == null) continue;
                    if (diskNamesBuilder.length() > 0) {
                        diskNamesBuilder.append(diskNamesSeparator);
                    }
                    diskNamesBuilder.append(disk.deviceInfo.label);
                }
            }
        }
        return diskNamesBuilder.toString();
    }

    private String getWarningText(Recommendation recommendation) {
        String warningText = null;
        if (recommendation.warningText != null) {
            warningText = recommendation.warningDetails != null ? LocalizationUtil.getLocalizedMessage((String)recommendation.warningDetails.getKey(), (KeyAnyValue[])recommendation.warningDetails.getArg()) : recommendation.warningText;
        }
        return warningText;
    }

    private String getImage(Action action) {
        if (action instanceof StorageMigrationAction) {
            return STORAGE_MIGRATION_ACTION_ICON;
        }
        return null;
    }

    private void setUtilizationData(Action action, SdrsRecommendationListItemData item) {
        if (action instanceof StorageMigrationAction) {
            StorageMigrationAction sdrsAction = (StorageMigrationAction)action;
            item.spaceUtilSrcBefore = sdrsAction.spaceUtilSrcBefore.floatValue();
            item.spaceUtilSrcAfter = sdrsAction.spaceUtilSrcAfter.floatValue();
            item.spaceUtilDstBefore = sdrsAction.spaceUtilDstBefore.floatValue();
            item.spaceUtilDstAfter = sdrsAction.spaceUtilDstAfter.floatValue();
            item.ioLatencySrcBefore = sdrsAction.ioLatencySrcBefore.floatValue();
            item.ioLatencyDstBefore = sdrsAction.ioLatencyDstBefore.floatValue();
        } else if (action instanceof HbrDiskMigrationAction) {
            HbrDiskMigrationAction sdrsAction = (HbrDiskMigrationAction)action;
            item.spaceUtilSrcBefore = sdrsAction.spaceUtilSrcBefore.floatValue();
            item.spaceUtilSrcAfter = sdrsAction.spaceUtilSrcAfter.floatValue();
            item.spaceUtilDstBefore = sdrsAction.spaceUtilDstBefore.floatValue();
            item.spaceUtilDstAfter = sdrsAction.spaceUtilDstAfter.floatValue();
            item.ioLatencySrcBefore = sdrsAction.ioLatencySrcBefore.floatValue();
            item.ioLatencyDstBefore = sdrsAction.ioLatencyDstBefore.floatValue();
        }
    }

    private void setUtilizationData(Action action, SdrsRecommendationGridActionData item) {
        if (action instanceof StorageMigrationAction) {
            StorageMigrationAction sdrsAction = (StorageMigrationAction)action;
            item.spaceUtilSrcBefore = sdrsAction.spaceUtilSrcBefore.floatValue();
            item.spaceUtilSrcAfter = sdrsAction.spaceUtilSrcAfter.floatValue();
            item.spaceUtilDstBefore = sdrsAction.spaceUtilDstBefore.floatValue();
            item.spaceUtilDstAfter = sdrsAction.spaceUtilDstAfter.floatValue();
            item.ioLatencySrcBefore = sdrsAction.ioLatencySrcBefore.floatValue();
            item.ioLatencyDstBefore = sdrsAction.ioLatencyDstBefore.floatValue();
        } else if (action instanceof HbrDiskMigrationAction) {
            HbrDiskMigrationAction sdrsAction = (HbrDiskMigrationAction)action;
            item.spaceUtilSrcBefore = sdrsAction.spaceUtilSrcBefore.floatValue();
            item.spaceUtilSrcAfter = sdrsAction.spaceUtilSrcAfter.floatValue();
            item.spaceUtilDstBefore = sdrsAction.spaceUtilDstBefore.floatValue();
            item.spaceUtilDstAfter = sdrsAction.spaceUtilDstAfter.floatValue();
            item.ioLatencySrcBefore = sdrsAction.ioLatencySrcBefore.floatValue();
            item.ioLatencyDstBefore = sdrsAction.ioLatencyDstBefore.floatValue();
        }
    }

    private String getRecommendationActionsTitle(List<RecommendationActionItemData> actionItems) {
        if (actionItems.isEmpty()) {
            return "";
        }
        HashMap<String, Integer> numberOfActionTypesMap = new HashMap<String, Integer>();
        String storagePlacementKey = "recommendationGridActionTitle.storagePlacement";
        String storageMigrationKey = "recommendationGridActionTitle.storageMigration";
        String hbrStorageMigrationKey = "recommendationGridActionTitle.hbrStorageMigration";
        for (RecommendationActionItemData recommendationActionItemData : actionItems) {
            if (recommendationActionItemData.action instanceof StorageMigrationAction) {
                this.increaseActionCount(numberOfActionTypesMap, "recommendationGridActionTitle.storageMigration");
            }
            if (recommendationActionItemData.action instanceof HbrDiskMigrationAction) {
                this.increaseActionCount(numberOfActionTypesMap, "recommendationGridActionTitle.hbrStorageMigration");
            }
            if (!(recommendationActionItemData.action instanceof StoragePlacementAction)) continue;
            this.increaseActionCount(numberOfActionTypesMap, "recommendationGridActionTitle.storagePlacement");
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : numberOfActionTypesMap.entrySet()) {
            sb.append(Util.getLocalizedString((String)entry.getKey(), ((Integer)entry.getValue()).toString()) + ", ");
        }
        String string = sb.toString();
        return string.replaceAll(",\\s$", "");
    }

    private void increaseActionCount(Map<String, Integer> numberOfActionTypesMap, String action) {
        int count = numberOfActionTypesMap.getOrDefault(action, 0);
        numberOfActionTypesMap.put(action, count + 1);
    }

    private MonitorTargetData[] getTargetObjectsData(Map<String, MonitorTargetData> objPropsByRef, ManagedObjectReference[] targets) {
        if (targets == null) {
            return new MonitorTargetData[0];
        }
        MonitorTargetData[] targetsData = new MonitorTargetData[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            targetsData[i] = objPropsByRef.get(this._objectReferenceService.getUid((Object)targets[i]));
        }
        return targetsData;
    }

    private void getVmAndDsPropsByRef(List<RecommendationGridData> recommendationsData, Map<Object, SdrsVmTargetData> vmPropsByRef, Map<Object, DatastoreMonitorTargetData> datastorePropsByRef) {
        HashSet<ManagedObjectReference> targets = new HashSet<ManagedObjectReference>();
        for (RecommendationGridData recommendation : recommendationsData) {
            for (RecommendationActionItemData actionItem : recommendation.actions) {
                targets.addAll(Arrays.asList(actionItem.targetObjects));
            }
        }
        Map vmPropsByRef_temp = ModelPropertyRetrievalUtil.getObjectProperties(this._queryBindingService, targets.toArray(new ManagedObjectReference[0]), VirtualMachine.class.getSimpleName(), SdrsVmTargetData.class);
        vmPropsByRef.putAll(vmPropsByRef_temp);
        Map datastorePropsByRef_temp = ModelPropertyRetrievalUtil.getObjectProperties(this._queryBindingService, targets.toArray(new ManagedObjectReference[0]), Datastore.class.getSimpleName(), DatastoreMonitorTargetData.class);
        datastorePropsByRef.putAll(datastorePropsByRef_temp);
    }
}

