/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DsClusterSerivcePropertyProvider
implements PropertyProviderBean {
    private static final String DATASTORE_TYPE_PROP = "summary.type";
    private static final String DATASTORE_FREE_SPACE_PROP = "summary.freeSpace";
    private static final String DATASTORE_RELATION = "datastore";
    private static final Log _logger = LogFactory.getLog(DsClusterSerivcePropertyProvider.class);
    private DataService _dataService;

    public DsClusterSerivcePropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="StoragePod")
    public String getType(ManagedObjectReference dsClusterRef) throws Exception {
        if (dsClusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        PropertyValue[] types = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)dsClusterRef, (String)DATASTORE_RELATION, (String)Datastore.class.getSimpleName(), (String)DATASTORE_TYPE_PROP);
        if (types == null || types.length == 0) {
            return "";
        }
        return (String)types[0].value;
    }

    @type(value="StoragePod")
    public Long getDsLargestFreeSpace(ManagedObjectReference dsClusterRef) throws Exception {
        if (dsClusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        PropertyValue[] freeSpaces = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)dsClusterRef, (String)DATASTORE_RELATION, (String)Datastore.class.getSimpleName(), (String)DATASTORE_FREE_SPACE_PROP);
        if (freeSpaces == null || freeSpaces.length == 0) {
            return 0L;
        }
        List<PropertyValue> listBridge = Arrays.asList(freeSpaces);
        PropertyValue maxFreeSpace = Collections.max(listBridge, new Comparator<PropertyValue>(){

            @Override
            public int compare(PropertyValue pv1, PropertyValue pv2) {
                if (pv1.value instanceof Long && pv2.value instanceof Long) {
                    return ((Long)pv1.value).compareTo((Long)pv2.value);
                }
                return 0;
            }
        });
        return (Long)maxFreeSpace.value;
    }
}

