/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.cluster.DrsFaults;
import com.vmware.vim.binding.vim.cluster.Recommendation;
import com.vmware.vim.binding.vim.storageDrs.StoragePlacementResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dscluster.MaintenanceModeData;
import com.vmware.vsphere.client.dscluster.SdrsRecommendationsService;
import com.vmware.vsphere.client.dscluster.maintenancemode.DatastoreMaintenanceSpec;
import com.vmware.vsphere.client.dscluster.model.SdrsFaultListItem;
import com.vmware.vsphere.client.dscluster.model.SdrsRecommendationListItemData;
import com.vmware.vsphere.client.dscluster.util.MaintenanceModeMutationUtil;
import com.vmware.vsphere.client.dscluster.util.Util;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MaintenanceModeMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(MaintenanceModeMutationProvider.class);
    private final SdrsRecommendationsService _sdrsRecommendationsService;
    private final QueryBindingService _queryBindingService;

    public MaintenanceModeMutationProvider(QueryBindingService queryBindingService, SdrsRecommendationsService sdrsRecommendationsService) {
        this._queryBindingService = queryBindingService;
        this._sdrsRecommendationsService = sdrsRecommendationsService;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, DatastoreMaintenanceSpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("error.maintenanceSpecInvalid", new String[0]));
        }
        OperationResult result = new OperationResult();
        result.entity = datastoreRef;
        try {
            Datastore datastoreObj = (Datastore)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datastoreRef);
            switch (spec.maintenanceOpType) {
                case enter: {
                    Object[] recommendations;
                    StoragePlacementResult storagePlacementResult = datastoreObj.enterMaintenanceMode();
                    MaintenanceModeData maintenanceModeData = new MaintenanceModeData();
                    DrsFaults drsFaults = storagePlacementResult.getDrsFault();
                    if (drsFaults != null) {
                        SdrsFaultListItem[] faultItems = MaintenanceModeMutationUtil.getFaultListData(new DrsFaults[]{drsFaults}, this._queryBindingService);
                        maintenanceModeData.faults = Arrays.asList(faultItems);
                    }
                    if (!ArrayUtils.isEmpty((Object[])(recommendations = storagePlacementResult.getRecommendations()))) {
                        SdrsRecommendationListItemData[] recommendationItems = this._sdrsRecommendationsService.getRecommendationListData((Recommendation[])recommendations);
                        maintenanceModeData.recommendations = Arrays.asList(recommendationItems);
                    }
                    result.result = maintenanceModeData;
                    result.task = storagePlacementResult.task;
                    break;
                }
                case exit: {
                    result.task = datastoreObj.exitMaintenanceMode();
                    break;
                }
                case applyRecommendations: {
                    if (spec.keys == null || spec.keys.length == 0) {
                        throw new IllegalArgumentException(Util.getLocalizedString("error.noRecKeysToApply", new String[0]));
                    }
                    StorageResourceManager storageManager = Util.getStorageManager(datastoreRef);
                    result.task = storageManager.applyRecommendation(spec.keys);
                    break;
                }
                default: {
                    _logger.error((Object)("Unknown datastore maintenance operation: " + spec.maintenanceOpType.toString()));
                    break;
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Couldn't perform a maintenance operation on a datastore", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

