/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.util;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.DrsFaults;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.drs.util.FaultsLocalizationUtil;
import com.vmware.vsphere.client.dscluster.model.SdrsDiskFaultVmEntryData;
import com.vmware.vsphere.client.dscluster.model.SdrsFaultListItem;
import com.vmware.vsphere.client.dscluster.model.SdrsFaultVmEntryData;
import com.vmware.vsphere.client.dscluster.util.ModelPropertyRetrievalUtil;
import com.vmware.vsphere.client.dscluster.util.SdrsFaultsUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class MaintenanceModeMutationUtil {
    public static SdrsFaultListItem[] getFaultListData(DrsFaults[] sdrsFaultsArray, QueryBindingService queryBindingService) {
        ArrayList<SdrsFaultListItem> drsFaultItems = new ArrayList<SdrsFaultListItem>();
        if (!ArrayUtils.isEmpty((Object[])sdrsFaultsArray)) {
            HashSet<ManagedObjectReference> faultsByVmTargets = new HashSet<ManagedObjectReference>();
            HashSet<ManagedObjectReference> faultsByVmDiskTargets = new HashSet<ManagedObjectReference>();
            SdrsFaultsUtil.getFaultTargetEntities(sdrsFaultsArray, faultsByVmTargets, faultsByVmDiskTargets);
            Map<ManagedObjectReference, SdrsFaultVmEntryData> faultVmsEntryData = ModelPropertyRetrievalUtil.getObjectProperties(queryBindingService, faultsByVmTargets.toArray(new ManagedObjectReference[0]), VirtualMachine.class.getSimpleName(), SdrsFaultVmEntryData.class);
            Map<ManagedObjectReference, SdrsDiskFaultVmEntryData> faultVmDiskEntryData = ModelPropertyRetrievalUtil.getObjectProperties(queryBindingService, faultsByVmDiskTargets.toArray(new ManagedObjectReference[0]), VirtualMachine.class.getSimpleName(), SdrsDiskFaultVmEntryData.class);
            for (DrsFaults sdrsFault : sdrsFaultsArray) {
                if (sdrsFault == null) continue;
                drsFaultItems.addAll(MaintenanceModeMutationUtil.buildFaultListItem(sdrsFault, faultVmsEntryData, faultVmDiskEntryData));
            }
        }
        return drsFaultItems.toArray(new SdrsFaultListItem[drsFaultItems.size()]);
    }

    private static List<SdrsFaultListItem> buildFaultListItem(DrsFaults sdrsFault, Map<ManagedObjectReference, SdrsFaultVmEntryData> faultVmsEntryData, Map<ManagedObjectReference, SdrsDiskFaultVmEntryData> faultVmDiskEntryData) {
        ArrayList<SdrsFaultListItem> faultListItems = new ArrayList<SdrsFaultListItem>();
        for (DrsFaults.FaultsByVm vmFault : sdrsFault.getFaultsByVm()) {
            SdrsFaultListItem sdrsFaultListItem = new SdrsFaultListItem();
            sdrsFaultListItem.diskName = "--";
            if (!ArrayUtils.isEmpty((Object[])vmFault.getFault())) {
                sdrsFaultListItem.description = new ArrayList<String>(vmFault.getFault().length);
                for (Exception methodFault : vmFault.getFault()) {
                    String faultDescription = FaultsLocalizationUtil.getDrsFaultMessage((Exception)methodFault);
                    sdrsFaultListItem.description.add(faultDescription);
                }
                if (vmFault instanceof DrsFaults.FaultsByVirtualDisk && SdrsFaultsUtil.isFaultByVirtualDisk((DrsFaults.FaultsByVirtualDisk)vmFault)) {
                    DrsFaults.FaultsByVirtualDisk fault = (DrsFaults.FaultsByVirtualDisk)vmFault;
                    SdrsDiskFaultVmEntryData diskFaultVmData = faultVmDiskEntryData.get(vmFault.getVm());
                    sdrsFaultListItem.diskName = diskFaultVmData.getVmdkName(fault.getDisk().getDiskId());
                    sdrsFaultListItem.vmName = diskFaultVmData.getName();
                    sdrsFaultListItem.vmIcon = diskFaultVmData.getPrimaryIconId();
                    sdrsFaultListItem.vm = (ManagedObjectReference)diskFaultVmData.getProvider();
                    sdrsFaultListItem.vmLabelIds = diskFaultVmData.getLabelIds();
                    sdrsFaultListItem.hostName = diskFaultVmData.host.getName();
                    sdrsFaultListItem.hostIcon = diskFaultVmData.host.getPrimaryIconId();
                    sdrsFaultListItem.host = (ManagedObjectReference)diskFaultVmData.host.getProvider();
                    sdrsFaultListItem.hostLabelIds = diskFaultVmData.host.getLabelIds();
                } else {
                    SdrsFaultVmEntryData faultVmData = faultVmsEntryData.get(vmFault.getVm());
                    sdrsFaultListItem.vmName = faultVmData.getName();
                    sdrsFaultListItem.vmIcon = faultVmData.getPrimaryIconId();
                    sdrsFaultListItem.vmLabelIds = faultVmData.getLabelIds();
                    sdrsFaultListItem.vm = (ManagedObjectReference)faultVmData.getProvider();
                    sdrsFaultListItem.hostName = faultVmData.host.getName();
                    sdrsFaultListItem.hostIcon = faultVmData.host.getPrimaryIconId();
                    sdrsFaultListItem.host = (ManagedObjectReference)faultVmData.host.getProvider();
                    sdrsFaultListItem.hostLabelIds = faultVmData.host.getLabelIds();
                }
            }
            faultListItems.add(sdrsFaultListItem);
        }
        return faultListItems;
    }
}

