/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.util;

import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.drs.model.MonitorTargetData;
import com.vmware.vsphere.client.dscluster.util.Util;
import java.util.Map;

public class SdrsActionHistoryUtil {
    public static String getVmDiskNames(int[] relocateSpecDiskIds, Map<Integer, VirtualDisk> vmVirtualDisks) {
        if (relocateSpecDiskIds == null || relocateSpecDiskIds.length == 0 || vmVirtualDisks == null || vmVirtualDisks.size() == 0) {
            return Util.getLocalizedString("sdrs.history.missingObjectNameLabel", new String[0]);
        }
        String diskNames = "";
        String diskNamesSeparator = "";
        for (int locatorDiskId : relocateSpecDiskIds) {
            VirtualDisk disk = vmVirtualDisks.get(locatorDiskId);
            if (disk == null || disk.deviceInfo == null) continue;
            diskNames = diskNames + diskNamesSeparator + disk.deviceInfo.label;
            if (!diskNamesSeparator.equals("")) continue;
            diskNamesSeparator = Util.getLocalizedString("sdrs.history.vmVirtualDisksNameSeparator", new String[0]);
        }
        return diskNames;
    }

    public static String getFormattedActionText(String actionHistoryText, String vmDiskNames) {
        String actionText = vmDiskNames == null || vmDiskNames.equals("") ? Util.getLocalizedString(actionHistoryText, new String[0]) : Util.getLocalizedString(actionHistoryText, vmDiskNames);
        if (actionHistoryText.equals(Util.getLocalizedString("sdrs.history.migrateVmConfigFile", new String[0]))) {
            actionText = actionText + Util.getLocalizedString("sdrs.history.sourceDestination", new String[0]);
        } else if (actionHistoryText.equals(Util.getLocalizedString("sdrs.history.migrateHardDisks", new String[0]))) {
            actionText = actionText + Util.getLocalizedString("sdrs.history.vmSourceDestination", new String[0]);
        }
        return actionText;
    }

    public static MonitorTargetData[] getTargetObjectsData(Map<Object, MonitorTargetData> objPropsByRef, ManagedObjectReference[] targets) {
        if (targets == null) {
            return new MonitorTargetData[0];
        }
        MonitorTargetData[] targetsData = new MonitorTargetData[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            targetsData[i] = objPropsByRef.get(targets[i]);
        }
        return targetsData;
    }
}

