/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.util;

import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.storagedrs.rules.IntraVmAffinity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SdrsRulesHelper {
    private final List<RuleInfo> dsClusterRules;
    private final Map<String, Set<RuleInfo>> vmAntiAffinityRulesPerVm;
    private final Map<String, VmConfigInfo> vmConfigInfos;
    private final Map<String, RuleInfo> vmdkAntiAffinityRules;
    private final Collection<ManagedObjectReference> relevantVms;
    private final boolean defaultIntraVmAffinity;
    private final Map<String, String> vmNames;
    private final boolean isVmProvisionig;

    SdrsRulesHelper(List<RuleInfo> dsClusterRules, Map<String, Set<RuleInfo>> vmAntiAffinityRulesPerVm, Map<String, VmConfigInfo> vmConfigInfos, Map<String, RuleInfo> vmdkAntiAffinityRules, Collection<ManagedObjectReference> relevantVms, boolean defaultIntraVmAffinity, Map<String, String> vmNames) {
        this(dsClusterRules, vmAntiAffinityRulesPerVm, vmConfigInfos, vmdkAntiAffinityRules, relevantVms, defaultIntraVmAffinity, vmNames, false);
    }

    SdrsRulesHelper(List<RuleInfo> dsClusterRules, Map<String, Set<RuleInfo>> vmAntiAffinityRulesPerVm, Map<String, VmConfigInfo> vmConfigInfos, Map<String, RuleInfo> vmdkAntiAffinityRules, Collection<ManagedObjectReference> relevantVms, boolean defaultIntraVmAffinity, Map<String, String> vmNames, boolean isVmProvisionig) {
        this.dsClusterRules = dsClusterRules;
        this.vmAntiAffinityRulesPerVm = vmAntiAffinityRulesPerVm;
        this.vmConfigInfos = vmConfigInfos;
        this.vmdkAntiAffinityRules = vmdkAntiAffinityRules;
        this.relevantVms = relevantVms;
        this.defaultIntraVmAffinity = defaultIntraVmAffinity;
        this.vmNames = vmNames;
        this.isVmProvisionig = isVmProvisionig;
    }

    public boolean isDefaultIntraVmAffinity() {
        return this.defaultIntraVmAffinity;
    }

    public boolean isVmProvisionig() {
        return this.isVmProvisionig;
    }

    public Collection<ManagedObjectReference> getRelevantVms() {
        return Collections.unmodifiableCollection(this.relevantVms);
    }

    public List<RuleInfo> getDsClusterRules() {
        return Collections.unmodifiableList(this.dsClusterRules);
    }

    public Map<String, RuleInfo> getVmdkAntiAffinityRulesMap() {
        return Collections.unmodifiableMap(this.vmdkAntiAffinityRules);
    }

    public RuleInfo getVmdkAntiAffinityRule(ManagedObjectReference vm) {
        return this.vmdkAntiAffinityRules.get(ManagedObjectUtil.morefToString((ManagedObjectReference)vm));
    }

    public Collection<RuleInfo> getVmAntiAffinityRules(ManagedObjectReference vm) {
        Set<RuleInfo> result = this.vmAntiAffinityRulesPerVm.get(ManagedObjectUtil.morefToString((ManagedObjectReference)vm));
        if (result == null) {
            result = new HashSet<RuleInfo>();
        }
        return Collections.unmodifiableCollection(result);
    }

    public boolean areVmdksKeptTogether(ManagedObjectReference vm) {
        VmConfigInfo vmConfigInfo = this.vmConfigInfos.get(ManagedObjectUtil.morefToString((ManagedObjectReference)vm));
        if (vmConfigInfo == null || vmConfigInfo.intraVmAffinity == null) {
            return this.defaultIntraVmAffinity;
        }
        return vmConfigInfo.intraVmAffinity;
    }

    public VmConfigInfo getVmConfigInfo(ManagedObjectReference vm) {
        VmConfigInfo vmConfigInfo = this.vmConfigInfos.get(ManagedObjectUtil.morefToString((ManagedObjectReference)vm));
        return vmConfigInfo;
    }

    public String getVmName(ManagedObjectReference vm) {
        return this.vmNames.get(ManagedObjectUtil.morefToString((ManagedObjectReference)vm));
    }

    public IntraVmAffinity getIntraVmAffinity(ManagedObjectReference vm) {
        VmConfigInfo vmConfigInfo = this.vmConfigInfos.get(ManagedObjectUtil.morefToString((ManagedObjectReference)vm));
        return SdrsRulesHelper.getIntraVmAffinity(vmConfigInfo);
    }

    public static IntraVmAffinity getIntraVmAffinity(VmConfigInfo vmConfigInfo) {
        IntraVmAffinity result = IntraVmAffinity.ClusterDefault;
        if (vmConfigInfo != null && vmConfigInfo.intraVmAffinity != null) {
            result = vmConfigInfo.intraVmAffinity != false ? IntraVmAffinity.KeepVmdksTogether : IntraVmAffinity.DoNotKeepVmdksTogether;
        }
        return result;
    }
}

