/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.util;

import com.vmware.vim.binding.vim.cluster.AntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.storageDrs.VirtualDiskAntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.dscluster.util.SdrsRulesHelper;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SdrsRulesHelperBuilder {
    private static final Log _logger = LogFactory.getLog(SdrsRulesHelperBuilder.class);
    private ManagedObjectReference dsClusterRef;
    private SdrsRuleInfo[] notPresitedVmAntiAffinityRules;
    private VmConfigInfo notPresitedVmConfigInfo;
    private boolean isVmProvisioning;
    private boolean enabledRulesOnly;

    public SdrsRulesHelperBuilder forDatastoreCluster(ManagedObjectReference dsClusterRef) {
        this.dsClusterRef = dsClusterRef;
        return this;
    }

    public SdrsRulesHelperBuilder andNotPersistedVmAntiAffinityRules(SdrsRuleInfo[] vmAntiAffinityRules) {
        this.notPresitedVmAntiAffinityRules = vmAntiAffinityRules;
        return this;
    }

    public SdrsRulesHelperBuilder andNotPersistedVmConfigInfo(VmConfigInfo vmConfigInfos) {
        this.notPresitedVmConfigInfo = vmConfigInfos;
        return this;
    }

    public SdrsRulesHelperBuilder includingEnabledRulesOnly() {
        this.enabledRulesOnly = true;
        return this;
    }

    public SdrsRulesHelperBuilder includingAllRules() {
        this.enabledRulesOnly = false;
        return this;
    }

    public SdrsRulesHelperBuilder setIsVmProvisioning() {
        this.isVmProvisioning = true;
        return this;
    }

    public SdrsRulesHelper build(DataService dataService) throws Exception {
        return this.buildAndResolveNamesForVms(dataService, null);
    }

    public SdrsRulesHelper buildAndResolveNamesForVms(DataService dataService, Collection<ManagedObjectReference> vmsToResolve) throws Exception {
        ArrayList<ManagedObjectReference> _relevantVms = new ArrayList<ManagedObjectReference>();
        ArrayList<RuleInfo> _dsClusterRules = new ArrayList<RuleInfo>();
        HashMap<String, Set<RuleInfo>> _vmAntiAffinityRulesPerVm = new HashMap<String, Set<RuleInfo>>();
        HashMap<String, VmConfigInfo> _vmConfigInfos = new HashMap<String, VmConfigInfo>();
        HashMap<String, RuleInfo> _vmdkAntiAffinityRules = new HashMap<String, RuleInfo>();
        PropertyValue[] propertiesResult = QueryUtil.getProperties((DataService)dataService, (Object)this.dsClusterRef, (String[])new String[]{"podStorageDrsEntry.storageDrsConfig.podConfig.rule", "podStorageDrsEntry.storageDrsConfig.vmConfig", "podStorageDrsEntry.storageDrsConfig.podConfig.defaultIntraVmAffinity"});
        if (propertiesResult != null) {
            for (PropertyValue propertyValue : propertiesResult) {
                if (propertyValue.value instanceof RuleInfo[]) {
                    RuleInfo[] vmAaRules = (RuleInfo[])propertyValue.value;
                    this.buildVmAntiAffinityRulesPerVm(vmAaRules, _dsClusterRules, _vmAntiAffinityRulesPerVm);
                    continue;
                }
                if (!(propertyValue.value instanceof VmConfigInfo[])) continue;
                VmConfigInfo[] vmConfigs = (VmConfigInfo[])propertyValue.value;
                this.buildVmdkAntiAffinityRulesPerVm(vmConfigs, _relevantVms, _vmConfigInfos, _dsClusterRules, _vmdkAntiAffinityRules);
            }
        }
        if (this.notPresitedVmConfigInfo != null) {
            this.buildVmdkAntiAffinityRulesPerVm(new VmConfigInfo[]{this.notPresitedVmConfigInfo}, _relevantVms, _vmConfigInfos, _dsClusterRules, _vmdkAntiAffinityRules);
        }
        this.buildVmAntiAffinityRulesPerVm(this.notPresitedVmAntiAffinityRules, _dsClusterRules, _vmAntiAffinityRulesPerVm);
        boolean _defaultIntraVmAffinity = this.extractDefaultIntraVmAffinity(propertiesResult);
        if (vmsToResolve != null) {
            _relevantVms.addAll(vmsToResolve);
        }
        PropertyValue[] vmNamesResultPv = SdrsRulesHelperBuilder.getVmNames(dataService, _relevantVms);
        Map<String, String> _vmNamesByVmUid = this.buildVmNamesByVmUid(vmNamesResultPv);
        SdrsRulesHelper validatorHelper = new SdrsRulesHelper(_dsClusterRules, _vmAntiAffinityRulesPerVm, _vmConfigInfos, _vmdkAntiAffinityRules, _relevantVms, _defaultIntraVmAffinity, _vmNamesByVmUid, this.isVmProvisioning);
        return validatorHelper;
    }

    private static PropertyValue[] getVmNames(DataService dataService, Collection<ManagedObjectReference> vmRefs) throws Exception {
        if (vmRefs == null || vmRefs.size() == 0) {
            return new PropertyValue[0];
        }
        Object[] vms = new ManagedObjectReference[vmRefs.size()];
        vmRefs.toArray(vms);
        PropertyValue[] vmNames = QueryUtil.getProperties((DataService)dataService, (Object[])vms, (String[])new String[]{"name"});
        return vmNames;
    }

    private Map<String, String> buildVmNamesByVmUid(PropertyValue[] vmNamesResultPv) {
        HashMap<String, String> vmNames = new HashMap<String, String>();
        if (vmNamesResultPv != null) {
            for (PropertyValue propertyValue : vmNamesResultPv) {
                if (!(propertyValue.resourceObject instanceof ManagedObjectReference)) continue;
                ManagedObjectReference provider = (ManagedObjectReference)propertyValue.resourceObject;
                vmNames.put(ManagedObjectUtil.morefToString((ManagedObjectReference)provider), (String)propertyValue.value);
            }
        }
        return vmNames;
    }

    private boolean isRuleRelevant(RuleInfo rule, boolean enabledRulesOnly) {
        return rule != null && (rule.enabled != false || !enabledRulesOnly);
    }

    private Boolean extractDefaultIntraVmAffinity(PropertyValue[] propertiesResult) {
        Boolean defaultIntraVmAffinity = true;
        for (PropertyValue propertyValue : propertiesResult) {
            if (!(propertyValue.value instanceof Boolean)) continue;
            defaultIntraVmAffinity = (Boolean)propertyValue.value;
            break;
        }
        return defaultIntraVmAffinity;
    }

    private void buildVmdkAntiAffinityRulesPerVm(VmConfigInfo[] vmConfigs, Collection<ManagedObjectReference> relevantVms, Map<String, VmConfigInfo> _vmConfigInfos, Collection<RuleInfo> _dsClusterRules, Map<String, RuleInfo> _vmdkAntiAffinityRules) {
        if (vmConfigs == null) {
            return;
        }
        for (VmConfigInfo vmConfigInfo : vmConfigs) {
            VirtualDiskAntiAffinityRuleSpec intraVmAntiAffinity;
            _vmConfigInfos.put(ManagedObjectUtil.morefToString((ManagedObjectReference)vmConfigInfo.vm), vmConfigInfo);
            if (vmConfigInfo.vm != null) {
                relevantVms.add(vmConfigInfo.vm);
            }
            if (this.isRuleRelevant((RuleInfo)(intraVmAntiAffinity = vmConfigInfo.getIntraVmAntiAffinity()), this.enabledRulesOnly)) {
                _vmdkAntiAffinityRules.put(ManagedObjectUtil.morefToString((ManagedObjectReference)vmConfigInfo.vm), (RuleInfo)intraVmAntiAffinity);
                _dsClusterRules.add((RuleInfo)intraVmAntiAffinity);
                continue;
            }
            _vmdkAntiAffinityRules.put(ManagedObjectUtil.morefToString((ManagedObjectReference)vmConfigInfo.vm), null);
        }
    }

    private void buildVmAntiAffinityRulesPerVm(RuleInfo[] aaRules, Collection<RuleInfo> _dsClusterRules, Map<String, Set<RuleInfo>> _vmAntiAffinityRulesPerVm) {
        if (aaRules == null) {
            return;
        }
        for (RuleInfo rule : aaRules) {
            if (!this.isRuleRelevant(rule, this.enabledRulesOnly) || !(rule instanceof AntiAffinityRuleSpec)) continue;
            _dsClusterRules.add(rule);
            AntiAffinityRuleSpec antiAffinityRuleSpec = (AntiAffinityRuleSpec)rule;
            for (ManagedObjectReference vm : antiAffinityRuleSpec.vm) {
                Set<RuleInfo> rulesForTheVm = _vmAntiAffinityRulesPerVm.get(ManagedObjectUtil.morefToString((ManagedObjectReference)vm));
                if (rulesForTheVm == null) {
                    rulesForTheVm = new HashSet<RuleInfo>();
                    _vmAntiAffinityRulesPerVm.put(ManagedObjectUtil.morefToString((ManagedObjectReference)vm), rulesForTheVm);
                }
                rulesForTheVm.add(rule);
            }
        }
    }

    private void buildVmAntiAffinityRulesPerVm(SdrsRuleInfo[] aaRules, Collection<RuleInfo> _dsClusterRules, Map<String, Set<RuleInfo>> _vmAntiAffinityRulesPerVm) {
        if (aaRules == null) {
            return;
        }
        for (SdrsRuleInfo rule : aaRules) {
            if (!this.isRuleRelevant(rule.rule, this.enabledRulesOnly) || !(rule.rule instanceof AntiAffinityRuleSpec)) continue;
            AntiAffinityRuleSpec antiAffinityRuleSpec = (AntiAffinityRuleSpec)rule.rule;
            block5: for (ManagedObjectReference vm : antiAffinityRuleSpec.vm) {
                Set<RuleInfo> rulesForTheVm = _vmAntiAffinityRulesPerVm.get(ManagedObjectUtil.morefToString((ManagedObjectReference)vm));
                if (rule.operation == null) {
                    _dsClusterRules.add(rule.rule);
                    if (rulesForTheVm == null) {
                        rulesForTheVm = new HashSet<RuleInfo>();
                        _vmAntiAffinityRulesPerVm.put(ManagedObjectUtil.morefToString((ManagedObjectReference)vm), rulesForTheVm);
                    }
                    rulesForTheVm.add(rule.rule);
                    continue;
                }
                switch (rule.operation) {
                    case add: 
                    case edit: {
                        _dsClusterRules.add(rule.rule);
                        if (rulesForTheVm == null) {
                            rulesForTheVm = new HashSet<RuleInfo>();
                            _vmAntiAffinityRulesPerVm.put(ManagedObjectUtil.morefToString((ManagedObjectReference)vm), rulesForTheVm);
                        }
                        rulesForTheVm.add(rule.rule);
                        continue block5;
                    }
                    case remove: {
                        if (rulesForTheVm == null) continue block5;
                        rulesForTheVm.remove(rule.rule);
                        _dsClusterRules.remove(rule.rule);
                        if (!rulesForTheVm.isEmpty()) continue block5;
                        _vmAntiAffinityRulesPerVm.remove(ManagedObjectUtil.morefToString((ManagedObjectReference)vm));
                        continue block5;
                    }
                    default: {
                        _logger.error((Object)"Invalid rule operation type.");
                    }
                }
            }
        }
    }
}

