/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.validation.impl;

import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.cluster.AntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.dscluster.DatastoreClusterNameValidationSpec;
import com.vmware.vsphere.client.dscluster.DsClusterValidationResult;
import com.vmware.vsphere.client.dscluster.util.SdrsRulesHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreClusterValidator {
    private static final Log _logger = LogFactory.getLog(DatastoreClusterValidator.class);
    private SdrsRulesHelper _ruleHelper;

    public DatastoreClusterValidator(SdrsRulesHelper ruleHelper) {
        this._ruleHelper = ruleHelper;
    }

    public static Boolean isDatastoreClusterNameUnique(DataService dataService, ManagedObjectReference moRef, DatastoreClusterNameValidationSpec spec) throws Exception {
        QuerySpec query = DatastoreClusterValidator.getDsClusterNameUniquenessCheckQuerySpec(dataService, moRef, spec.datastoreClusterName);
        ResultSet resultSet = QueryUtil.getData((DataService)dataService, (QuerySpec)query);
        Boolean isNameUnique = resultSet.items.length == 0;
        return isNameUnique;
    }

    public DsClusterValidationResult validateDefVmAffinity(boolean defVmAffEnabled) throws Exception {
        DsClusterValidationResult valRes = new DsClusterValidationResult();
        if (this._ruleHelper == null) {
            _logger.error((Object)"_ruleHelper cannot be null");
            return valRes;
        }
        if (!defVmAffEnabled) {
            List<RuleInfo> enabledDscRules = this._ruleHelper.getDsClusterRules();
            if (enabledDscRules.isEmpty()) {
                _logger.debug((Object)"No rules found - no validation");
                return valRes;
            }
            block0: for (RuleInfo rule : enabledDscRules) {
                if (!rule.enabled.booleanValue() || !(rule instanceof AntiAffinityRuleSpec)) continue;
                AntiAffinityRuleSpec vmAARule = (AntiAffinityRuleSpec)rule;
                for (ManagedObjectReference vmRef : vmAARule.vm) {
                    VmConfigInfo sdrsVmConfig = this._ruleHelper.getVmConfigInfo(vmRef);
                    if (sdrsVmConfig != null && sdrsVmConfig.intraVmAffinity != null && sdrsVmConfig.intraVmAffinity.booleanValue()) continue;
                    _logger.debug((Object)("VM AA conflicting rule found - " + vmAARule.name));
                    valRes.conflictingVmAARules.add(vmAARule.name);
                    continue block0;
                }
            }
        } else {
            Map<String, RuleInfo> vmdkAARulesMap = this._ruleHelper.getVmdkAntiAffinityRulesMap();
            if (vmdkAARulesMap.isEmpty()) {
                _logger.debug((Object)"No vmdk anti affinity rules found - no validation");
                return valRes;
            }
            for (Map.Entry<String, RuleInfo> vmdkAAEntry : vmdkAARulesMap.entrySet()) {
                ManagedObjectReference vmRef;
                VmConfigInfo sdrsVmConfig;
                String vmRefUid = vmdkAAEntry.getKey();
                RuleInfo vmdkAARule = vmdkAAEntry.getValue();
                if (StringUtils.isEmpty((CharSequence)vmRefUid)) {
                    _logger.debug((Object)"Null or empty key found");
                    continue;
                }
                if (vmdkAARule == null || !vmdkAARule.enabled.booleanValue() || (sdrsVmConfig = this._ruleHelper.getVmConfigInfo(vmRef = ManagedObjectUtil.stringToMoref((String)vmRefUid))) != null && sdrsVmConfig.intraVmAffinity != null && !sdrsVmConfig.intraVmAffinity.booleanValue()) continue;
                _logger.debug((Object)("VMDK AA conflicting rule found - " + vmdkAARule.name));
                valRes.conflictingVmdkAARules.add(vmdkAARule.name);
            }
        }
        return valRes;
    }

    private static QuerySpec getDsClusterNameUniquenessCheckQuerySpec(DataService dataService, ManagedObjectReference containerObjRef, String dsClusterName) throws Exception {
        ManagedObjectReference dsClusterParentRef = containerObjRef;
        ManagedObjectReference dsClusterRef = null;
        ArrayList<Object> listConstraints = new ArrayList<Object>();
        if (StoragePod.class.getSimpleName().equals(containerObjRef.getType())) {
            dsClusterParentRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)dataService, (Object)containerObjRef, (String)"parent");
            dsClusterRef = containerObjRef;
        }
        String childrenDsClusterPropName = "childrenDsClusters";
        if (Folder.class.getSimpleName().equals(dsClusterParentRef.getType())) {
            childrenDsClusterPropName = "childEntity";
        }
        Constraint dsClusterRelation = QueryUtil.createConstraintForRelationship((Object)dsClusterParentRef, (String)childrenDsClusterPropName, (String)"StoragePod");
        listConstraints.add(dsClusterRelation);
        PropertyConstraint dsClusterNameConstraint = QueryUtil.createPropertyConstraint((String)"StoragePod", (String)"name", (Comparator)Comparator.EQUALS, (Object)dsClusterName);
        listConstraints.add(dsClusterNameConstraint);
        if (dsClusterRef != null) {
            PropertyConstraint excludeCurrentDsClusterConstraint = QueryUtil.createPropertyConstraint((String)"StoragePod", (String)"id", (Comparator)Comparator.NOT_EQUALS, (Object)QueryUtil.getReferenceUid((Object)dsClusterRef));
            listConstraints.add(excludeCurrentDsClusterConstraint);
        }
        Constraint[] constraints = new Constraint[listConstraints.size()];
        listConstraints.toArray(constraints);
        Constraint nameUniquenessConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])constraints, (Conjoiner)Conjoiner.AND);
        return QueryUtil.buildQuerySpec((Constraint)nameUniquenessConstraint, (String[])new String[]{"name"});
    }
}

