/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder;

import com.vmware.vcenter.deployment.ImportHistoryTypes;
import com.vmware.vcenter.deployment.Notification;
import com.vmware.vcenter.deployment.Notifications;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazyImportStatusPropertyProvider
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(LazyImportStatusPropertyProvider.class);
    private static final String LAZY_IMPORT_STATUS = "lazyImportStatus";
    private static final String PENDING = "PENDING";
    private static final String BLOCKED = "BLOCKED";
    private static final String FAILED = "FAILED";
    private static final String PAUSED = "PAUSED";
    private static final String CANCELLED = "CANCELLED";
    private final DataServiceExtensionRegistry _extensionRegistry;
    private DataService _dataService;

    public LazyImportStatusPropertyProvider(DataServiceExtensionRegistry registry, DataService dataService) {
        this._extensionRegistry = registry;
        this._dataService = dataService;
    }

    public void initialize() {
        this._extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = Folder.class.getSimpleName();
        ti.properties = new String[]{LAZY_IMPORT_STATUS};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] vcenterObjects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (vcenterObjects == null || vcenterObjects.length == 0 || properties == null || properties.length == 0) {
            return null;
        }
        ArrayList<ResultItem> allResultItems = new ArrayList<ResultItem>();
        try {
            PropertyValue[] rawData;
            for (PropertyValue rawStatus : rawData = QueryUtil.getProperty((DataService)this._dataService, (Object[])vcenterObjects, (String)"lazyImportData")) {
                ManagedObjectReference moRef = (ManagedObjectReference)rawStatus.resourceObject;
                String vcName = VcServiceUtil.getServiceName((String)moRef.getServerGuid());
                ImportHistoryTypes.Info lazyImportJson = (ImportHistoryTypes.Info)rawStatus.value;
                String lazyImportstatus = lazyImportJson.getStatus().name().toString();
                if (!PENDING.equals(lazyImportstatus) && lazyImportJson.getResult() != null) {
                    lazyImportstatus = this.getLazyImportStatus(lazyImportJson.getResult(), lazyImportstatus);
                }
                PropertyValue calculatedValue = new PropertyValue();
                calculatedValue.resourceObject = moRef;
                calculatedValue.propertyName = LAZY_IMPORT_STATUS;
                StringBuilder response = new StringBuilder(vcName);
                response.append(":").append(lazyImportstatus);
                calculatedValue.value = response.toString();
                ResultItem resultItem = new ResultItem();
                resultItem.resourceObject = moRef;
                resultItem.properties = new PropertyValue[]{calculatedValue};
                allResultItems.add(resultItem);
            }
        }
        catch (Exception dataServiceException) {
            _logger.error((Object)("Exception occured when trying to get the lazyImport status " + dataServiceException));
        }
        ResultSet result = new ResultSet();
        result.items = allResultItems.toArray(new ResultItem[0]);
        return result;
    }

    public String getLazyImportStatus(Notifications result, String status) throws Exception {
        String errorId = null;
        try {
            if (result.getErrors() != null && result.getErrors().size() > 0 && result.getErrors().get(0) != null) {
                errorId = ((Notification)result.getErrors().get(0)).getId();
            }
            if (BLOCKED.equals(status) || FAILED.equals(status)) {
                status = errorId != null && errorId.isEmpty() ? (BLOCKED.equals(status) ? PAUSED : CANCELLED) : (BLOCKED.equals(status) ? BLOCKED : FAILED);
            }
            return status;
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception occured while computing the Lazy import status" + ex));
            return PENDING;
        }
    }
}

